/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import smile.data.Attribute;
import smile.data.NominalAttribute;
import smile.data.NumericAttribute;
import smile.feature.Feature;

public class Nominal2Binary
implements Feature<double[]> {
    private Attribute[] attributes;
    private Attribute[] features;
    private int[] map;
    private int[] value;

    public Nominal2Binary(Attribute[] attributes) {
        this.attributes = attributes;
        int p = 0;
        for (Attribute attribute : attributes) {
            if (!(attribute instanceof NominalAttribute)) continue;
            NominalAttribute nominal = (NominalAttribute)attribute;
            p += nominal.size();
        }
        this.features = new Attribute[p];
        this.map = new int[p];
        this.value = new int[p];
        int i = 0;
        for (int j = 0; j < attributes.length; ++j) {
            Attribute attribute = attributes[j];
            if (!(attribute instanceof NominalAttribute)) continue;
            NominalAttribute nominal = (NominalAttribute)attribute;
            double weight = nominal.weight;
            String name = nominal.name;
            String description = nominal.description;
            int k = 0;
            while (k < nominal.size()) {
                this.features[i] = new NumericAttribute(name + "_" + k, description, weight);
                this.map[i] = j;
                this.value[i] = k++;
                ++i;
            }
        }
    }

    @Override
    public Attribute[] attributes() {
        return this.features;
    }

    @Override
    public double f(double[] object, int id) {
        if (object.length != this.attributes.length) {
            throw new IllegalArgumentException(String.format("Invalide object size %d, expected %d", object.length, this.attributes.length));
        }
        if (id < 0 || id >= this.features.length) {
            throw new IllegalArgumentException("Invalide feature id: " + id);
        }
        if (object[this.map[id]] == (double)this.value[id]) {
            return 1.0;
        }
        return 0.0;
    }
}

