/*
 * Decompiled with CFR 0.152.
 */
package smile.imputation;

import smile.imputation.KNNImputation;
import smile.imputation.MissingValueImputation;
import smile.imputation.MissingValueImputationException;
import smile.math.Math;
import smile.sort.QuickSort;

public class LLSImputation
implements MissingValueImputation {
    private int k;

    public LLSImputation(int k) {
        if (k < 1) {
            throw new IllegalArgumentException("Invalid number of rows for imputation: " + k);
        }
        this.k = k;
    }

    @Override
    public void impute(double[][] data) throws MissingValueImputationException {
        int i;
        int d = data[0].length;
        if ((double)d < 1.5 * (double)this.k) {
            throw new IllegalArgumentException("The dimensionality of data is too small compared to k = " + this.k);
        }
        int[] count = new int[data[0].length];
        for (i = 0; i < data.length; ++i) {
            int n = 0;
            for (int j = 0; j < data[i].length; ++j) {
                if (!Double.isNaN(data[i][j])) continue;
                ++n;
                int n2 = j;
                count[n2] = count[n2] + 1;
            }
            if (n != data[i].length) continue;
            throw new MissingValueImputationException("The whole row " + i + " is missing");
        }
        for (i = 0; i < data[0].length; ++i) {
            if (count[i] != data.length) continue;
            throw new MissingValueImputationException("The whole column " + i + " is missing");
        }
        double[] dist = new double[data.length];
        for (int i2 = 0; i2 < data.length; ++i2) {
            int j;
            double[] x = data[i2];
            int missing = 0;
            for (j = 0; j < x.length; ++j) {
                if (!Double.isNaN(x[j])) continue;
                ++missing;
            }
            if (missing == 0) continue;
            for (j = 0; j < data.length; ++j) {
                double[] y = data[j];
                int n = 0;
                dist[j] = 0.0;
                for (int m = 0; m < x.length; ++m) {
                    if (Double.isNaN(x[m]) || Double.isNaN(y[m])) continue;
                    ++n;
                    int n3 = j;
                    dist[n3] = dist[n3] + (x[m] - y[m]) * (x[m] - y[m]);
                }
                dist[j] = n != x.length - missing ? (double)x.length * dist[j] / (double)n : Double.MAX_VALUE;
            }
            double[][] dat = new double[data.length][];
            for (int j2 = 0; j2 < data.length; ++j2) {
                dat[j2] = data[j2];
            }
            QuickSort.sort(dist, (Object[])dat);
            double[][] A = new double[d - missing][this.k];
            double[] B = new double[d - missing];
            int m = 0;
            for (int j3 = 0; j3 < d; ++j3) {
                if (Double.isNaN(data[i2][j3])) continue;
                for (int l = 0; l < this.k; ++l) {
                    A[m][l] = dat[l][j3];
                }
                B[m++] = dat[i2][j3];
            }
            boolean sufficient = true;
            for (m = 0; m < A.length; ++m) {
                for (int n = 0; n < this.k; ++n) {
                    if (!Double.isNaN(A[m][n])) continue;
                    sufficient = false;
                    break;
                }
                if (!sufficient) break;
            }
            if (!sufficient) continue;
            double[] s = Math.solve(A, B);
            for (int j4 = 0; j4 < d; ++j4) {
                if (!Double.isNaN(data[i2][j4])) continue;
                data[i2][j4] = 0.0;
                for (int l = 0; l < this.k; ++l) {
                    double[] dArray = data[i2];
                    int n = j4;
                    dArray[n] = dArray[n] + s[l] * dat[l][j4];
                }
            }
        }
        KNNImputation knn = new KNNImputation(this.k);
        knn.impute(data);
    }
}

