/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import smile.math.Math;
import smile.math.random.RandomNumberGenerator;
import smile.math.random.UniversalGenerator;

public class Random {
    private RandomNumberGenerator rng;

    public Random() {
        this(new UniversalGenerator());
    }

    public Random(long seed) {
        this(new UniversalGenerator(seed));
    }

    public Random(RandomNumberGenerator rng) {
        this.rng = rng;
    }

    public double nextDouble() {
        return this.rng.nextDouble();
    }

    public void nextDoubles(double[] d) {
        this.rng.nextDoubles(d);
    }

    public double nextDouble(double lo, double hi) {
        return lo + (hi - lo) * this.nextDouble();
    }

    public void nextDoubles(double[] d, double lo, double hi) {
        this.rng.nextDoubles(d);
        double l = hi - lo;
        int n = d.length;
        for (int i = 0; i < n; ++i) {
            d[i] = lo + l * d[i];
        }
    }

    public int nextInt() {
        return this.rng.nextInt();
    }

    public int nextInt(int n) {
        return this.rng.nextInt(n);
    }

    public long nextLong() {
        return this.rng.nextLong();
    }

    public int[] permutate(int n) {
        int[] x = new int[n];
        for (int i = 0; i < n; ++i) {
            x[i] = i;
        }
        this.permutate(x);
        return x;
    }

    public void permutate(int[] x) {
        for (int i = 0; i < x.length; ++i) {
            int j = i + this.nextInt(x.length - i);
            Math.swap(x, i, j);
        }
    }

    public void permutate(float[] x) {
        for (int i = 0; i < x.length; ++i) {
            int j = i + this.nextInt(x.length - i);
            Math.swap(x, i, j);
        }
    }

    public void permutate(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            int j = i + this.nextInt(x.length - i);
            Math.swap(x, i, j);
        }
    }

    public void permutate(Object[] x) {
        for (int i = 0; i < x.length; ++i) {
            int j = i + this.nextInt(x.length - i);
            Math.swap(x, i, j);
        }
    }
}

