/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import smile.math.Math;
import smile.math.distance.Metric;

public class EditDistance
implements Metric<String> {
    private double[][] weight;
    private double r = -1.0;
    private boolean damerauDistance = false;
    private int[][] FKP;
    private BRF brf;

    public EditDistance(double[][] weight) {
        this.weight = weight;
    }

    public EditDistance(double[][] weight, double radius) {
        this.weight = weight;
        this.r = radius;
    }

    public EditDistance(int maxStringLength) {
        this(maxStringLength, false);
    }

    public EditDistance(int maxStringLength, boolean damerau) {
        this.FKP = new int[2 * maxStringLength + 1][maxStringLength + 2];
        this.damerauDistance = damerau;
        this.brf = damerau ? new BRF2() : new BRF1();
    }

    public String toString() {
        if (this.damerauDistance) {
            return "Damerau-Levenshtein distance";
        }
        return "Levenshtein distance";
    }

    @Override
    public double d(String x, String y) {
        if (this.weight != null) {
            return this.weightedEdit(x, y);
        }
        if (x.length() == 1 || y.length() == 1) {
            if (this.damerauDistance) {
                return EditDistance.damerau(x, y);
            }
            return EditDistance.levenshtein(x, y);
        }
        return this.br(x, y);
    }

    @Override
    public double d(char[] x, char[] y) {
        if (this.weight != null) {
            return this.weightedEdit(x, y);
        }
        if (x.length == 1 || y.length == 1) {
            if (this.damerauDistance) {
                return EditDistance.damerau(x, y);
            }
            return EditDistance.levenshtein(x, y);
        }
        return this.br(x, y);
    }

    private double weightedEdit(char[] x, char[] y) {
        if (x.length < y.length) {
            char[] swap = x;
            x = y;
            y = swap;
        }
        int radius = (int)Math.round(this.r * (double)Math.max(x.length, y.length));
        double[][] d = new double[2][y.length + 1];
        d[0][0] = 0.0;
        for (int j = 1; j <= y.length; ++j) {
            d[0][j] = d[0][j - 1] + this.weight[0][y[j]];
        }
        for (int i = 1; i <= x.length; ++i) {
            d[1][0] = d[0][0] + this.weight[x[i]][0];
            int start2 = 1;
            int end = y.length;
            if (radius > 0) {
                start2 = i - radius;
                if (start2 > 1) {
                    d[1][start2 - 1] = Double.POSITIVE_INFINITY;
                } else {
                    start2 = 1;
                }
                end = i + radius;
                if (end < y.length) {
                    d[1][end + 1] = Double.POSITIVE_INFINITY;
                } else {
                    end = y.length;
                }
            }
            for (int j = start2; j <= end; ++j) {
                double cost = this.weight[x[i - 1]][y[j - 1]];
                d[1][j] = Math.min(d[0][j] + this.weight[x[i - 1]][0], d[1][j - 1] + this.weight[0][y[j - 1]], d[0][j - 1] + cost);
            }
            double[] swap = d[0];
            d[0] = d[1];
            d[1] = swap;
        }
        return d[0][y.length];
    }

    private double weightedEdit(String x, String y) {
        if (x.length() < y.length()) {
            String swap = x;
            x = y;
            y = swap;
        }
        int radius = (int)Math.round(this.r * (double)Math.max(x.length(), y.length()));
        double[][] d = new double[2][y.length() + 1];
        d[0][0] = 0.0;
        for (int j = 1; j <= y.length(); ++j) {
            d[0][j] = d[0][j - 1] + this.weight[0][y.charAt(j)];
        }
        for (int i = 1; i <= x.length(); ++i) {
            d[1][0] = d[0][0] + this.weight[x.charAt(i)][0];
            int start2 = 1;
            int end = y.length();
            if (radius > 0) {
                start2 = i - radius;
                if (start2 > 1) {
                    d[1][start2 - 1] = Double.POSITIVE_INFINITY;
                } else {
                    start2 = 1;
                }
                end = i + radius;
                if (end < y.length()) {
                    d[1][end + 1] = Double.POSITIVE_INFINITY;
                } else {
                    end = y.length();
                }
            }
            for (int j = start2; j <= end; ++j) {
                double cost = this.weight[x.charAt(i - 1)][y.charAt(j - 1)];
                d[1][j] = Math.min(d[0][j] + this.weight[x.charAt(i - 1)][0], d[1][j - 1] + this.weight[0][y.charAt(j - 1)], d[0][j - 1] + cost);
            }
            double[] swap = d[0];
            d[0] = d[1];
            d[1] = swap;
        }
        return d[0][y.length()];
    }

    private int br(char[] x, char[] y) {
        int p;
        int k;
        int n;
        if (x.length > y.length) {
            char[] swap = x;
            x = y;
            y = swap;
        }
        int m = x.length;
        int ZERO_K = n = y.length;
        if (n + 2 > this.FKP[0].length) {
            this.FKP = new int[2 * n + 1][n + 2];
        }
        for (k = -ZERO_K; k < 0; ++k) {
            p = -k - 1;
            this.FKP[k + ZERO_K][p + 1] = Math.abs(k) - 1;
            this.FKP[k + ZERO_K][p] = -2147483647;
        }
        this.FKP[ZERO_K][0] = -1;
        for (k = 1; k <= ZERO_K; ++k) {
            p = k - 1;
            this.FKP[k + ZERO_K][p + 1] = -1;
            this.FKP[k + ZERO_K][p] = -2147483647;
        }
        int p2 = n - m - 1;
        do {
            int i;
            for (i = (++p2 - (n - m)) / 2; i >= 1; --i) {
                this.brf.f(x, y, this.FKP, ZERO_K, n - m + i, p2 - i);
            }
            for (i = (n - m + p2) / 2; i >= 1; --i) {
                this.brf.f(x, y, this.FKP, ZERO_K, n - m - i, p2 - i);
            }
            this.brf.f(x, y, this.FKP, ZERO_K, n - m, p2);
        } while (this.FKP[n - m + ZERO_K][p2] != m);
        return p2 - 1;
    }

    private int br(String x, String y) {
        int p;
        int k;
        int n;
        if (x.length() > y.length()) {
            String swap = x;
            x = y;
            y = swap;
        }
        int m = x.length();
        int ZERO_K = n = y.length();
        if (n + 3 > this.FKP[0].length) {
            this.FKP = new int[2 * n + 1][n + 3];
        }
        for (k = -ZERO_K; k < 0; ++k) {
            p = -k - 1;
            this.FKP[k + ZERO_K][p + 1] = Math.abs(k) - 1;
            this.FKP[k + ZERO_K][p] = -2147483647;
        }
        this.FKP[ZERO_K][0] = -1;
        for (k = 1; k <= ZERO_K; ++k) {
            p = k - 1;
            this.FKP[k + ZERO_K][p + 1] = -1;
            this.FKP[k + ZERO_K][p] = -2147483647;
        }
        int p2 = n - m - 1;
        do {
            int i;
            for (i = (++p2 - (n - m)) / 2; i >= 1; --i) {
                this.brf.f(x, y, this.FKP, ZERO_K, n - m + i, p2 - i);
            }
            for (i = (n - m + p2) / 2; i >= 1; --i) {
                this.brf.f(x, y, this.FKP, ZERO_K, n - m - i, p2 - i);
            }
            this.brf.f(x, y, this.FKP, ZERO_K, n - m, p2);
        } while (this.FKP[n - m + ZERO_K][p2] != m);
        return p2 - 1;
    }

    public static int levenshtein(String x, String y) {
        if (x.length() < y.length()) {
            String swap = x;
            x = y;
            y = swap;
        }
        int[][] d = new int[2][y.length() + 1];
        for (int j = 0; j <= y.length(); ++j) {
            d[0][j] = j;
        }
        for (int i = 1; i <= x.length(); ++i) {
            d[1][0] = i;
            for (int j = 1; j <= y.length(); ++j) {
                int cost = x.charAt(i - 1) == y.charAt(j - 1) ? 0 : 1;
                d[1][j] = Math.min(d[0][j] + 1, d[1][j - 1] + 1, d[0][j - 1] + cost);
            }
            int[] swap = d[0];
            d[0] = d[1];
            d[1] = swap;
        }
        return d[0][y.length()];
    }

    public static int levenshtein(char[] x, char[] y) {
        if (x.length < y.length) {
            char[] swap = x;
            x = y;
            y = swap;
        }
        int[][] d = new int[2][y.length + 1];
        for (int j = 0; j <= y.length; ++j) {
            d[0][j] = j;
        }
        for (int i = 1; i <= x.length; ++i) {
            d[1][0] = i;
            for (int j = 1; j <= y.length; ++j) {
                int cost = x[i - 1] == y[j - 1] ? 0 : 1;
                d[1][j] = Math.min(d[0][j] + 1, d[1][j - 1] + 1, d[0][j - 1] + cost);
            }
            int[] swap = d[0];
            d[0] = d[1];
            d[1] = swap;
        }
        return d[0][y.length];
    }

    public static int damerau(String x, String y) {
        if (x.length() < y.length()) {
            String swap = x;
            x = y;
            y = swap;
        }
        int[][] d = new int[3][y.length() + 1];
        for (int j = 0; j <= y.length(); ++j) {
            d[1][j] = j;
        }
        for (int i = 1; i <= x.length(); ++i) {
            d[2][0] = i;
            for (int j = 1; j <= y.length(); ++j) {
                int cost = x.charAt(i - 1) == y.charAt(j - 1) ? 0 : 1;
                d[2][j] = Math.min(d[1][j] + 1, d[2][j - 1] + 1, d[1][j - 1] + cost);
                if (i <= 1 || j <= 1 || x.charAt(i - 1) != y.charAt(j - 2) || x.charAt(i - 2) != y.charAt(j - 1)) continue;
                d[2][j] = Math.min(d[2][j], d[0][j - 2] + cost);
            }
            int[] swap = d[0];
            d[0] = d[1];
            d[1] = d[2];
            d[2] = swap;
        }
        return d[1][y.length()];
    }

    public static int damerau(char[] x, char[] y) {
        if (x.length < y.length) {
            char[] swap = x;
            x = y;
            y = swap;
        }
        int[][] d = new int[3][y.length + 1];
        for (int j = 0; j <= y.length; ++j) {
            d[1][j] = j;
        }
        for (int i = 1; i <= x.length; ++i) {
            d[2][0] = i;
            for (int j = 1; j <= y.length; ++j) {
                int cost = x[i - 1] == y[j - 1] ? 0 : 1;
                d[2][j] = Math.min(d[1][j] + 1, d[2][j - 1] + 1, d[1][j - 1] + cost);
                if (i <= 1 || j <= 1 || x[i - 1] != y[j - 2] || x[i - 2] != y[j - 1]) continue;
                d[2][j] = Math.min(d[2][j], d[0][j - 2] + cost);
            }
            int[] swap = d[0];
            d[0] = d[1];
            d[1] = d[2];
            d[2] = swap;
        }
        return d[1][y.length];
    }

    private static class BRF2
    implements BRF {
        private BRF2() {
        }

        @Override
        public void f(char[] x, char[] y, int[][] FKP, int ZERO_K, int k, int p) {
            int t = FKP[k + ZERO_K][p] + 1;
            if (t > 1 && k + t > 1 && t < Math.min(x.length, y.length - k) && x[t - 1] == y[k + t] && x[t] == y[k + t - 1]) {
                ++t;
            }
            for (t = Math.max(FKP[k - 1 + ZERO_K][p], FKP[k + 1 + ZERO_K][p] + 1, t); t < Math.min(x.length, y.length - k) && x[t] == y[t + k]; ++t) {
            }
            FKP[k + ZERO_K][p + 1] = t;
        }

        @Override
        public void f(String x, String y, int[][] FKP, int ZERO_K, int k, int p) {
            int t = FKP[k + ZERO_K][p] + 1;
            if (t > 1 && k + t > 1 && t < Math.min(x.length(), y.length() - k) && x.charAt(t - 1) == y.charAt(k + t) && x.charAt(t) == y.charAt(k + t - 1)) {
                ++t;
            }
            for (t = Math.max(FKP[k - 1 + ZERO_K][p], FKP[k + 1 + ZERO_K][p] + 1, t); t < Math.min(x.length(), y.length() - k) && x.charAt(t) == y.charAt(t + k); ++t) {
            }
            FKP[k + ZERO_K][p + 1] = t;
        }
    }

    private static class BRF1
    implements BRF {
        private BRF1() {
        }

        @Override
        public void f(char[] x, char[] y, int[][] FKP, int ZERO_K, int k, int p) {
            int t;
            for (t = Math.max(FKP[k + ZERO_K][p] + 1, FKP[k - 1 + ZERO_K][p], FKP[k + 1 + ZERO_K][p] + 1); t < Math.min(x.length, y.length - k) && x[t] == y[t + k]; ++t) {
            }
            FKP[k + ZERO_K][p + 1] = t;
        }

        @Override
        public void f(String x, String y, int[][] FKP, int ZERO_K, int k, int p) {
            int t;
            for (t = Math.max(FKP[k + ZERO_K][p] + 1, FKP[k - 1 + ZERO_K][p], FKP[k + 1 + ZERO_K][p] + 1); t < Math.min(x.length(), y.length() - k) && x.charAt(t) == y.charAt(t + k); ++t) {
            }
            FKP[k + ZERO_K][p + 1] = t;
        }
    }

    private static interface BRF {
        public void f(char[] var1, char[] var2, int[][] var3, int var4, int var5, int var6);

        public void f(String var1, String var2, int[][] var3, int var4, int var5, int var6);
    }
}

