/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.Math;
import smile.math.kernel.MercerKernel;

public class GaussianKernel
implements MercerKernel<double[]> {
    private double gamma;

    public GaussianKernel(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma is not positive.");
        }
        this.gamma = 0.5 / (sigma * sigma);
    }

    public String toString() {
        return String.format("Gaussian Kernel (\u02e0 = %.4f)", Math.sqrt(0.5 / this.gamma));
    }

    @Override
    public double k(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        return Math.exp(-this.gamma * Math.squaredDistance(x, y));
    }
}

