/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.util.Arrays;
import smile.math.matrix.EigenValueDecomposition;
import smile.math.matrix.IMatrix;

public class BandMatrix
implements IMatrix {
    private double[][] A;
    private int n;
    private int m1;
    private int m2;
    private double[][] au;
    private double[][] al;
    private int[] index;
    private double d;

    public BandMatrix(int n, int m) {
        this(n, m, m);
    }

    public BandMatrix(int n, int m1, int m2) {
        this.n = n;
        this.m1 = m1;
        this.m2 = m2;
        this.A = new double[n][m1 + m2 + 1];
    }

    @Override
    public int nrows() {
        return this.n;
    }

    @Override
    public int ncols() {
        return this.n;
    }

    @Override
    public double get(int i, int j) {
        return this.A[i][j - i + this.m1];
    }

    @Override
    public BandMatrix set(int i, int j, double x) {
        this.A[i][j - i + this.m1] = x;
        return this;
    }

    public BandMatrix transpose() {
        BandMatrix at = new BandMatrix(this.n, this.m2, this.m1);
        for (int i = 0; i < this.n; ++i) {
            for (int j = i - this.m2; j <= i + this.m1; ++j) {
                if (j < 0 || j >= this.n) continue;
                at.set(i, j, this.get(j, i));
            }
        }
        return at;
    }

    public double eigen(double[] v) {
        if (this.m1 != this.m2) {
            throw new UnsupportedOperationException("The matrix is not square.");
        }
        return EigenValueDecomposition.eigen(this, v);
    }

    public EigenValueDecomposition eigen(int k) {
        if (this.m1 != this.m2) {
            throw new UnsupportedOperationException("The matrix is not square.");
        }
        return EigenValueDecomposition.decompose(this, k);
    }

    public double det() {
        if (this.au == null) {
            this.decompose();
        }
        double dd = this.d;
        for (int i = 0; i < this.n; ++i) {
            dd *= this.au[i][0];
        }
        return dd;
    }

    public void decompose() {
        double TINY = 1.0E-40;
        int mm = this.m1 + this.m2 + 1;
        this.index = new int[this.n];
        this.au = new double[this.n][mm];
        this.al = new double[this.n][this.m1];
        for (int i = 0; i < this.A.length; ++i) {
            System.arraycopy(this.A[i], 0, this.au[i], 0, this.A[i].length);
        }
        int l = this.m1;
        for (int i = 0; i < this.m1; ++i) {
            int j;
            for (j = this.m1 - i; j < mm; ++j) {
                this.au[i][j - l] = this.au[i][j];
            }
            for (j = mm - --l - 1; j < mm; ++j) {
                this.au[i][j] = 0.0;
            }
        }
        this.d = 1.0;
        l = this.m1;
        for (int k = 0; k < this.n; ++k) {
            int j;
            double dum = this.au[k][0];
            int i = k;
            if (l < this.n) {
                ++l;
            }
            for (j = k + 1; j < l; ++j) {
                if (!(Math.abs(this.au[j][0]) > Math.abs(dum))) continue;
                dum = this.au[j][0];
                i = j;
            }
            this.index[k] = i + 1;
            if (dum == 0.0) {
                this.au[k][0] = 1.0E-40;
            }
            if (i != k) {
                this.d = -this.d;
                double[] swap = this.au[k];
                this.au[k] = this.au[i];
                this.au[i] = swap;
            }
            for (i = k + 1; i < l; ++i) {
                this.al[k][i - k - 1] = dum = this.au[i][0] / this.au[k][0];
                for (j = 1; j < mm; ++j) {
                    this.au[i][j - 1] = this.au[i][j] - dum * this.au[k][j];
                }
                this.au[i][mm - 1] = 0.0;
            }
        }
    }

    @Override
    public void ax(double[] x, double[] y) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but x is %d x 1", this.n, this.n, x.length));
        }
        if (y.length != this.n) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but y is %d x 1", this.n, this.n, y.length));
        }
        Arrays.fill(y, 0.0);
        for (int i = 0; i < this.n; ++i) {
            int k = i - this.m1;
            int tmploop = Math.min(this.m1 + this.m2 + 1, this.n - k);
            for (int j = Math.max(0, -k); j < tmploop; ++j) {
                int n = i;
                y[n] = y[n] + this.A[i][j] * x[j + k];
            }
        }
    }

    @Override
    public void axpy(double[] x, double[] y) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but x is %d x 1", this.n, this.n, x.length));
        }
        if (y.length != this.n) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but y is %d x 1", this.n, this.n, y.length));
        }
        for (int i = 0; i < this.n; ++i) {
            int k = i - this.m1;
            int tmploop = Math.min(this.m1 + this.m2 + 1, this.n - k);
            for (int j = Math.max(0, -k); j < tmploop; ++j) {
                int n = i;
                y[n] = y[n] + this.A[i][j] * x[j + k];
            }
        }
    }

    @Override
    public void axpy(double[] x, double[] y, double b) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but x is %d x 1", this.n, this.n, x.length));
        }
        if (y.length != this.n) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but y is %d x 1", this.n, this.n, y.length));
        }
        for (int i = 0; i < this.n; ++i) {
            int k = i - this.m1;
            int tmploop = Math.min(this.m1 + this.m2 + 1, this.n - k);
            int n = i;
            y[n] = y[n] * b;
            for (int j = Math.max(0, -k); j < tmploop; ++j) {
                int n2 = i;
                y[n2] = y[n2] + this.A[i][j] * x[j + k];
            }
        }
    }

    @Override
    public void atx(double[] x, double[] y) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Column dimensions do not agree: A is %d x %d, but x is 1 x %d", this.n, this.n, x.length));
        }
        if (y.length != this.n) {
            throw new IllegalArgumentException(String.format("Column dimensions do not agree: A is %d x %d, but y is 1 x %d", this.n, this.n, y.length));
        }
        Arrays.fill(y, 0.0);
        for (int i = 0; i < this.n; ++i) {
            for (int j = -this.m2; j <= this.m1; ++j) {
                if (i + j < 0 || i + j >= this.n) continue;
                int n = i;
                y[n] = y[n] + this.A[i + j][this.m1 - j] * x[i + j];
            }
        }
    }

    @Override
    public void atxpy(double[] x, double[] y) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Column dimensions do not agree: A is %d x %d, but x is 1 x %d", this.n, this.n, x.length));
        }
        if (y.length != this.n) {
            throw new IllegalArgumentException(String.format("Column dimensions do not agree: A is %d x %d, but y is 1 x %d", this.n, this.n, y.length));
        }
        for (int i = 0; i < this.n; ++i) {
            for (int j = -this.m2; j <= this.m1; ++j) {
                if (i + j < 0 || i + j >= this.n) continue;
                int n = i;
                y[n] = y[n] + this.A[i + j][this.m1 - j] * x[i + j];
            }
        }
    }

    @Override
    public void atxpy(double[] x, double[] y, double b) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Column dimensions do not agree: A is %d x %d, but x is 1 x %d", this.n, this.n, x.length));
        }
        if (y.length != this.n) {
            throw new IllegalArgumentException(String.format("Column dimensions do not agree: A is %d x %d, but y is 1 x %d", this.n, this.n, y.length));
        }
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            y[n] = y[n] * b;
            for (int j = -this.m2; j <= this.m1; ++j) {
                if (i + j < 0 || i + j >= this.n) continue;
                int n2 = i;
                y[n2] = y[n2] + this.A[i + j][this.m1 - j] * x[i + j];
            }
        }
    }

    @Override
    public void asolve(double[] b, double[] x) {
        for (int i = 0; i < this.n; ++i) {
            x[i] = this.A[i][this.m1] != 0.0 ? b[i] / this.A[i][this.m1] : b[i];
        }
    }

    public void solve(double[] b) {
        this.solve(b, b);
    }

    public void solve(double[] b, double[] x) {
        if (b.length != this.n) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but b is %d x 1", this.n, this.n, b.length));
        }
        if (b.length != x.length) {
            throw new IllegalArgumentException("b and x dimensions do not agree.");
        }
        if (this.au == null) {
            this.decompose();
        }
        System.arraycopy(b, 0, x, 0, this.n);
        int mm = this.m1 + this.m2 + 1;
        int l = this.m1;
        for (int k = 0; k < this.n; ++k) {
            int j = this.index[k] - 1;
            if (j != k) {
                double swap = x[k];
                x[k] = x[j];
                x[j] = swap;
            }
            if (l < this.n) {
                ++l;
            }
            for (j = k + 1; j < l; ++j) {
                int n = j;
                x[n] = x[n] - this.al[k][j - k - 1] * x[k];
            }
        }
        l = 1;
        for (int i = this.n - 1; i >= 0; --i) {
            double dum = x[i];
            for (int k = 1; k < l; ++k) {
                dum -= this.au[i][k] * x[k + i];
            }
            x[i] = dum / this.au[i][0];
            if (l >= mm) continue;
            ++l;
        }
    }

    public void improve(double[] b, double[] x) {
        if (b.length != this.n || x.length != this.n) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but b is %d x 1 and x is %d x 1", this.n, this.n, b.length, x.length));
        }
        double[] r = (double[])b.clone();
        this.axpy(x, r, -1.0);
        this.solve(r);
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            x[n] = x[n] - r[i];
        }
    }
}

