/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import smile.math.Math;
import smile.projection.Projection;

public class GHA
implements Projection<double[]> {
    private int p;
    private int n;
    private double r;
    private double[][] projection;
    private double[] y;
    private double[] wy;

    public GHA(int n, int p, double r) {
        if (n < 2) {
            throw new IllegalArgumentException("Invalid dimension of input space: " + n);
        }
        if (p < 1 || p > n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + p);
        }
        this.n = n;
        this.p = p;
        this.r = r;
        this.y = new double[p];
        this.wy = new double[n];
        this.projection = new double[p][n];
        for (int i = 0; i < p; ++i) {
            for (int j = 0; j < n; ++j) {
                this.projection[i][j] = 0.1 * Math.random();
            }
        }
    }

    public GHA(double[][] w, double r) {
        this.p = w.length;
        this.n = w[0].length;
        this.r = r;
        this.y = new double[this.p];
        this.wy = new double[this.n];
        this.projection = w;
    }

    public double[][] getProjection() {
        return this.projection;
    }

    public double getLearningRate() {
        return this.r;
    }

    public GHA setLearningRate(double r) {
        this.r = r;
        return this;
    }

    @Override
    public double[] project(double[] x) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.n));
        }
        double[] wx = new double[this.p];
        Math.ax(this.projection, x, wx);
        return wx;
    }

    public double[][] project(double[][] x) {
        if (x[0].length != this.n) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x[0].length, this.n));
        }
        double[][] wx = new double[x.length][this.p];
        for (int i = 0; i < x.length; ++i) {
            Math.ax(this.projection, x[i], wx[i]);
        }
        return wx;
    }

    public double learn(double[] x) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.n));
        }
        Math.ax(this.projection, x, this.y);
        for (int j = 0; j < this.p; ++j) {
            for (int i = 0; i < this.n; ++i) {
                double delta = x[i];
                for (int l = 0; l <= j; ++l) {
                    delta -= this.projection[l][i] * this.y[l];
                }
                double[] dArray = this.projection[j];
                int n = i;
                dArray[n] = dArray[n] + this.r * this.y[j] * delta;
                if (!Double.isInfinite(this.projection[j][i])) continue;
                throw new IllegalStateException("GHA lost convergence. Lower learning rate?");
            }
        }
        Math.ax(this.projection, x, this.y);
        Math.atx(this.projection, this.y, this.wy);
        return Math.squaredDistance(x, this.wy);
    }
}

