/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import smile.math.Math;
import smile.math.matrix.EigenValueDecomposition;
import smile.math.matrix.SingularValueDecomposition;
import smile.projection.Projection;

public class PCA
implements Projection<double[]> {
    private int p;
    private int n;
    private double[] mu;
    private double[] pmu;
    private double[][] eigvectors;
    private double[] eigvalues;
    private double[] proportion;
    private double[] cumulativeProportion;
    private double[][] projection;

    public PCA(double[][] data) {
        this(data, false);
    }

    public PCA(double[][] data, boolean cor) {
        int i;
        int m = data.length;
        this.n = data[0].length;
        this.mu = Math.colMean(data);
        double[][] x = Math.clone(data);
        for (int i2 = 0; i2 < m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                x[i2][j] = data[i2][j] - this.mu[j];
            }
        }
        if (m > this.n && !cor) {
            SingularValueDecomposition svd = SingularValueDecomposition.decompose(x);
            this.eigvalues = svd.getSingularValues();
            for (i = 0; i < this.eigvalues.length; ++i) {
                int n = i;
                this.eigvalues[n] = this.eigvalues[n] * this.eigvalues[i];
            }
            this.eigvectors = svd.getV();
        } else {
            int j;
            int i3;
            double[][] cov = new double[this.n][this.n];
            for (int k = 0; k < m; ++k) {
                for (i3 = 0; i3 < this.n; ++i3) {
                    for (j = 0; j <= i3; ++j) {
                        double[] dArray = cov[i3];
                        int n = j;
                        dArray[n] = dArray[n] + x[k][i3] * x[k][j];
                    }
                }
            }
            for (i = 0; i < this.n; ++i) {
                for (int j2 = 0; j2 <= i; ++j2) {
                    double[] dArray = cov[i];
                    int n = j2;
                    dArray[n] = dArray[n] / (double)m;
                    cov[j2][i] = cov[i][j2];
                }
            }
            double[] sd = null;
            if (cor) {
                sd = new double[this.n];
                for (i3 = 0; i3 < this.n; ++i3) {
                    sd[i3] = Math.sqrt(cov[i3][i3]);
                }
                for (i3 = 0; i3 < this.n; ++i3) {
                    for (j = 0; j <= i3; ++j) {
                        double[] dArray = cov[i3];
                        int n = j;
                        dArray[n] = dArray[n] / (sd[i3] * sd[j]);
                        cov[j][i3] = cov[i3][j];
                    }
                }
            }
            EigenValueDecomposition eigen = EigenValueDecomposition.decompose(cov, true);
            double[][] loadings = eigen.getEigenVectors();
            if (cor) {
                for (int i4 = 0; i4 < this.n; ++i4) {
                    int j3 = 0;
                    while (j3 < this.n) {
                        double[] dArray = loadings[i4];
                        int n = j3++;
                        dArray[n] = dArray[n] / sd[i4];
                    }
                }
            }
            this.eigvalues = eigen.getEigenValues();
            this.eigvectors = loadings;
        }
        this.proportion = (double[])this.eigvalues.clone();
        Math.unitize1(this.proportion);
        this.cumulativeProportion = new double[this.eigvalues.length];
        this.cumulativeProportion[0] = this.proportion[0];
        for (int i5 = 1; i5 < this.eigvalues.length; ++i5) {
            this.cumulativeProportion[i5] = this.cumulativeProportion[i5 - 1] + this.proportion[i5];
        }
        this.setProjection(0.95);
    }

    public double[] getCenter() {
        return this.mu;
    }

    public double[][] getLoadings() {
        return this.eigvectors;
    }

    public double[] getVariance() {
        return this.eigvalues;
    }

    public double[] getVarianceProportion() {
        return this.proportion;
    }

    public double[] getCumulativeVarianceProportion() {
        return this.cumulativeProportion;
    }

    public double[][] getProjection() {
        return this.projection;
    }

    public PCA setProjection(int p) {
        if (p < 1 || p > this.n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + p);
        }
        this.p = p;
        this.projection = new double[p][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < p; ++j) {
                this.projection[j][i] = this.eigvectors[i][j];
            }
        }
        this.pmu = new double[p];
        Math.ax(this.projection, this.mu, this.pmu);
        return this;
    }

    public PCA setProjection(double p) {
        if (p <= 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid percentage of variance: " + p);
        }
        for (int k = 0; k < this.n; ++k) {
            if (!(this.cumulativeProportion[k] >= p)) continue;
            this.setProjection(k + 1);
            break;
        }
        return this;
    }

    @Override
    public double[] project(double[] x) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.n));
        }
        double[] y = new double[this.p];
        Math.ax(this.projection, x, y);
        Math.minus(y, this.pmu);
        return y;
    }

    public double[][] project(double[][] x) {
        if (x[0].length != this.mu.length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x[0].length, this.n));
        }
        double[][] y = new double[x.length][this.p];
        for (int i = 0; i < x.length; ++i) {
            Math.ax(this.projection, x[i], y[i]);
            Math.minus(y[i], this.pmu);
        }
        return y;
    }
}

