/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import smile.math.Math;
import smile.math.matrix.EigenValueDecomposition;
import smile.math.matrix.LUDecomposition;
import smile.projection.Projection;

public class PPCA
implements Projection<double[]> {
    private double[] mu;
    private double[] pmu;
    private double noise;
    private double[][] loading;
    private double[][] projection;

    public double[][] getLoadings() {
        return this.loading;
    }

    public double[] getCenter() {
        return this.mu;
    }

    public double getNoiseVariance() {
        return this.noise;
    }

    public double[][] getProjection() {
        return this.projection;
    }

    @Override
    public double[] project(double[] x) {
        if (x.length != this.mu.length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.mu.length));
        }
        double[] y = new double[this.projection.length];
        Math.ax(this.projection, x, y);
        Math.minus(y, this.pmu);
        return y;
    }

    public double[][] project(double[][] x) {
        if (x[0].length != this.mu.length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x[0].length, this.mu.length));
        }
        double[][] y = new double[x.length][this.projection.length];
        for (int i = 0; i < x.length; ++i) {
            Math.ax(this.projection, x[i], y[i]);
            Math.minus(y[i], this.pmu);
        }
        return y;
    }

    public PPCA(double[][] data, int k) {
        int i;
        int m = data.length;
        int n = data[0].length;
        this.mu = Math.colMean(data);
        double[][] cov = new double[n][n];
        for (int l = 0; l < m; ++l) {
            for (int i2 = 0; i2 < n; ++i2) {
                for (int j = 0; j <= i2; ++j) {
                    double[] dArray = cov[i2];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + (data[l][i2] - this.mu[i2]) * (data[l][j] - this.mu[j]);
                }
            }
        }
        for (int i3 = 0; i3 < n; ++i3) {
            for (int j = 0; j <= i3; ++j) {
                double[] dArray = cov[i3];
                int n3 = j;
                dArray[n3] = dArray[n3] / (double)m;
                cov[j][i3] = cov[i3][j];
            }
        }
        EigenValueDecomposition eigen = EigenValueDecomposition.decompose(cov, true);
        double[] evalues = eigen.getEigenValues();
        double[][] evectors = eigen.getEigenVectors();
        this.noise = 0.0;
        for (i = k; i < n; ++i) {
            this.noise += evalues[i];
        }
        this.noise /= (double)(n - k);
        this.loading = new double[n][k];
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < k; ++j) {
                this.loading[i][j] = evectors[i][j] * Math.sqrt(evalues[j] - this.noise);
            }
        }
        double[][] M = Math.atamm(this.loading);
        int i4 = 0;
        while (i4 < k) {
            double[] dArray = M[i4];
            int n4 = i4++;
            dArray[n4] = dArray[n4] + this.noise;
        }
        LUDecomposition lu = new LUDecomposition(M, true);
        double[][] Mi = lu.inverse();
        this.projection = Math.abtmm(Mi, this.loading);
        this.pmu = new double[this.projection.length];
        Math.ax(this.projection, this.mu, this.pmu);
    }
}

