/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.util.Arrays;
import smile.math.Math;
import smile.math.matrix.IMatrix;
import smile.regression.Regression;
import smile.regression.RegressionTrainer;

public class LASSO
implements Regression<double[]> {
    private int p;
    private double lambda;
    private double b;
    private double[] w;
    private double ym;
    private double[] center;
    private double[] scale;

    public LASSO(double[][] x, double[] y, double lambda) {
        this(x, y, lambda, 0.001, 5000);
    }

    public LASSO(double[][] x, double[] y, double lambda, double tol, int maxIter) {
        int ntiter;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("Invalid shrinkage/regularization parameter lambda = " + lambda);
        }
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        int MU = 2;
        double ALPHA = 0.01;
        double BETA = 0.5;
        int MAX_LS_ITER = 100;
        int pcgmaxi = 5000;
        double eta = 0.001;
        int pitr = 0;
        int n = x.length;
        this.p = x[0].length;
        double[][] X = x;
        double[] Y = y;
        if (n > this.p) {
            int j;
            int i;
            this.center = Math.colMean(x);
            X = new double[n][this.p];
            for (i = 0; i < n; ++i) {
                for (j = 0; j < this.p; ++j) {
                    X[i][j] = x[i][j] - this.center[j];
                }
            }
            this.scale = new double[this.p];
            for (int j2 = 0; j2 < this.p; ++j2) {
                for (int i2 = 0; i2 < n; ++i2) {
                    int n2 = j2;
                    this.scale[n2] = this.scale[n2] + Math.sqr(X[i2][j2]);
                }
                this.scale[j2] = Math.sqrt(this.scale[j2] / (double)n);
            }
            for (i = 0; i < n; ++i) {
                for (j = 0; j < this.p; ++j) {
                    double[] dArray = X[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] / this.scale[j];
                }
            }
            Y = new double[n];
            this.ym = Math.mean(y);
            for (i = 0; i < n; ++i) {
                Y[i] = y[i] - this.ym;
            }
        }
        double t = Math.min(Math.max(1.0, 1.0 / lambda), (double)(2 * this.p) / 0.001);
        double pobj = 0.0;
        double dobj = Double.NEGATIVE_INFINITY;
        double s = Double.POSITIVE_INFINITY;
        this.w = new double[this.p];
        double[] u = new double[this.p];
        double[] z = new double[n];
        double[][] f = new double[2][this.p];
        Arrays.fill(u, 1.0);
        for (int i = 0; i < this.p; ++i) {
            f[0][i] = this.w[i] - u[i];
            f[1][i] = -this.w[i] - u[i];
        }
        double[] neww = new double[this.p];
        double[] newu = new double[this.p];
        double[] newz = new double[n];
        double[][] newf = new double[2][this.p];
        double[] dx = new double[this.p];
        double[] du = new double[this.p];
        double[] dxu = new double[2 * this.p];
        double[] grad = new double[2 * this.p];
        double[] diagxtx = new double[this.p];
        Arrays.fill(diagxtx, 2.0);
        double[] nu = new double[n];
        double[] xnu = new double[this.p];
        double[] q1 = new double[this.p];
        double[] q2 = new double[this.p];
        double[] d1 = new double[this.p];
        double[] d2 = new double[this.p];
        double[][] gradphi = new double[2][this.p];
        double[] prb = new double[this.p];
        double[] prs = new double[this.p];
        PCGMatrix pcg = new PCGMatrix(X, d1, d2, prb, prs);
        for (ntiter = 0; ntiter <= maxIter; ++ntiter) {
            int lsiter;
            double error;
            double gap;
            int i;
            Math.ax(X, this.w, z);
            for (int i3 = 0; i3 < n; ++i3) {
                int n4 = i3;
                z[n4] = z[n4] - Y[i3];
                nu[i3] = 2.0 * z[i3];
            }
            Math.atx(X, nu, xnu);
            double maxXnu = Math.normInf(xnu);
            if (maxXnu > lambda) {
                double lnu = lambda / maxXnu;
                i = 0;
                while (i < n) {
                    int n5 = i++;
                    nu[n5] = nu[n5] * lnu;
                }
            }
            pobj = Math.dot(z, z) + lambda * Math.norm1(this.w);
            dobj = Math.max(-0.25 * Math.dot(nu, nu) - Math.dot(nu, Y), dobj);
            if (ntiter % 10 == 0) {
                System.out.format("LASSO: primal and dual objective function value after %3d iterations: %.5g\t%.5g\n", ntiter, pobj, dobj);
            }
            if ((gap = pobj - dobj) / dobj < tol) {
                System.out.format("LASSO: primal and dual objective function value after %3d iterations: %.5g\t%.5g\n", ntiter, pobj, dobj);
                break;
            }
            if (s >= 0.5) {
                t = Math.max(Math.min((double)(2 * this.p * 2) / gap, 2.0 * t), t);
            }
            for (i = 0; i < this.p; ++i) {
                double q1i = 1.0 / (u[i] + this.w[i]);
                double q2i = 1.0 / (u[i] - this.w[i]);
                q1[i] = q1i;
                q2[i] = q2i;
                d1[i] = (q1i * q1i + q2i * q2i) / t;
                d2[i] = (q1i * q1i - q2i * q2i) / t;
            }
            Math.atx(X, z, gradphi[0]);
            for (i = 0; i < this.p; ++i) {
                gradphi[0][i] = 2.0 * gradphi[0][i] - (q1[i] - q2[i]) / t;
                gradphi[1][i] = lambda - (q1[i] + q2[i]) / t;
                grad[i] = -gradphi[0][i];
                grad[i + this.p] = -gradphi[1][i];
            }
            for (i = 0; i < this.p; ++i) {
                prb[i] = diagxtx[i] + d1[i];
                prs[i] = prb[i] * d1[i] - d2[i] * d2[i];
            }
            double normg = Math.norm(grad);
            double pcgtol = Math.min(0.1, 0.001 * gap / Math.min(1.0, normg));
            if (ntiter != 0 && pitr == 0) {
                pcgtol *= 0.1;
            }
            if ((error = Math.solve((IMatrix)pcg, grad, dxu, pcgtol, 1, 5000)) > pcgtol) {
                pitr = 5000;
            }
            for (int i4 = 0; i4 < this.p; ++i4) {
                dx[i4] = dxu[i4];
                du[i4] = dxu[i4 + this.p];
            }
            double phi = Math.dot(z, z) + lambda * Math.sum(u) - this.sumlogneg(f) / t;
            s = 1.0;
            double gdx = Math.dot(grad, dxu);
            for (lsiter = 0; lsiter < 100; ++lsiter) {
                int i5;
                for (i5 = 0; i5 < this.p; ++i5) {
                    neww[i5] = this.w[i5] + s * dx[i5];
                    newu[i5] = u[i5] + s * du[i5];
                    newf[0][i5] = neww[i5] - newu[i5];
                    newf[1][i5] = -neww[i5] - newu[i5];
                }
                if (Math.max(newf) < 0.0) {
                    Math.ax(X, neww, newz);
                    for (i5 = 0; i5 < n; ++i5) {
                        int n6 = i5;
                        newz[n6] = newz[n6] - Y[i5];
                    }
                    double newphi = Math.dot(newz, newz) + lambda * Math.sum(newu) - this.sumlogneg(newf) / t;
                    if (newphi - phi <= 0.01 * s * gdx) break;
                }
                s = 0.5 * s;
            }
            if (lsiter == 100) {
                System.err.println("LASSO: Too many iterations of line search.");
                break;
            }
            System.arraycopy(neww, 0, this.w, 0, this.p);
            System.arraycopy(newu, 0, u, 0, this.p);
            System.arraycopy(newf[0], 0, f[0], 0, this.p);
            System.arraycopy(newf[1], 0, f[1], 0, this.p);
        }
        if (ntiter == maxIter) {
            System.err.println("LASSO: Too many iterations.");
        }
        if (n > this.p) {
            for (int j = 0; j < this.p; ++j) {
                int n7 = j;
                this.w[n7] = this.w[n7] / this.scale[j];
            }
            this.b = this.ym - Math.dot(this.w, this.center);
        }
    }

    private double sumlogneg(double[][] f) {
        int m = f.length;
        int n = f[0].length;
        double sum = 0.0;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                sum += Math.log(-f[i][j]);
            }
        }
        return sum;
    }

    public double[] coefficients() {
        return this.w;
    }

    public double intercept() {
        return this.b;
    }

    public double shrinkage() {
        return this.lambda;
    }

    @Override
    public double predict(double[] x) {
        if (x.length != this.p) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.p));
        }
        return Math.dot(x, this.w) + this.b;
    }

    class PCGMatrix
    implements IMatrix {
        double[][] A;
        double[] d1;
        double[] d2;
        double[] prb;
        double[] prs;
        double[] ax;
        double[] atax;

        PCGMatrix(double[][] A, double[] d1, double[] d2, double[] prb, double[] prs) {
            this.A = A;
            this.d1 = d1;
            this.d2 = d2;
            this.prb = prb;
            this.prs = prs;
            int n = A.length;
            this.ax = new double[n];
            this.atax = new double[LASSO.this.p];
        }

        @Override
        public int nrows() {
            return 2 * LASSO.this.p;
        }

        @Override
        public int ncols() {
            return 2 * LASSO.this.p;
        }

        @Override
        public void ax(double[] x, double[] y) {
            this.ax(this.A, x, this.ax);
            Math.atx(this.A, this.ax, this.atax);
            for (int i = 0; i < LASSO.this.p; ++i) {
                y[i] = 2.0 * this.atax[i] + this.d1[i] * x[i] + this.d2[i] * x[i + LASSO.this.p];
                y[i + ((LASSO)LASSO.this).p] = this.d2[i] * x[i] + this.d1[i] * x[i + LASSO.this.p];
            }
        }

        public void ax(double[][] A, double[] x, double[] y) {
            Arrays.fill(y, 0.0);
            for (int i = 0; i < y.length; ++i) {
                for (int k = 0; k < A[i].length; ++k) {
                    int n = i;
                    y[n] = y[n] + A[i][k] * x[k];
                }
            }
        }

        @Override
        public void atx(double[] x, double[] y) {
            this.ax(x, y);
        }

        @Override
        public void asolve(double[] b, double[] x) {
            for (int i = 0; i < LASSO.this.p; ++i) {
                x[i] = (this.d1[i] * b[i] - this.d2[i] * b[i + LASSO.this.p]) / this.prs[i];
                x[i + ((LASSO)LASSO.this).p] = (-this.d2[i] * b[i] + this.prb[i] * b[i + LASSO.this.p]) / this.prs[i];
            }
        }

        @Override
        public double get(int i, int j) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public PCGMatrix set(int i, int j, double x) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void axpy(double[] x, double[] y) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void axpy(double[] x, double[] y, double b) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void atxpy(double[] x, double[] y) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void atxpy(double[] x, double[] y, double b) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class Trainer
    extends RegressionTrainer<double[]> {
        private double lambda;
        private double tol = 0.001;
        private int maxIter = 500;

        public Trainer(double lambda) {
            if (lambda < 0.0) {
                throw new IllegalArgumentException("Invalid shrinkage/regularization parameter lambda = " + lambda);
            }
            this.lambda = lambda;
        }

        public Trainer setTolerance(double tol) {
            if (tol <= 0.0) {
                throw new IllegalArgumentException("Invalid tolerance: " + tol);
            }
            this.tol = tol;
            return this;
        }

        public Trainer setMaxNumIteration(int maxIter) {
            if (maxIter <= 0) {
                throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
            }
            this.maxIter = maxIter;
            return this;
        }

        public LASSO train(double[][] x, double[] y) {
            return new LASSO(x, y, this.lambda, this.tol, this.maxIter);
        }
    }
}

