/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import smile.math.Math;
import smile.math.matrix.CholeskyDecomposition;
import smile.math.matrix.QRDecomposition;
import smile.math.special.Beta;
import smile.regression.Regression;
import smile.regression.RegressionTrainer;

public class OLS
implements Regression<double[]> {
    private int p;
    private double b;
    private double[] w;
    private double[][] coefficients;
    private double[] residuals;
    private double RSS;
    private double error;
    private int df;
    private double RSquared;
    private double adjustedRSquared;
    private double F;
    private double pvalue;

    public OLS(double[][] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        int n = x.length;
        this.p = x[0].length;
        double[] w1 = new double[this.p + 1];
        double[][] X = new double[n][this.p + 1];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(x[i], 0, X[i], 0, this.p);
            X[i][this.p] = 1.0;
        }
        QRDecomposition qr = new QRDecomposition(X, true);
        qr.solve(y, w1);
        this.b = w1[this.p];
        this.w = new double[this.p];
        System.arraycopy(w1, 0, this.w, 0, this.p);
        double[] yhat = new double[n];
        Math.ax(x, this.w, yhat);
        double TSS = 0.0;
        this.RSS = 0.0;
        double ybar = Math.mean(y);
        this.residuals = new double[n];
        for (int i = 0; i < n; ++i) {
            double r;
            this.residuals[i] = r = y[i] - yhat[i] - this.b;
            this.RSS += Math.sqr(r);
            TSS += Math.sqr(y[i] - ybar);
        }
        this.error = Math.sqrt(this.RSS / (double)(n - this.p - 1));
        this.df = n - this.p - 1;
        this.RSquared = 1.0 - this.RSS / TSS;
        this.adjustedRSquared = 1.0 - (1.0 - this.RSquared) * (double)(n - 1) / (double)(n - this.p - 1);
        this.F = (TSS - this.RSS) * (double)(n - this.p - 1) / (this.RSS * (double)this.p);
        int df1 = this.p;
        int df2 = n - this.p - 1;
        this.pvalue = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df2, 0.5 * (double)df1, (double)df2 / ((double)df2 + (double)df1 * this.F));
        CholeskyDecomposition cholesky = qr.toCholesky();
        double[][] inv = cholesky.inverse();
        this.coefficients = new double[this.p + 1][4];
        for (int i = 0; i <= this.p; ++i) {
            double t;
            double se;
            this.coefficients[i][0] = w1[i];
            this.coefficients[i][1] = se = this.error * Math.sqrt(inv[i][i]);
            this.coefficients[i][2] = t = w1[i] / se;
            this.coefficients[i][3] = Beta.regularizedIncompleteBetaFunction(0.5 * (double)this.df, 0.5, (double)this.df / ((double)this.df + t * t));
        }
    }

    public double[][] ttest() {
        return this.coefficients;
    }

    public double[] coefficients() {
        return this.w;
    }

    public double intercept() {
        return this.b;
    }

    public double[] residuals() {
        return this.residuals;
    }

    public double RSS() {
        return this.RSS;
    }

    public double error() {
        return this.error;
    }

    public int df() {
        return this.df;
    }

    public double RSquared() {
        return this.RSquared;
    }

    public double adjustedRSquared() {
        return this.adjustedRSquared;
    }

    public double ftest() {
        return this.F;
    }

    public double pvalue() {
        return this.pvalue;
    }

    @Override
    public double predict(double[] x) {
        if (x.length != this.p) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.p));
        }
        return this.b + Math.dot(x, this.w);
    }

    private String significance(double pvalue) {
        if (pvalue < 0.001) {
            return "***";
        }
        if (pvalue < 0.01) {
            return "**";
        }
        if (pvalue < 0.05) {
            return "*";
        }
        if (pvalue < 0.1) {
            return ".";
        }
        return "";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Linear Model:\n");
        double[] r = (double[])this.residuals.clone();
        builder.append("\nResiduals:\n");
        builder.append("\t     Min\t      1Q\t  Median\t      3Q\t     Max\n");
        builder.append(String.format("\t%8.4f\t%8.4f\t%8.4f\t%8.4f\t%8.4f\n", Math.min(r), Math.q1(r), Math.median(r), Math.q3(r), Math.max(r)));
        builder.append("\nCoefficients:\n");
        builder.append("\t    Estimate\t Std. Error\t t value\t Pr(>|t|)\n");
        builder.append(String.format("Intercept%11.4f%19.4f%16.4f%17.4f %s\n", this.coefficients[this.p][0], this.coefficients[this.p][1], this.coefficients[this.p][2], this.coefficients[this.p][3], this.significance(this.coefficients[this.p][3])));
        for (int i = 0; i < this.p; ++i) {
            builder.append(String.format("Var %d\t%7.4f%19.4f%16.4f%17.4f %s\n", i + 1, this.coefficients[i][0], this.coefficients[i][1], this.coefficients[i][2], this.coefficients[i][3], this.significance(this.coefficients[i][3])));
        }
        builder.append("---\n");
        builder.append("Significance codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1\n");
        builder.append(String.format("\nResidual standard error: %.4f on %d degrees of freedom\n", this.error, this.df));
        builder.append(String.format("Multiple R-squared: %.4f,    Adjusted R-squared: %.4f\n", this.RSquared, this.adjustedRSquared));
        builder.append(String.format("F-statistic: %.4f on %d and %d DF,  p-value: %.4g\n", this.F, this.p, this.df, this.pvalue));
        return builder.toString();
    }

    public static class Trainer
    extends RegressionTrainer<double[]> {
        public OLS train(double[][] x, double[] y) {
            return new OLS(x, y);
        }
    }
}

