/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import smile.data.Attribute;
import smile.data.NumericAttribute;
import smile.math.Math;
import smile.math.Random;
import smile.regression.Regression;
import smile.regression.RegressionTrainer;
import smile.regression.RegressionTree;
import smile.util.MulticoreExecutor;
import smile.util.SmileUtils;
import smile.validation.RMSE;
import smile.validation.RegressionMeasure;

public class RandomForest
implements Regression<double[]> {
    private List<RegressionTree> trees;
    private double error;
    private double[] importance;

    public RandomForest(double[][] x, double[] y, int T) {
        this(null, x, y, T);
    }

    public RandomForest(double[][] x, double[] y, int T, int M, int S) {
        this(null, x, y, T, M, S);
    }

    public RandomForest(Attribute[] attributes, double[][] x, double[] y, int T) {
        this(attributes, x, y, T, -1, 5);
    }

    public RandomForest(Attribute[] attributes, double[][] x, double[] y, int T, int M, int S) {
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (attributes == null) {
            int p = x[0].length;
            attributes = new Attribute[p];
            for (int i2 = 0; i2 < p; ++i2) {
                attributes[i2] = new NumericAttribute("V" + (i2 + 1));
            }
        }
        if (M <= 0) {
            M = Math.max(1, x[0].length / 3);
        }
        if (S <= 0) {
            throw new IllegalArgumentException("Invalid minimum leaf node size: " + S);
        }
        int n = x.length;
        double[] prediction = new double[n];
        int[] oob = new int[n];
        int[][] order = SmileUtils.sort(attributes, x);
        ArrayList<TrainingTask> tasks = new ArrayList<TrainingTask>();
        for (int i3 = 0; i3 < T; ++i3) {
            tasks.add(new TrainingTask(attributes, x, y, order, M, S, prediction, oob));
        }
        try {
            this.trees = MulticoreExecutor.run(tasks);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.trees = new ArrayList<RegressionTree>(T);
            for (i = 0; i < T; ++i) {
                this.trees.add(((TrainingTask)tasks.get(i)).call());
            }
        }
        int m = 0;
        for (i = 0; i < n; ++i) {
            if (oob[i] <= 0) continue;
            ++m;
            double pred = prediction[i] / (double)oob[i];
            this.error += Math.sqr(pred - y[i]);
        }
        if (m > 0) {
            this.error = Math.sqrt(this.error / (double)m);
        }
        this.importance = new double[attributes.length];
        for (RegressionTree tree : this.trees) {
            double[] imp = tree.importance();
            for (int i4 = 0; i4 < imp.length; ++i4) {
                int n2 = i4;
                this.importance[n2] = this.importance[n2] + imp[i4];
            }
        }
    }

    public double error() {
        return this.error;
    }

    public double[] importance() {
        return this.importance;
    }

    public int size() {
        return this.trees.size();
    }

    public void trim(int T) {
        if (T > this.trees.size()) {
            throw new IllegalArgumentException("The new model size is larger than the current size.");
        }
        if (T <= 0) {
            throw new IllegalArgumentException("Invalid new model size: " + T);
        }
        ArrayList<RegressionTree> model = new ArrayList<RegressionTree>(T);
        for (int i = 0; i < T; ++i) {
            model.add(this.trees.get(i));
        }
        this.trees = model;
    }

    @Override
    public double predict(double[] x) {
        double y = 0.0;
        for (RegressionTree tree : this.trees) {
            y += tree.predict(x);
        }
        return y / (double)this.trees.size();
    }

    public double[] test(double[][] x, double[] y) {
        int T = this.trees.size();
        double[] rmse = new double[T];
        int n = x.length;
        double[] sum = new double[n];
        double[] prediction = new double[n];
        RMSE measure = new RMSE();
        int i = 0;
        int nt = 1;
        while (i < T) {
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                sum[n2] = sum[n2] + this.trees.get(i).predict(x[j]);
                prediction[j] = sum[j] / (double)nt;
            }
            rmse[i] = measure.measure(y, prediction);
            ++i;
            ++nt;
        }
        return rmse;
    }

    public double[][] test(double[][] x, double[] y, RegressionMeasure[] measures) {
        int T = this.trees.size();
        int m = measures.length;
        double[][] results = new double[T][m];
        int n = x.length;
        double[] sum = new double[n];
        double[] prediction = new double[n];
        int i = 0;
        int nt = 1;
        while (i < T) {
            int j;
            for (j = 0; j < n; ++j) {
                int n2 = j;
                sum[n2] = sum[n2] + this.trees.get(i).predict(x[j]);
                prediction[j] = sum[j] / (double)nt;
            }
            for (j = 0; j < m; ++j) {
                results[i][j] = measures[j].measure(y, prediction);
            }
            ++i;
            ++nt;
        }
        return results;
    }

    static class TrainingTask
    implements Callable<RegressionTree> {
        Attribute[] attributes;
        double[][] x;
        double[] y;
        int[][] order;
        int M;
        int S;
        double[] prediction;
        int[] oob;

        TrainingTask(Attribute[] attributes, double[][] x, double[] y, int[][] order, int M, int S, double[] prediction, int[] oob) {
            this.attributes = attributes;
            this.x = x;
            this.y = y;
            this.order = order;
            this.M = M;
            this.S = S;
            this.prediction = prediction;
            this.oob = oob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegressionTree call() {
            int n = this.x.length;
            Random random = new Random(Thread.currentThread().getId() * System.currentTimeMillis());
            int[] samples = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2 = random.nextInt(n);
                samples[n2] = samples[n2] + 1;
            }
            RegressionTree tree = new RegressionTree(this.attributes, this.x, this.y, this.M, this.S, this.order, samples);
            for (int i = 0; i < n; ++i) {
                if (samples[i] != 0) continue;
                double pred = tree.predict(this.x[i]);
                double[] dArray = this.x[i];
                synchronized (dArray) {
                    int n3 = i;
                    this.prediction[n3] = this.prediction[n3] + pred;
                    int n4 = i;
                    this.oob[n4] = this.oob[n4] + 1;
                    continue;
                }
            }
            return tree;
        }
    }

    public static class Trainer
    extends RegressionTrainer<double[]> {
        private int T = 500;
        private int M = -1;
        private int S = 5;

        public Trainer(int T) {
            if (T < 1) {
                throw new IllegalArgumentException("Invlaid number of trees: " + T);
            }
            this.T = T;
        }

        public Trainer(Attribute[] attributes, int T) {
            super(attributes);
            if (T < 1) {
                throw new IllegalArgumentException("Invlaid number of trees: " + T);
            }
            this.T = T;
        }

        public Trainer setNumTrees(int T) {
            if (T < 1) {
                throw new IllegalArgumentException("Invlaid number of trees: " + T);
            }
            this.T = T;
            return this;
        }

        public Trainer setNumRandomFeatures(int M) {
            if (M < 1) {
                throw new IllegalArgumentException("Invalid number of random selected features for splitting: " + M);
            }
            this.M = M;
            return this;
        }

        public Trainer setMinimumNodeSize(int S) {
            if (S <= 0) {
                throw new IllegalArgumentException("Invalid minimum size of leaf nodes: " + S);
            }
            this.S = S;
            return this;
        }

        public RandomForest train(double[][] x, double[] y) {
            return new RandomForest(this.attributes, x, y, this.T, this.M, this.S);
        }
    }
}

