/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import smile.math.Math;
import smile.math.matrix.CholeskyDecomposition;
import smile.regression.Regression;
import smile.regression.RegressionTrainer;

public class RidgeRegression
implements Regression<double[]> {
    private int p;
    private double lambda;
    private double b;
    private double[] w;
    private double ym;
    private double[] center;
    private double[] scale;

    public RidgeRegression(double[][] x, double[] y, double lambda) {
        int i;
        int j;
        int i2;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid shrinkage/regularization parameter lambda = " + lambda);
        }
        int n = x.length;
        this.p = x[0].length;
        this.ym = Math.mean(y);
        this.center = Math.colMean(x);
        double[][] X = new double[n][this.p];
        for (i2 = 0; i2 < n; ++i2) {
            for (j = 0; j < this.p; ++j) {
                X[i2][j] = x[i2][j] - this.center[j];
            }
        }
        this.scale = new double[this.p];
        for (int j2 = 0; j2 < this.p; ++j2) {
            for (i = 0; i < n; ++i) {
                int n2 = j2;
                this.scale[n2] = this.scale[n2] + Math.sqr(X[i][j2]);
            }
            this.scale[j2] = Math.sqrt(this.scale[j2] / (double)n);
        }
        for (i2 = 0; i2 < n; ++i2) {
            for (j = 0; j < this.p; ++j) {
                double[] dArray = X[i2];
                int n3 = j;
                dArray[n3] = dArray[n3] / this.scale[j];
            }
        }
        this.w = new double[this.p];
        Math.atx(X, y, this.w);
        double[][] XtX = Math.atamm(X);
        i = 0;
        while (i < this.p) {
            double[] dArray = XtX[i];
            int n4 = i++;
            dArray[n4] = dArray[n4] + lambda;
        }
        CholeskyDecomposition cholesky = new CholeskyDecomposition(XtX);
        cholesky.solve(this.w);
        for (int j3 = 0; j3 < this.p; ++j3) {
            int n5 = j3;
            this.w[n5] = this.w[n5] / this.scale[j3];
        }
        this.b = this.ym - Math.dot(this.w, this.center);
    }

    public double[] coefficients() {
        return this.w;
    }

    public double intercept() {
        return this.b;
    }

    public double shrinkage() {
        return this.lambda;
    }

    @Override
    public double predict(double[] x) {
        if (x.length != this.p) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.p));
        }
        return Math.dot(x, this.w) + this.b;
    }

    public static class Trainer
    extends RegressionTrainer<double[]> {
        private double lambda;

        public Trainer(double lambda) {
            if (lambda < 0.0) {
                throw new IllegalArgumentException("Invalid shrinkage/regularization parameter lambda = " + lambda);
            }
            this.lambda = lambda;
        }

        public RidgeRegression train(double[][] x, double[] y) {
            return new RidgeRegression(x, y, this.lambda);
        }
    }
}

