/*
 * Decompiled with CFR 0.152.
 */
package smile.sequence;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import smile.data.Attribute;
import smile.data.NominalAttribute;
import smile.data.NumericAttribute;
import smile.math.Math;
import smile.math.Random;
import smile.regression.RegressionTree;
import smile.sequence.SequenceLabeler;
import smile.sort.QuickSort;
import smile.util.MulticoreExecutor;

public class CRF
implements SequenceLabeler<double[]> {
    private int numClasses;
    private int numFeatures = -1;
    private TreePotentialFunction[] potentials;
    private boolean viterbi = false;

    public double[] featureset(double[] features, int label) {
        double[] fs = new double[features.length + 1];
        System.arraycopy(features, 0, fs, 0, features.length);
        fs[features.length] = label;
        return fs;
    }

    public int[] featureset(int[] features, int label) {
        int[] fs = new int[features.length + 1];
        System.arraycopy(features, 0, fs, 0, features.length);
        fs[features.length] = this.numFeatures + label;
        return fs;
    }

    private CRF(int numClasses, double eta) {
        this.numClasses = numClasses;
        this.potentials = new TreePotentialFunction[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            this.potentials[i] = new TreePotentialFunction(eta);
        }
    }

    private CRF(int numFeatures, int numClasses, double eta) {
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        this.potentials = new TreePotentialFunction[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            this.potentials[i] = new TreePotentialFunction(eta);
        }
    }

    public boolean isViterbi() {
        return this.viterbi;
    }

    public CRF setViterbi(boolean viterbi) {
        this.viterbi = viterbi;
        return this;
    }

    public int[] predict(double[][] x) {
        if (this.viterbi) {
            return this.predictViterbi(x);
        }
        return this.predictForwardBackward(x);
    }

    public int[] predict(int[][] x) {
        if (this.viterbi) {
            return this.predictViterbi(x);
        }
        return this.predictForwardBackward(x);
    }

    private int[] predictForwardBackward(double[][] x) {
        int n = x.length;
        TrellisNode[][] trellis = this.getTrellis(x);
        double[] scaling = new double[n];
        this.forward(trellis, scaling);
        this.backward(trellis);
        int[] label = new int[n];
        double[] p = new double[this.numClasses];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.numClasses; ++j) {
                p[j] = trellis[i][j].alpha * trellis[i][j].beta;
            }
            double max = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < this.numClasses; ++j) {
                if (!(max < p[j])) continue;
                max = p[j];
                label[i] = j;
            }
        }
        return label;
    }

    private int[] predictViterbi(double[][] x) {
        int n = x.length;
        double[][] trellis = new double[n][this.numClasses];
        int[][] psy = new int[n][this.numClasses];
        int p = x[0].length;
        double[] features = this.featureset(x[0], this.numClasses);
        for (int j = 0; j < this.numClasses; ++j) {
            trellis[0][j] = this.potentials[j].f(features);
            psy[0][j] = 0;
        }
        for (int t = 1; t < n; ++t) {
            System.arraycopy(x[t], 0, features, 0, p);
            for (int i = 0; i < this.numClasses; ++i) {
                double max = Double.NEGATIVE_INFINITY;
                int maxPsy = 0;
                for (int j = 0; j < this.numClasses; ++j) {
                    features[p] = j;
                    double delta = this.potentials[i].f(features) + trellis[t - 1][j];
                    if (!(max < delta)) continue;
                    max = delta;
                    maxPsy = j;
                }
                trellis[t][i] = max;
                psy[t][i] = maxPsy;
            }
        }
        int[] label = new int[n];
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numClasses; ++i) {
            if (!(max < trellis[n - 1][i])) continue;
            max = trellis[n - 1][i];
            label[n - 1] = i;
        }
        int t = n - 1;
        while (t-- > 0) {
            label[t] = psy[t + 1][label[t + 1]];
        }
        return label;
    }

    private int[] predictForwardBackward(int[][] x) {
        int n = x.length;
        TrellisNode[][] trellis = this.getTrellis(x);
        double[] scaling = new double[n];
        this.forward(trellis, scaling);
        this.backward(trellis);
        int[] label = new int[n];
        double[] p = new double[this.numClasses];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.numClasses; ++j) {
                p[j] = trellis[i][j].alpha * trellis[i][j].beta;
            }
            double max = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < this.numClasses; ++j) {
                if (!(max < p[j])) continue;
                max = p[j];
                label[i] = j;
            }
        }
        return label;
    }

    private int[] predictViterbi(int[][] x) {
        int n = x.length;
        double[][] trellis = new double[n][this.numClasses];
        int[][] psy = new int[n][this.numClasses];
        int p = x[0].length;
        int[] features = this.featureset(x[0], this.numClasses);
        for (int j = 0; j < this.numClasses; ++j) {
            trellis[0][j] = this.potentials[j].f(features);
            psy[0][j] = 0;
        }
        for (int t = 1; t < n; ++t) {
            System.arraycopy(x[t], 0, features, 0, p);
            for (int i = 0; i < this.numClasses; ++i) {
                double max = Double.NEGATIVE_INFINITY;
                int maxPsy = 0;
                for (int j = 0; j < this.numClasses; ++j) {
                    features[p] = this.numFeatures + j;
                    double delta = this.potentials[i].f(features) + trellis[t - 1][j];
                    if (!(max < delta)) continue;
                    max = delta;
                    maxPsy = j;
                }
                trellis[t][i] = max;
                psy[t][i] = maxPsy;
            }
        }
        int[] label = new int[n];
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numClasses; ++i) {
            if (!(max < trellis[n - 1][i])) continue;
            max = trellis[n - 1][i];
            label[n - 1] = i;
        }
        int t = n - 1;
        while (t-- > 0) {
            label[t] = psy[t + 1][label[t + 1]];
        }
        return label;
    }

    private void forward(TrellisNode[][] trellis, double[] scaling) {
        int i;
        int n = trellis.length;
        for (i = 0; i < this.numClasses; ++i) {
            int k;
            if (this.numFeatures <= 0) {
                for (k = trellis[0][i].age; k < this.potentials[i].trees.size(); ++k) {
                    trellis[0][i].scores[0] = trellis[0][i].scores[0] + this.potentials[i].eta * ((RegressionTree)this.potentials[i].trees.get(k)).predict(trellis[0][i].samples[0]);
                }
            } else {
                for (k = trellis[0][i].age; k < this.potentials[i].trees.size(); ++k) {
                    trellis[0][i].scores[0] = trellis[0][i].scores[0] + this.potentials[i].eta * ((RegressionTree)this.potentials[i].trees.get(k)).predict(trellis[0][i].sparseSamples[0]);
                }
            }
            trellis[0][i].expScores[0] = Math.exp(trellis[0][i].scores[0]);
            trellis[0][i].alpha = trellis[0][i].expScores[0];
            trellis[0][i].age = this.potentials[i].trees.size();
        }
        scaling[0] = 0.0;
        for (i = 0; i < this.numClasses; ++i) {
            scaling[0] = scaling[0] + trellis[0][i].alpha;
        }
        for (i = 0; i < this.numClasses; ++i) {
            trellis[0][i].alpha /= scaling[0];
        }
        for (int t = 1; t < n; ++t) {
            int i2;
            for (i2 = 0; i2 < this.numClasses; ++i2) {
                trellis[t][i2].alpha = 0.0;
                for (int j = 0; j < this.numClasses; ++j) {
                    int k;
                    if (this.numFeatures <= 0) {
                        for (k = trellis[t][i2].age; k < this.potentials[i2].trees.size(); ++k) {
                            int n2 = j;
                            trellis[t][i2].scores[n2] = trellis[t][i2].scores[n2] + this.potentials[i2].eta * ((RegressionTree)this.potentials[i2].trees.get(k)).predict(trellis[t][i2].samples[j]);
                        }
                    } else {
                        for (k = trellis[t][i2].age; k < this.potentials[i2].trees.size(); ++k) {
                            int n3 = j;
                            trellis[t][i2].scores[n3] = trellis[t][i2].scores[n3] + this.potentials[i2].eta * ((RegressionTree)this.potentials[i2].trees.get(k)).predict(trellis[t][i2].sparseSamples[j]);
                        }
                    }
                    trellis[t][i2].expScores[j] = Math.exp(trellis[t][i2].scores[j]);
                    trellis[t][i2].alpha += trellis[t][i2].expScores[j] * trellis[t - 1][j].alpha;
                }
                trellis[t][i2].age = this.potentials[i2].trees.size();
            }
            scaling[t] = 0.0;
            for (i2 = 0; i2 < this.numClasses; ++i2) {
                int n4 = t;
                scaling[n4] = scaling[n4] + trellis[t][i2].alpha;
            }
            for (i2 = 0; i2 < this.numClasses; ++i2) {
                trellis[t][i2].alpha /= scaling[t];
            }
        }
    }

    private void backward(TrellisNode[][] trellis) {
        int n = trellis.length - 1;
        for (int i = 0; i < this.numClasses; ++i) {
            trellis[n][i].beta = 1.0;
        }
        int t = n;
        while (t-- > 0) {
            int i;
            for (int i2 = 0; i2 < this.numClasses; ++i2) {
                trellis[t][i2].beta = 0.0;
                for (int j = 0; j < this.numClasses; ++j) {
                    trellis[t][i2].beta += trellis[t + 1][j].expScores[i2] * trellis[t + 1][j].beta;
                }
            }
            double sum = 0.0;
            for (i = 0; i < this.numClasses; ++i) {
                sum += trellis[t][i].beta;
            }
            for (i = 0; i < this.numClasses; ++i) {
                trellis[t][i].beta /= sum;
            }
        }
    }

    private TrellisNode[][] getTrellis(double[][] sequence) {
        TrellisNode[][] trellis = new TrellisNode[sequence.length][this.numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            trellis[0][i] = new TrellisNode(false);
            trellis[0][i].samples[0] = this.featureset(sequence[0], this.numClasses);
        }
        for (int t = 1; t < sequence.length; ++t) {
            trellis[t][0] = new TrellisNode(false);
            for (int j = 0; j < this.numClasses; ++j) {
                trellis[t][0].samples[j] = this.featureset(sequence[t], j);
            }
            for (int i = 1; i < this.numClasses; ++i) {
                trellis[t][i] = new TrellisNode(false);
                System.arraycopy(trellis[t][0].samples, 0, trellis[t][i].samples, 0, this.numClasses);
            }
        }
        return trellis;
    }

    private TrellisNode[][] getTrellis(int[][] sequence) {
        TrellisNode[][] trellis = new TrellisNode[sequence.length][this.numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            trellis[0][i] = new TrellisNode(true);
            trellis[0][i].sparseSamples[0] = this.featureset(sequence[0], this.numClasses);
        }
        for (int t = 1; t < sequence.length; ++t) {
            trellis[t][0] = new TrellisNode(true);
            for (int j = 0; j < this.numClasses; ++j) {
                trellis[t][0].sparseSamples[j] = this.featureset(sequence[t], j);
            }
            for (int i = 1; i < this.numClasses; ++i) {
                trellis[t][i] = new TrellisNode(true);
                System.arraycopy(trellis[t][0].sparseSamples, 0, trellis[t][i].sparseSamples, 0, this.numClasses);
            }
        }
        return trellis;
    }

    private void setTargets(TrellisNode[][] trellis, double[] scaling, int[] label) {
        int i;
        double normalizer = 0.0;
        for (i = 0; i < this.numClasses; ++i) {
            normalizer += trellis[0][i].expScores[0] * trellis[0][i].beta;
        }
        for (i = 0; i < this.numClasses; ++i) {
            trellis[0][i].target[0] = label[0] == i ? 1.0 - trellis[0][i].expScores[0] * trellis[0][i].beta / normalizer : -trellis[0][i].expScores[0] * trellis[0][i].beta / normalizer;
        }
        for (int t = 1; t < label.length; ++t) {
            int i2;
            normalizer = 0.0;
            for (i2 = 0; i2 < this.numClasses; ++i2) {
                normalizer += trellis[t][i2].alpha * trellis[t][i2].beta;
            }
            normalizer *= scaling[t];
            for (i2 = 0; i2 < this.numClasses; ++i2) {
                for (int j = 0; j < this.numClasses; ++j) {
                    trellis[t][i2].target[j] = label[t] == i2 && label[t - 1] == j ? 1.0 - trellis[t][i2].expScores[j] * trellis[t - 1][j].alpha * trellis[t][i2].beta / normalizer : -trellis[t][i2].expScores[j] * trellis[t - 1][j].alpha * trellis[t][i2].beta / normalizer;
                }
            }
        }
    }

    public static class Trainer {
        private int numClasses;
        private int numFeatures = -1;
        private Attribute[] attributes;
        private int maxLeaves = 100;
        private double eta = 1.0;
        private int iters = 100;

        public Trainer(Attribute[] attributes, int numClasses) {
            if (numClasses < 2) {
                throw new IllegalArgumentException("Invalid number of classes: " + numClasses);
            }
            this.numClasses = numClasses;
            this.attributes = new Attribute[attributes.length + 1];
            System.arraycopy(attributes, 0, this.attributes, 0, attributes.length);
            String[] values = new String[numClasses + 1];
            for (int i = 0; i <= numClasses; ++i) {
                values[i] = Integer.toString(i);
            }
            this.attributes[attributes.length] = new NominalAttribute("Previous Position Label", values);
        }

        public Trainer(int numFeatures, int numClasses) {
            if (numFeatures < 2) {
                throw new IllegalArgumentException("Invalid number of features: " + numClasses);
            }
            if (numClasses < 2) {
                throw new IllegalArgumentException("Invalid number of classes: " + numClasses);
            }
            this.numFeatures = numFeatures;
            this.numClasses = numClasses;
        }

        public Trainer setMaximumLeafNodes(int maxLeaves) {
            if (maxLeaves < 2) {
                throw new IllegalArgumentException("Invalid number of leaf nodes: " + maxLeaves);
            }
            this.maxLeaves = maxLeaves;
            return this;
        }

        public Trainer setLearningRate(double eta) {
            if (eta <= 0.0) {
                throw new IllegalArgumentException("Invalid learning rate: " + eta);
            }
            this.eta = eta;
            return this;
        }

        public Trainer setNumIterations(int iters) {
            if (iters < 1) {
                throw new IllegalArgumentException("Invalid number of iterations: " + iters);
            }
            this.iters = iters;
            return this;
        }

        public CRF train(double[][][] sequences, int[][] labels) {
            CRF crf = new CRF(this.numClasses, this.eta);
            double[][] scaling = new double[sequences.length][];
            TrellisNode[][][] trellis = new TrellisNode[sequences.length][][];
            for (int i = 0; i < sequences.length; ++i) {
                scaling[i] = new double[sequences[i].length];
                trellis[i] = crf.getTrellis(sequences[i]);
            }
            ArrayList<GradientTask> gradientTasks = new ArrayList<GradientTask>();
            for (int i = 0; i < sequences.length; ++i) {
                gradientTasks.add(new GradientTask(crf, trellis[i], scaling[i], labels[i]));
            }
            ArrayList<BoostingTask> boostingTasks = new ArrayList<BoostingTask>();
            for (int i = 0; i < this.numClasses; ++i) {
                boostingTasks.add(new BoostingTask(crf.potentials[i], trellis, i));
            }
            for (int iter = 0; iter < this.iters; ++iter) {
                try {
                    MulticoreExecutor.run(gradientTasks);
                    MulticoreExecutor.run(boostingTasks);
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            return crf;
        }

        public CRF train(int[][][] sequences, int[][] labels) {
            CRF crf = new CRF(this.numFeatures, this.numClasses, this.eta);
            double[][] scaling = new double[sequences.length][];
            TrellisNode[][][] trellis = new TrellisNode[sequences.length][][];
            for (int i = 0; i < sequences.length; ++i) {
                scaling[i] = new double[sequences[i].length];
                trellis[i] = crf.getTrellis(sequences[i]);
            }
            ArrayList<GradientTask> gradientTasks = new ArrayList<GradientTask>();
            for (int i = 0; i < sequences.length; ++i) {
                gradientTasks.add(new GradientTask(crf, trellis[i], scaling[i], labels[i]));
            }
            ArrayList<BoostingTask> boostingTasks = new ArrayList<BoostingTask>();
            for (int i = 0; i < this.numClasses; ++i) {
                boostingTasks.add(new BoostingTask(crf.potentials[i], trellis, i));
            }
            for (int iter = 0; iter < this.iters; ++iter) {
                try {
                    MulticoreExecutor.run(gradientTasks);
                    MulticoreExecutor.run(boostingTasks);
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            return crf;
        }

        class BoostingTask
        implements Callable<Object> {
            int i;
            TreePotentialFunction potential;
            TrellisNode[][][] trellis;
            RegressionTree.Trainer trainer;
            int[][] sparseX;
            double[][] x;
            double[] y;
            int[][] order;
            int[] samples;
            Random random;

            BoostingTask(TreePotentialFunction potential, TrellisNode[][][] trellis, int i) {
                int l;
                this.potential = potential;
                this.trellis = trellis;
                this.i = i;
                this.trainer = Trainer.this.numFeatures <= 0 ? new RegressionTree.Trainer(Trainer.this.attributes, Trainer.this.maxLeaves) : new RegressionTree.Trainer(Trainer.this.numFeatures + Trainer.this.numClasses + 1, Trainer.this.maxLeaves);
                int n = 0;
                for (l = 0; l < trellis.length; ++l) {
                    n += 1 + (trellis[l].length - 1) * Trainer.this.numClasses;
                }
                this.random = new Random(System.currentTimeMillis());
                this.y = new double[n];
                if (Trainer.this.numFeatures <= 0) {
                    this.x = new double[n][];
                    int m = 0;
                    for (l = 0; l < trellis.length; ++l) {
                        this.x[m++] = trellis[l][0][i].samples[0];
                        for (int t = 1; t < trellis[l].length; ++t) {
                            for (int j = 0; j < Trainer.this.numClasses; ++j) {
                                this.x[m++] = trellis[l][t][i].samples[j];
                            }
                        }
                    }
                    int p = this.x[0].length;
                    double[] a = new double[n];
                    this.order = new int[p][];
                    for (int j = 0; j < p; ++j) {
                        if (!(Trainer.this.attributes[j] instanceof NumericAttribute)) continue;
                        for (int l2 = 0; l2 < n; ++l2) {
                            a[l2] = this.x[l2][j];
                        }
                        this.order[j] = QuickSort.sort(a);
                    }
                } else {
                    this.sparseX = new int[n][];
                    int m = 0;
                    for (l = 0; l < trellis.length; ++l) {
                        this.sparseX[m++] = trellis[l][0][i].sparseSamples[0];
                        for (int t = 1; t < trellis[l].length; ++t) {
                            for (int j = 0; j < Trainer.this.numClasses; ++j) {
                                this.sparseX[m++] = trellis[l][t][i].sparseSamples[j];
                            }
                        }
                    }
                }
            }

            @Override
            public Object call() {
                int m = 0;
                for (int l = 0; l < this.trellis.length; ++l) {
                    this.y[m++] = this.trellis[l][0][this.i].target[0];
                    for (int t = 1; t < this.trellis[l].length; ++t) {
                        for (int j = 0; j < Trainer.this.numClasses; ++j) {
                            this.y[m++] = this.trellis[l][t][this.i].target[j];
                        }
                    }
                }
                if (this.x != null) {
                    RegressionTree tree = new RegressionTree(Trainer.this.attributes, this.x, this.y, Trainer.this.maxLeaves, this.order, this.samples, null);
                    this.potential.add(tree);
                } else {
                    RegressionTree tree = new RegressionTree(Trainer.this.numFeatures + Trainer.this.numClasses + 1, this.sparseX, this.y, Trainer.this.maxLeaves, this.samples, null);
                    this.potential.add(tree);
                }
                return null;
            }
        }

        class GradientTask
        implements Callable<Object> {
            CRF crf;
            TrellisNode[][] trellis;
            double[] scaling;
            int[] label;

            GradientTask(CRF crf, TrellisNode[][] trellis, double[] scaling, int[] label) {
                this.crf = crf;
                this.trellis = trellis;
                this.scaling = scaling;
                this.label = label;
            }

            @Override
            public Object call() {
                this.crf.forward(this.trellis, this.scaling);
                this.crf.backward(this.trellis);
                this.crf.setTargets(this.trellis, this.scaling, this.label);
                return null;
            }
        }
    }

    class TrellisNode {
        double alpha = 1.0;
        double beta = 1.0;
        double[][] samples;
        int[][] sparseSamples;
        double[] target = new double[CRF.access$000(CRF.this)];
        double[] scores = new double[CRF.access$000(CRF.this)];
        double[] expScores = new double[CRF.access$000(CRF.this)];
        int age = 0;

        TrellisNode(boolean sparse) {
            if (sparse) {
                this.sparseSamples = new int[CRF.this.numClasses][];
            } else {
                this.samples = new double[CRF.this.numClasses][];
            }
        }
    }

    class TreePotentialFunction {
        private double eta;
        private List<RegressionTree> trees = new ArrayList<RegressionTree>();

        public TreePotentialFunction(double eta) {
            this.eta = eta;
        }

        public double f(double[] features) {
            double score = 0.0;
            for (RegressionTree tree : this.trees) {
                score += this.eta * tree.predict(features);
            }
            return score;
        }

        public double f(int[] features) {
            double score = 0.0;
            for (RegressionTree tree : this.trees) {
                score += this.eta * tree.predict(features);
            }
            return score;
        }

        public void add(RegressionTree tree) {
            this.trees.add(tree);
        }
    }
}

