/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import smile.util.SimpleDeamonThreadFactory;

public class MulticoreExecutor {
    private static final int nprocs;
    private static ThreadPoolExecutor threads;

    public static int getThreadPoolSize() {
        return nprocs;
    }

    public static <T> List<T> run(Collection<? extends Callable<T>> tasks) throws Exception {
        ArrayList<T> results = new ArrayList<T>();
        if (threads == null) {
            for (Callable<T> task : tasks) {
                results.add(task.call());
            }
        } else if (threads.getActiveCount() < nprocs) {
            List futures = threads.invokeAll(tasks);
            for (Future future : futures) {
                results.add(future.get());
            }
        } else {
            for (Callable<T> task : tasks) {
                results.add(task.call());
            }
        }
        return results;
    }

    public static void shutdown() {
        if (threads != null) {
            threads.shutdown();
        }
    }

    static {
        threads = null;
        int n = -1;
        try {
            String env = System.getenv("SMILE_NUM_THREADS");
            if (env != null) {
                n = Integer.parseInt(env);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        nprocs = n == -1 ? Runtime.getRuntime().availableProcessors() : n;
        if (nprocs > 1) {
            threads = (ThreadPoolExecutor)Executors.newFixedThreadPool(nprocs, new SimpleDeamonThreadFactory());
        }
    }
}

