/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.sort.QuickSort;

public class AUC {
    public double measure(int[] truth, double[] probability) {
        if (truth.length != probability.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, probability.length));
        }
        int totalPositive = 0;
        int totalNegative = 0;
        int[] label = (int[])truth.clone();
        double[] predicition = (double[])probability.clone();
        for (int i = 0; i < truth.length; ++i) {
            if (label[i] == 0) {
                ++totalNegative;
                continue;
            }
            if (label[i] == 1) {
                ++totalPositive;
                continue;
            }
            throw new IllegalArgumentException("AUC is only for binary classification. Invalid label: " + label[i]);
        }
        QuickSort.sort(predicition, label);
        double fp = 0.0;
        double tp = 0.0;
        double fpPrev = 0.0;
        double tpPrev = 0.0;
        double area = 0.0;
        double fPrev = Double.MIN_VALUE;
        for (int i = 0; i < truth.length; ++i) {
            double curF = predicition[i];
            if (curF != fPrev) {
                area += Math.abs(fp - fpPrev) * ((tp + tpPrev) / 2.0);
                fPrev = curF;
                fpPrev = fp;
                tpPrev = tp;
            }
            if (label[i] == 1) {
                tp += 1.0;
                continue;
            }
            fp += 1.0;
        }
        area += Math.abs((double)totalNegative - fpPrev) * (((double)totalPositive + tpPrev) / 2.0);
        return area /= (double)totalPositive * (double)totalNegative;
    }
}

