/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.math.Math;
import smile.validation.ClusterMeasure;

public class AdjustedRandIndex
implements ClusterMeasure {
    @Override
    public double measure(int[] y1, int[] y2) {
        if (y1.length != y2.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", y1.length, y2.length));
        }
        int n = y1.length;
        int[] label1 = Math.unique(y1);
        int n1 = label1.length;
        int[] label2 = Math.unique(y2);
        int n2 = label2.length;
        int[][] count = new int[n1][n2];
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                int match = 0;
                for (int k = 0; k < n; ++k) {
                    if (y1[k] != label1[i] || y2[k] != label2[j]) continue;
                    ++match;
                }
                count[i][j] = match;
            }
        }
        int[] count1 = new int[n1];
        int[] count2 = new int[n2];
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = i;
                count1[n3] = count1[n3] + count[i][j];
                int n4 = j;
                count2[n4] = count2[n4] + count[i][j];
            }
        }
        double rand1 = 0.0;
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (count[i][j] < 2) continue;
                rand1 += Math.choose(count[i][j], 2);
            }
        }
        double rand2a = 0.0;
        for (int i = 0; i < n1; ++i) {
            if (count1[i] < 2) continue;
            rand2a += Math.choose(count1[i], 2);
        }
        double rand2b = 0.0;
        for (int j = 0; j < n2; ++j) {
            if (count2[j] < 2) continue;
            rand2b += Math.choose(count2[j], 2);
        }
        double rand3 = rand2a * rand2b;
        double rand_N = rand1 - (rand3 /= Math.choose(n, 2));
        double rand4 = (rand2a + rand2b) / 2.0;
        double rand_D = rand4 - rand3;
        double rand = rand_N / rand_D;
        return rand;
    }

    public String toString() {
        return "Adjusted Rand Index";
    }
}

