/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.math.Random;

public class CrossValidation {
    public final int k;
    public final int[][] train;
    public final int[][] test;

    public CrossValidation(int n, int k) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid sample size: " + n);
        }
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("Invalid number of CV rounds: " + k);
        }
        this.k = k;
        Random random = new Random(System.currentTimeMillis());
        int[] index = random.permutate(n);
        this.train = new int[k][];
        this.test = new int[k][];
        int chunk = n / k;
        for (int i = 0; i < k; ++i) {
            int start2 = chunk * i;
            int end = chunk * (i + 1);
            if (i == k - 1) {
                end = n;
            }
            this.train[i] = new int[n - end + start2];
            this.test[i] = new int[end - start2];
            int p = 0;
            int q = 0;
            for (int j = 0; j < n; ++j) {
                if (j >= start2 && j < end) {
                    this.test[i][p++] = index[j];
                    continue;
                }
                this.train[i][q++] = index[j];
            }
        }
    }
}

