/*
 * Decompiled with CFR 0.152.
 */
package smile.wavelet;

import smile.wavelet.Wavelet;

public class HaarWavelet
extends Wavelet {
    private static final double C = 0.7071067811865475;
    private double[] workspace = new double[1024];

    public HaarWavelet() {
        super(null);
    }

    @Override
    void forward(double[] a, int n) {
        if (n < 4) {
            return;
        }
        if (n > this.workspace.length) {
            this.workspace = new double[n];
        }
        int n1 = n - 1;
        int nh = n >> 1;
        int i = 0;
        int j = 1;
        while (j < n1) {
            this.workspace[i] = 0.7071067811865475 * (a[j] + a[j + 1]);
            this.workspace[i + nh] = 0.7071067811865475 * (a[j] - a[j + 1]);
            j += 2;
            ++i;
        }
        this.workspace[i] = 0.7071067811865475 * (a[n - 1] + a[0]);
        this.workspace[i + nh] = 0.7071067811865475 * (a[n - 1] - a[0]);
        System.arraycopy(this.workspace, 0, a, 0, n);
    }

    @Override
    void backward(double[] a, int n) {
        if (n < 4) {
            return;
        }
        if (n > this.workspace.length) {
            this.workspace = new double[n];
        }
        int nh = n >> 1;
        int nh1 = nh - 1;
        this.workspace[0] = 0.7071067811865475 * (a[nh1] - a[n - 1]);
        this.workspace[n - 1] = 0.7071067811865475 * (a[nh1] + a[n - 1]);
        int j = 1;
        for (int i = 0; i < nh1; ++i) {
            this.workspace[j++] = 0.7071067811865475 * (a[i] + a[i + nh]);
            this.workspace[j++] = 0.7071067811865475 * (a[i] - a[i + nh]);
        }
        System.arraycopy(this.workspace, 0, a, 0, n);
    }
}

