/*
 * Decompiled with CFR 0.152.
 */
package hivemall.xgboost.utils;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;

public abstract class DMatrixBuilder {
    protected static final void checkColIndex(int col) {
        if (col < 0) {
            throw new IllegalArgumentException("Found negative column index: " + col);
        }
    }

    public void nextRow(@Nonnull float[] row) {
        for (int col = 0; col < row.length; ++col) {
            this.nextColumn(col, row[col]);
        }
        this.nextRow();
    }

    public void nextRow(@Nonnull String[] row) {
        for (String col : row) {
            if (col == null) continue;
            this.nextColumn(col);
        }
        this.nextRow();
    }

    public void nextRow(@Nonnull String[] row, int start, int endEx) {
        int last = Math.min(endEx, row.length);
        for (int i = start; i < last; ++i) {
            String col = row[i];
            if (col == null) continue;
            this.nextColumn(col);
        }
        this.nextRow();
    }

    @Nonnull
    public abstract DMatrixBuilder nextRow();

    @Nonnull
    public abstract DMatrixBuilder nextColumn(@Nonnegative int var1, float var2);

    @Nonnull
    public DMatrixBuilder nextColumn(@Nonnull String col) {
        float value;
        String feature;
        int pos = col.indexOf(58);
        if (pos == 0) {
            throw new IllegalArgumentException("Invalid feature value representation: " + col);
        }
        if (pos > 0) {
            feature = col.substring(0, pos);
            String s2 = col.substring(pos + 1);
            value = Float.parseFloat(s2);
        } else {
            feature = col;
            value = 1.0f;
        }
        if (feature.indexOf(58) != -1) {
            throw new IllegalArgumentException("Invalid feature format `<index>:<value>`: " + col);
        }
        int colIndex = Integer.parseInt(feature);
        if (colIndex < 0) {
            throw new IllegalArgumentException("Col index MUST be greater than or equals to 0: " + colIndex);
        }
        return this.nextColumn(colIndex, value);
    }

    @Nonnull
    public abstract DMatrix buildMatrix(@Nonnull float[] var1) throws XGBoostError;
}

