/*
 * Decompiled with CFR 0.152.
 */
package hivemall.xgboost.utils;

import hivemall.utils.collections.arrays.SparseFloatArray;
import hivemall.xgboost.utils.DMatrixBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;

public final class DenseDMatrixBuilder
extends DMatrixBuilder {
    @Nonnull
    private final List<float[]> rows;
    private int maxNumColumns;
    @Nonnull
    private final SparseFloatArray rowProbe;

    public DenseDMatrixBuilder(@Nonnegative int initSize) {
        this.rows = new ArrayList<float[]>(initSize);
        this.maxNumColumns = 0;
        this.rowProbe = new SparseFloatArray(32);
    }

    @Override
    public DenseDMatrixBuilder nextColumn(@Nonnegative int col, float value) {
        DenseDMatrixBuilder.checkColIndex(col);
        this.maxNumColumns = Math.max(col + 1, this.maxNumColumns);
        if ((double)value == 0.0) {
            return this;
        }
        this.rowProbe.put(col, value);
        return this;
    }

    @Override
    public DenseDMatrixBuilder nextRow() {
        float[] row = this.rowProbe.toArray();
        this.rowProbe.clear();
        this.rows.add(row);
        return this;
    }

    @Override
    public DMatrix buildMatrix(@Nonnull float[] labels) throws XGBoostError {
        int numRows = this.rows.size();
        if (labels.length != numRows) {
            throw new XGBoostError(String.format("labels.length does not match to nrows. labels.length=%d, nrows=%d", labels.length, numRows));
        }
        float[] data = new float[numRows * this.maxNumColumns];
        Arrays.fill(data, Float.NaN);
        for (int i = 0; i < numRows; ++i) {
            float[] row = this.rows.get(i);
            int rowPtr = i * this.maxNumColumns;
            for (int j = 0; j < row.length; ++j) {
                int ij = rowPtr + j;
                data[ij] = row[j];
            }
        }
        DMatrix matrix = new DMatrix(data, numRows, this.maxNumColumns, Float.NaN);
        matrix.setLabel(labels);
        return matrix;
    }
}

