/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.base;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.base.MockFilenameChangeListener;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.changed.IChanged;
import org.apache.hop.core.changed.IHopObserver;
import org.apache.hop.core.database.DatabasePluginType;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.listeners.IContentChangedListener;
import org.apache.hop.core.listeners.ICurrentDirectoryChangedListener;
import org.apache.hop.core.listeners.IFilenameChangedListener;
import org.apache.hop.core.listeners.INameChangedListener;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.undo.ChangeAction;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractMetaTest {
    AbstractMeta meta;
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((IPluginType)DatabasePluginType.getInstance());
        PluginRegistry.init();
    }

    @Before
    public void setUp() throws Exception {
        this.meta = new AbstractMetaStub();
    }

    @Test
    public void testGetSetFilename() throws Exception {
        Assert.assertNull((Object)this.meta.getFilename());
        this.meta.setFilename("myfile");
        Assert.assertEquals((Object)"myfile", (Object)this.meta.getFilename());
    }

    @Test
    public void testAddNameChangedListener() throws Exception {
        this.meta.fireNameChangedListeners("a", "a");
        this.meta.fireNameChangedListeners("a", "b");
        this.meta.addNameChangedListener(null);
        this.meta.fireNameChangedListeners("a", "b");
        INameChangedListener listener = (INameChangedListener)Mockito.mock(INameChangedListener.class);
        this.meta.addNameChangedListener(listener);
        this.meta.fireNameChangedListeners("b", "a");
        ((INameChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).nameChanged((Object)this.meta, "b", "a");
        this.meta.removeNameChangedListener(null);
        this.meta.removeNameChangedListener(listener);
        this.meta.fireNameChangedListeners("b", "a");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testAddFilenameChangedListener() throws Exception {
        this.meta.fireFilenameChangedListeners("a", "a");
        this.meta.fireFilenameChangedListeners("a", "b");
        this.meta.addFilenameChangedListener(null);
        this.meta.fireFilenameChangedListeners("a", "b");
        IFilenameChangedListener listener = (IFilenameChangedListener)Mockito.mock(IFilenameChangedListener.class);
        this.meta.addFilenameChangedListener(listener);
        this.meta.fireFilenameChangedListeners("b", "a");
        ((IFilenameChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).filenameChanged((Object)this.meta, "b", "a");
        this.meta.removeFilenameChangedListener(null);
        this.meta.removeFilenameChangedListener(listener);
        this.meta.fireFilenameChangedListeners("b", "a");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testAddRemoveFireContentChangedListener() throws Exception {
        Assert.assertTrue((boolean)this.meta.getContentChangedListeners().isEmpty());
        IContentChangedListener listener = (IContentChangedListener)Mockito.mock(IContentChangedListener.class);
        this.meta.addContentChangedListener(listener);
        Assert.assertFalse((boolean)this.meta.getContentChangedListeners().isEmpty());
        this.meta.fireContentChangedListeners();
        ((IContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).contentChanged(Matchers.anyObject());
        ((IContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).contentSafe(Matchers.anyObject());
        this.meta.fireContentChangedListeners(true);
        ((IContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).contentChanged(Matchers.anyObject());
        ((IContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).contentSafe(Matchers.anyObject());
        this.meta.fireContentChangedListeners(false);
        ((IContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).contentChanged(Matchers.anyObject());
        ((IContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).contentSafe(Matchers.anyObject());
        this.meta.removeContentChangedListener(listener);
        Assert.assertTrue((boolean)this.meta.getContentChangedListeners().isEmpty());
    }

    @Test
    public void testAddCurrentDirectoryChangedListener() throws Exception {
        this.meta.fireNameChangedListeners("a", "a");
        this.meta.fireNameChangedListeners("a", "b");
        this.meta.addCurrentDirectoryChangedListener(null);
        this.meta.fireCurrentDirectoryChanged("a", "b");
        ICurrentDirectoryChangedListener listener = (ICurrentDirectoryChangedListener)Mockito.mock(ICurrentDirectoryChangedListener.class);
        this.meta.addCurrentDirectoryChangedListener(listener);
        this.meta.fireCurrentDirectoryChanged("b", "a");
        ((ICurrentDirectoryChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).directoryChanged((Object)this.meta, "b", "a");
        this.meta.fireCurrentDirectoryChanged("a", "a");
        this.meta.removeCurrentDirectoryChangedListener(null);
        this.meta.removeCurrentDirectoryChangedListener(listener);
        this.meta.fireNameChangedListeners("b", "a");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testAddRemoveViewUndo() throws Exception {
        Assert.assertEquals((long)0L, (long)this.meta.getUndoSize());
        this.meta.clearUndo();
        Assert.assertEquals((long)0L, (long)this.meta.getUndoSize());
        Assert.assertEquals((long)0L, (long)this.meta.getMaxUndo());
        this.meta.setMaxUndo(3);
        Assert.assertEquals((long)3L, (long)this.meta.getMaxUndo());
        Assert.assertNull((Object)this.meta.viewThisUndo());
        Assert.assertNull((Object)this.meta.viewPreviousUndo());
        Assert.assertNull((Object)this.meta.viewNextUndo());
        Assert.assertNull((Object)this.meta.previousUndo());
        Assert.assertNull((Object)this.meta.nextUndo());
        TransformMeta fromMeta = (TransformMeta)Mockito.mock(TransformMeta.class);
        TransformMeta toMeta = (TransformMeta)Mockito.mock(TransformMeta.class);
        Object[] from = new Object[]{fromMeta};
        Object[] to = new Object[]{toMeta};
        int[] pos = new int[]{};
        Point[] prev = new Point[]{};
        Point[] curr = new Point[]{};
        this.meta.addUndo(from, to, pos, prev, curr, 2, false);
        Assert.assertNotNull((Object)this.meta.viewThisUndo());
        Assert.assertNotNull((Object)this.meta.viewPreviousUndo());
        Assert.assertNull((Object)this.meta.viewNextUndo());
        this.meta.addUndo(from, to, pos, prev, curr, 1, false);
        Assert.assertNotNull((Object)this.meta.viewThisUndo());
        Assert.assertNotNull((Object)this.meta.viewPreviousUndo());
        Assert.assertNull((Object)this.meta.viewNextUndo());
        ChangeAction action = this.meta.previousUndo();
        Assert.assertNotNull((Object)action);
        Assert.assertEquals((Object)ChangeAction.ActionType.ChangeTransform, (Object)action.getType());
        Assert.assertNotNull((Object)this.meta.viewThisUndo());
        Assert.assertNotNull((Object)this.meta.viewPreviousUndo());
        Assert.assertNotNull((Object)this.meta.viewNextUndo());
        this.meta.addUndo(from, to, pos, prev, curr, 3, false);
        this.meta.addUndo(from, to, pos, prev, curr, 4, false);
        Assert.assertNotNull((Object)this.meta.previousUndo());
        Assert.assertNotNull((Object)this.meta.nextUndo());
        this.meta.setMaxUndo(1);
        Assert.assertEquals((long)1L, (long)this.meta.getUndoSize());
        this.meta.addUndo(from, to, pos, prev, curr, 2, false);
    }

    @Test
    public void testGetSetAttributes() throws Exception {
        Assert.assertNull((Object)this.meta.getAttributesMap());
        HashMap attributesMap = new HashMap();
        this.meta.setAttributesMap(attributesMap);
        Assert.assertNull((Object)this.meta.getAttributes("group1"));
        HashMap<String, String> group1Attributes = new HashMap<String, String>();
        attributesMap.put("group1", group1Attributes);
        Assert.assertEquals(group1Attributes, (Object)this.meta.getAttributes("group1"));
        Assert.assertNull((Object)this.meta.getAttribute("group1", "attr1"));
        group1Attributes.put("attr1", "value1");
        Assert.assertEquals((Object)"value1", (Object)this.meta.getAttribute("group1", "attr1"));
        Assert.assertNull((Object)this.meta.getAttribute("group1", "attr2"));
        this.meta.setAttribute("group1", "attr2", "value2");
        Assert.assertEquals((Object)"value2", (Object)this.meta.getAttribute("group1", "attr2"));
        this.meta.setAttributes("group2", null);
        Assert.assertNull((Object)this.meta.getAttributes("group2"));
        this.meta.setAttribute("group2", "attr3", "value3");
        Assert.assertNull((Object)this.meta.getAttribute("group3", "attr4"));
    }

    @Test
    public void testNotes() throws Exception {
        Assert.assertNull((Object)this.meta.getNotes());
        this.meta.clear();
        Assert.assertNotNull((Object)this.meta.getNotes());
        Assert.assertTrue((boolean)this.meta.getNotes().isEmpty());
        IndexOutOfBoundsException e = null;
        try {
            Assert.assertNull((Object)this.meta.getNote(0));
        }
        catch (IndexOutOfBoundsException ioobe) {
            e = ioobe;
        }
        Assert.assertNotNull((Object)e);
        Assert.assertNull((Object)this.meta.getNote(20, 20));
        NotePadMeta note1 = (NotePadMeta)Mockito.mock(NotePadMeta.class);
        this.meta.removeNote(0);
        Assert.assertFalse((boolean)this.meta.hasChanged());
        this.meta.addNote(note1);
        Assert.assertTrue((boolean)this.meta.hasChanged());
        NotePadMeta note2 = (NotePadMeta)Mockito.mock(NotePadMeta.class);
        Mockito.when((Object)note2.getLocation()).thenReturn((Object)new Point(0, 0));
        Mockito.when((Object)note2.isSelected()).thenReturn((Object)true);
        this.meta.addNote(1, note2);
        Assert.assertEquals((Object)note2, (Object)this.meta.getNote(0, 0));
        List selectedNotes = this.meta.getSelectedNotes();
        Assert.assertNotNull((Object)selectedNotes);
        Assert.assertEquals((long)1L, (long)selectedNotes.size());
        Assert.assertEquals((Object)note2, selectedNotes.get(0));
        Assert.assertEquals((long)1L, (long)this.meta.indexOfNote(note2));
        this.meta.removeNote(2);
        Assert.assertEquals((long)2L, (long)this.meta.nrNotes());
        this.meta.removeNote(1);
        Assert.assertEquals((long)1L, (long)this.meta.nrNotes());
        Assert.assertTrue((boolean)this.meta.haveNotesChanged());
        this.meta.clearChanged();
        Assert.assertFalse((boolean)this.meta.haveNotesChanged());
        this.meta.addNote(1, note2);
        this.meta.lowerNote(1);
        Assert.assertTrue((boolean)this.meta.haveNotesChanged());
        this.meta.clearChanged();
        Assert.assertFalse((boolean)this.meta.haveNotesChanged());
        this.meta.raiseNote(0);
        Assert.assertTrue((boolean)this.meta.haveNotesChanged());
        this.meta.clearChanged();
        Assert.assertFalse((boolean)this.meta.haveNotesChanged());
        int[] indexes = this.meta.getNoteIndexes(Arrays.asList(note1, note2));
        Assert.assertNotNull((Object)indexes);
        Assert.assertEquals((long)2L, (long)indexes.length);
    }

    @Test
    public void testAddDeleteModifyObserver() throws Exception {
        IHopObserver observer = (IHopObserver)Mockito.mock(IHopObserver.class);
        this.meta.addObserver(observer);
        Object event = new Object();
        this.meta.notifyObservers(event);
        ((IHopObserver)Mockito.verify((Object)observer, (VerificationMode)Mockito.never())).update((IChanged)this.meta, event);
        this.meta.setChanged(true);
        this.meta.notifyObservers(event);
        ((IHopObserver)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).update((IChanged)Matchers.any(IChanged.class), Matchers.anyObject());
    }

    @Test
    public void testHasMissingPlugins() throws Exception {
        Assert.assertFalse((boolean)this.meta.hasMissingPlugins());
    }

    @Test
    public void testCanSave() {
        Assert.assertTrue((boolean)this.meta.canSave());
    }

    @Test
    public void testHasChanged() {
        this.meta.clear();
        Assert.assertFalse((boolean)this.meta.hasChanged());
        this.meta.setChanged(true);
        Assert.assertTrue((boolean)this.meta.hasChanged());
    }

    @Test
    public void testMultithreadHammeringOfListener() throws Exception {
        CountDownLatch latch = new CountDownLatch(3);
        AbstractMetaListenerThread th1 = new AbstractMetaListenerThread(this.meta, 1000000, latch, 50);
        AbstractMetaListenerThread th2 = new AbstractMetaListenerThread(this.meta, 1000000, latch, 50);
        AbstractMetaListenerThread th3 = new AbstractMetaListenerThread(this.meta, 1000000, latch, 50);
        Thread t1 = new Thread(th1);
        Thread t2 = new Thread(th2);
        Thread t3 = new Thread(th3);
        t1.start();
        t2.start();
        t3.start();
        latch.await();
        Assert.assertEquals((Object)"No exceptions encountered", (Object)th1.message);
        Assert.assertEquals((Object)"No exceptions encountered", (Object)th2.message);
        Assert.assertEquals((Object)"No exceptions encountered", (Object)th3.message);
    }

    private class AbstractMetaListenerThread
    implements Runnable {
        AbstractMeta metaToWork;
        int times;
        CountDownLatch whenDone;
        String message;
        int maxListeners;
        private Random random;

        AbstractMetaListenerThread(AbstractMeta aMeta, int times, CountDownLatch latch, int maxListeners) {
            this.metaToWork = aMeta;
            this.times = times;
            this.whenDone = latch;
            this.maxListeners = maxListeners;
            this.random = new Random(System.currentTimeMillis());
        }

        @Override
        public void run() {
            int i;
            for (i = 0; i < this.random.nextInt(this.maxListeners) / 2; ++i) {
                this.metaToWork.addFilenameChangedListener((IFilenameChangedListener)new MockFilenameChangeListener(this.random.nextInt(this.maxListeners)));
            }
            block11: for (i = 0; i < this.times; ++i) {
                int randomNum = this.random.nextInt(3);
                switch (randomNum) {
                    case 0: {
                        try {
                            this.metaToWork.addFilenameChangedListener((IFilenameChangedListener)new MockFilenameChangeListener(this.random.nextInt(this.maxListeners)));
                        }
                        catch (Throwable ex) {
                            this.message = "Exception adding listener.";
                        }
                        continue block11;
                    }
                    case 1: {
                        try {
                            this.metaToWork.removeFilenameChangedListener((IFilenameChangedListener)new MockFilenameChangeListener(this.random.nextInt(this.maxListeners)));
                        }
                        catch (Throwable ex) {
                            this.message = "Exception removing listener.";
                        }
                        continue block11;
                    }
                    default: {
                        try {
                            this.metaToWork.fireFilenameChangedListeners("oldName", "newName");
                            continue block11;
                        }
                        catch (Throwable ex) {
                            this.message = "Exception firing listeners.";
                        }
                    }
                }
            }
            if (this.message == null) {
                this.message = "No exceptions encountered";
            }
            this.whenDone.countDown();
        }
    }

    public static class AbstractMetaStub
    extends AbstractMeta {
        protected String getExtension() {
            return ".ext";
        }

        public String getName() {
            return null;
        }

        public void setName(String newName) {
        }

        public boolean isNameSynchronizedWithFilename() {
            return false;
        }

        public void setNameSynchronizedWithFilename(boolean nameSynchronizedWithFilename) {
        }

        public String getDescription() {
            return null;
        }

        public void setDescription(String description) {
        }

        public String getExtendedDescription() {
            return null;
        }

        public void setExtendedDescription(String extendedDescription) {
        }

        public void setInternalHopVariables(IVariables var) {
        }

        protected void setInternalFilenameHopVariables(IVariables var) {
        }

        protected void setInternalNameHopVariable(IVariables var) {
        }

        public Date getCreatedDate() {
            return null;
        }

        public void setCreatedDate(Date createdDate) {
        }

        public void setCreatedUser(String createdUser) {
        }

        public String getCreatedUser() {
            return null;
        }

        public void setModifiedDate(Date modifiedDate) {
        }

        public Date getModifiedDate() {
            return null;
        }

        public void setModifiedUser(String modifiedUser) {
        }

        public String getModifiedUser() {
            return null;
        }

        public String getXml(IVariables variables) throws HopException {
            return null;
        }
    }
}

