/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.base;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.memory.MemoryMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.loadsave.getter.IGetter;
import org.apache.hop.pipeline.transforms.loadsave.initializer.IInitializer;
import org.apache.hop.pipeline.transforms.loadsave.setter.ISetter;
import org.apache.hop.pipeline.transforms.loadsave.validator.DefaultFieldLoadSaveValidatorFactory;
import org.apache.hop.pipeline.transforms.loadsave.validator.IFieldLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.IFieldLoadSaveValidatorFactory;
import org.apache.test.util.JavaBeanManipulator;
import org.mockito.Mockito;

public abstract class LoadSaveBase<T> {
    protected final Class<T> clazz;
    protected final List<String> attributes;
    protected final JavaBeanManipulator<T> manipulator;
    protected final IFieldLoadSaveValidatorFactory fieldLoadSaveValidatorFactory;
    protected final IInitializer<T> initializer;
    protected IHopMetadataProvider metadataProvider;

    public LoadSaveBase(Class<T> clazz, List<String> attributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, IFieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, IFieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap, IInitializer<T> initializer) throws HopException {
        this.clazz = clazz;
        this.attributes = new ArrayList<String>(attributes);
        this.addHopMetadataPropertyCommonAttributes();
        this.manipulator = new JavaBeanManipulator<T>(clazz, this.attributes, getterMap, setterMap);
        this.initializer = initializer;
        HashMap fieldLoadSaveValidatorMethodMap = new HashMap(fieldLoadSaveValidatorAttributeMap.size());
        for (Map.Entry<String, IFieldLoadSaveValidator<?>> entry : fieldLoadSaveValidatorAttributeMap.entrySet()) {
            fieldLoadSaveValidatorMethodMap.put(this.manipulator.getGetter(entry.getKey()), entry.getValue());
        }
        this.fieldLoadSaveValidatorFactory = new DefaultFieldLoadSaveValidatorFactory(fieldLoadSaveValidatorMethodMap, fieldLoadSaveValidatorTypeMap);
        this.metadataProvider = new MemoryMetadataProvider();
    }

    public LoadSaveBase(Class<T> clazz, List<String> attributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, IFieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, IFieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap) throws HopException {
        this(clazz, attributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap, null);
    }

    public LoadSaveBase(Class<T> clazz, List<String> attributes) throws HopException {
        this(clazz, attributes, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap(), new HashMap());
    }

    private void addHopMetadataPropertyCommonAttributes() throws HopException {
        try {
            ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(this.clazz.getFields()));
            fields.addAll(Arrays.asList(this.clazz.getDeclaredFields()));
            for (Field field : fields) {
                String attribute;
                HopMetadataProperty annotation;
                if (Modifier.isTransient(field.getModifiers()) || (annotation = field.getAnnotation(HopMetadataProperty.class)) == null || this.attributes.contains(attribute = field.getName())) continue;
                this.attributes.add(attribute);
            }
        }
        catch (Exception e) {
            throw new HopException("Error adding common attributes from Hop metadata properties", (Throwable)e);
        }
    }

    public T createMeta() {
        try {
            T meta = this.clazz.newInstance();
            if (meta instanceof BaseTransformMeta) {
                TransformMeta mockParentTransformMeta = (TransformMeta)Mockito.mock(TransformMeta.class);
                ((BaseTransformMeta)meta).setParentTransformMeta(mockParentTransformMeta);
                PipelineMeta mockPipelineMeta = (PipelineMeta)Mockito.mock(PipelineMeta.class);
                Mockito.when((Object)mockParentTransformMeta.getParentPipelineMeta()).thenReturn((Object)mockPipelineMeta);
            }
            return meta;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create meta of class " + this.clazz.getCanonicalName(), e);
        }
    }

    protected Map<String, IFieldLoadSaveValidator<?>> createValidatorMapAndInvokeSetters(List<String> attributes, T metaToSave) {
        HashMap validatorMap = new HashMap();
        this.metadataProvider = new MemoryMetadataProvider();
        for (String attribute : attributes) {
            IGetter<?> getter = this.manipulator.getGetter(attribute);
            ISetter<?> setter = this.manipulator.getSetter(attribute);
            IFieldLoadSaveValidator<?> validator = this.fieldLoadSaveValidatorFactory.createValidator(getter);
            try {
                Object testValue = validator.getTestObject();
                setter.set(metaToSave, testValue);
                if (testValue instanceof DatabaseMeta) {
                    this.addDatabase((DatabaseMeta)testValue);
                } else if (testValue instanceof DatabaseMeta[]) {
                    this.addDatabase((DatabaseMeta[])testValue);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke setter for " + attribute, e);
            }
            validatorMap.put(attribute, validator);
        }
        return validatorMap;
    }

    protected void validateLoadedMeta(List<String> attributes, Map<String, IFieldLoadSaveValidator<?>> validatorMap, T metaSaved, T metaLoaded) {
        for (String attribute : attributes) {
            try {
                IGetter<?> getterMethod = this.manipulator.getGetter(attribute);
                Object originalValue = getterMethod.get(metaSaved);
                Object value = getterMethod.get(metaLoaded);
                IFieldLoadSaveValidator<?> validator = validatorMap.get(attribute);
                Method[] validatorMethods = validator.getClass().getMethods();
                Method validatorMethod = null;
                for (Method method : validatorMethods) {
                    Class<?>[] types;
                    if (!"validateTestObject".equals(method.getName()) || (types = method.getParameterTypes()).length != 2 || types[1] != Object.class || originalValue != null && !types[0].isAssignableFrom(originalValue.getClass())) continue;
                    validatorMethod = method;
                    break;
                }
                if (validatorMethod == null) {
                    throw new RuntimeException("Couldn't find proper validateTestObject method on " + validator.getClass().getCanonicalName());
                }
                if (((Boolean)validatorMethod.invoke(validator, originalValue, value)).booleanValue()) continue;
                throw new HopException("Attribute " + attribute + " started with value " + originalValue + " ended with value " + value);
            }
            catch (Exception e) {
                throw new RuntimeException("Error validating attribute: " + attribute, e);
            }
        }
    }

    private static <E> List<E> concat(List<E> list1, List<E> list2) {
        ArrayList<E> result = new ArrayList<E>(list1.size() + list2.size());
        result.addAll(list1);
        result.addAll(list2);
        return result;
    }

    protected void addDatabase(DatabaseMeta db) {
        try {
            this.metadataProvider.getSerializer(DatabaseMeta.class).save((IHopMetadata)db);
        }
        catch (HopException e) {
            throw new RuntimeException("Error adding database to the test metadata", e);
        }
    }

    protected void addDatabase(DatabaseMeta[] db) {
        if (db != null) {
            for (DatabaseMeta meta : db) {
                this.addDatabase(meta);
            }
        }
    }

    public IFieldLoadSaveValidatorFactory getFieldLoadSaveValidatorFactory() {
        return this.fieldLoadSaveValidatorFactory;
    }
}

