/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.concurrency;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hop.concurrency.ConcurrencyTestRunner;
import org.apache.hop.concurrency.StopOnErrorCallable;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.junit.Test;

public class ActiveSubPipelineConcurrencyTest {
    private static final int NUMBER_OF_GETTERS = 10;
    private static final int NUMBER_OF_CREATES = 10;
    private static final int NUMBER_OF_CREATE_CYCLES = 20;
    private static final int INITIAL_NUMBER_OF_PIPELINE = 100;
    private static final String PIPELINE_NAME = "pipeline";
    private final Object lock = new Object();

    @Test
    public void getAndCreateConcurrently() throws Exception {
        AtomicBoolean condition = new AtomicBoolean(true);
        LocalPipelineEngine pipeline = new LocalPipelineEngine();
        this.createSubPipeline((IPipelineEngine<PipelineMeta>)pipeline);
        List<Getter> getters = this.generateGetters((IPipelineEngine<PipelineMeta>)pipeline, condition);
        List<Creator> creators = this.generateCreators((IPipelineEngine<PipelineMeta>)pipeline, condition);
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(creators, getters, (AtomicBoolean)condition);
    }

    private void createSubPipeline(IPipelineEngine<PipelineMeta> pipeline) {
        for (int i = 0; i < 100; ++i) {
            pipeline.addActiveSubPipeline(this.createPipelineName(i), (IPipelineEngine)new LocalPipelineEngine());
        }
    }

    private List<Getter> generateGetters(IPipelineEngine<PipelineMeta> pipeline, AtomicBoolean condition) {
        ArrayList<Getter> getters = new ArrayList<Getter>();
        for (int i = 0; i < 10; ++i) {
            getters.add(new Getter(pipeline, condition));
        }
        return getters;
    }

    private List<Creator> generateCreators(IPipelineEngine<PipelineMeta> pipeline, AtomicBoolean condition) {
        ArrayList<Creator> creators = new ArrayList<Creator>();
        for (int i = 0; i < 10; ++i) {
            creators.add(new Creator(pipeline, condition));
        }
        return creators;
    }

    private String createPipelineName(int id) {
        return "pipeline - " + id;
    }

    private class Creator
    extends StopOnErrorCallable<Object> {
        private final IPipelineEngine<PipelineMeta> pipeline;
        private final Random random;

        Creator(IPipelineEngine<PipelineMeta> pipeline, AtomicBoolean condition) {
            super(condition);
            this.pipeline = pipeline;
            this.random = new Random();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object doCall() throws Exception {
            for (int i = 0; i < 20; ++i) {
                Object object = ActiveSubPipelineConcurrencyTest.this.lock;
                synchronized (object) {
                    String pipelineName = ActiveSubPipelineConcurrencyTest.this.createPipelineName(this.randomInt(100, Integer.MAX_VALUE));
                    this.pipeline.addActiveSubPipeline(pipelineName, (IPipelineEngine)new LocalPipelineEngine());
                    continue;
                }
            }
            return null;
        }

        private int randomInt(int min, int max) {
            return this.random.nextInt(max - min) + min;
        }
    }

    private class Getter
    extends StopOnErrorCallable<Object> {
        private final IPipelineEngine<PipelineMeta> pipeline;
        private final Random random;

        Getter(IPipelineEngine<PipelineMeta> pipeline, AtomicBoolean condition) {
            super(condition);
            this.pipeline = pipeline;
            this.random = new Random();
        }

        Object doCall() throws Exception {
            while (this.condition.get()) {
                String activeSubPipelineName = ActiveSubPipelineConcurrencyTest.this.createPipelineName(this.random.nextInt(100));
                IPipelineEngine subPipeline = this.pipeline.getActiveSubPipeline(activeSubPipelineName);
                if (subPipeline != null) continue;
                throw new IllegalStateException(String.format("Returned pipeline must not be null. Pipeline name = %s", activeSubPipelineName));
            }
            return null;
        }
    }
}

