/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.concurrency;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hop.concurrency.ConcurrencyTestRunner;
import org.apache.hop.concurrency.StopOnErrorCallable;
import org.apache.hop.core.BlockingRowSet;
import org.junit.Assert;
import org.junit.Test;

public class BaseRowSetConcurrentTest {
    private static final int MUTATE_CIRCLES = 100;
    private static final int NUMBER_OF_MUTATORS = 20;
    private static final int NUMBER_OF_GETTERS = 20;

    @Test
    public void test() throws Exception {
        BlockingRowSet sharedBlockingRowSet = new BlockingRowSet(100);
        sharedBlockingRowSet.setThreadNameFromToCopy("1", 1, "1", 1);
        AtomicBoolean condition = new AtomicBoolean(true);
        List<Mutator> mutators = this.generateMutators(sharedBlockingRowSet, condition);
        List<Getter> getters = this.generateGetters(sharedBlockingRowSet, condition);
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(mutators, getters, (AtomicBoolean)condition);
    }

    private List<Getter> generateGetters(BlockingRowSet blockingRowSet, AtomicBoolean condition) {
        ArrayList<Getter> getters = new ArrayList<Getter>(20);
        for (int i = 0; i < 20; ++i) {
            getters.add(new Getter(blockingRowSet, condition));
        }
        return getters;
    }

    private List<Mutator> generateMutators(BlockingRowSet blockingRowSet, AtomicBoolean condition) {
        ArrayList<Mutator> mutators = new ArrayList<Mutator>(20);
        for (int i = 0; i < 20; ++i) {
            mutators.add(new Mutator(blockingRowSet, condition));
        }
        return mutators;
    }

    private class Getter
    extends StopOnErrorCallable<Object> {
        private final BlockingRowSet blockingRowSet;

        private Getter(BlockingRowSet blockingRowSet, AtomicBoolean condition) {
            super(condition);
            this.blockingRowSet = blockingRowSet;
        }

        Object doCall() throws Exception {
            while (this.condition.get()) {
                this.checkConsistency();
            }
            return null;
        }

        private void checkConsistency() {
            Set<String> ids = this.extractIds(this.blockingRowSet.toString());
            Assert.assertEquals((long)1L, (long)ids.size());
        }

        Set<String> extractIds(String string) {
            HashSet<String> ids = new HashSet<String>();
            Pattern pattern = Pattern.compile("\\d+");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                ids.add(matcher.group());
            }
            return ids;
        }
    }

    private class Mutator
    extends StopOnErrorCallable<Object> {
        private static final String STRING_DEFAULT = "<def>";
        private final BlockingRowSet blockingRowSet;
        private final Random random;

        public Mutator(BlockingRowSet blockingRowSet, AtomicBoolean condition) {
            super(condition);
            this.blockingRowSet = blockingRowSet;
            this.random = new Random();
        }

        Object doCall() throws Exception {
            for (int i = 0; i < 100; ++i) {
                int id = this.generateId();
                this.blockingRowSet.setThreadNameFromToCopy(STRING_DEFAULT + id, id, STRING_DEFAULT + id, id);
            }
            return null;
        }

        private int generateId() {
            return this.random.nextInt();
        }
    }
}

