/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.concurrency;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hop.concurrency.ConcurrencyTestRunner;
import org.apache.hop.concurrency.StopOnErrorCallable;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformPartitioningMeta;
import org.junit.Test;
import org.mockito.Mockito;

public class BaseTransformConcurrencyTest {
    private static final String TRANSFORM_META = "TransformMeta";
    private BaseTransform<ITransformMeta, ITransformData> baseTransform;

    @Test
    public void testRowListeners() throws Exception {
        int modifiersAmount = 100;
        int traversersAmount = 100;
        TransformMeta transformMeta = (TransformMeta)Mockito.mock(TransformMeta.class);
        PipelineMeta pipelineMeta = (PipelineMeta)Mockito.mock(PipelineMeta.class);
        Mockito.when((Object)transformMeta.getName()).thenReturn((Object)TRANSFORM_META);
        Mockito.when((Object)pipelineMeta.findTransform(TRANSFORM_META)).thenReturn((Object)transformMeta);
        Mockito.when((Object)transformMeta.getTargetTransformPartitioningMeta()).thenReturn((Object)((TransformPartitioningMeta)Mockito.mock(TransformPartitioningMeta.class)));
        this.baseTransform = new BaseTransform(transformMeta, null, null, 0, pipelineMeta, (Pipeline)Mockito.spy((Object)new LocalPipelineEngine()));
        AtomicBoolean condition = new AtomicBoolean(true);
        ArrayList<RowListenersModifier> rowListenersModifiers = new ArrayList<RowListenersModifier>();
        for (int i = 0; i < modifiersAmount; ++i) {
            rowListenersModifiers.add(new RowListenersModifier(condition));
        }
        ArrayList<RowListenersTraverser> rowListenersTraversers = new ArrayList<RowListenersTraverser>();
        for (int i = 0; i < traversersAmount; ++i) {
            rowListenersTraversers.add(new RowListenersTraverser(condition));
        }
        ConcurrencyTestRunner runner = new ConcurrencyTestRunner(rowListenersModifiers, rowListenersTraversers, condition);
        runner.runConcurrentTest();
        runner.checkNoExceptionRaised();
    }

    @Test
    public void testInputOutputRowSets() throws Exception {
        int modifiersAmount = 100;
        int traversersAmount = 100;
        TransformMeta transformMeta = (TransformMeta)Mockito.mock(TransformMeta.class);
        PipelineMeta pipelineMeta = (PipelineMeta)Mockito.mock(PipelineMeta.class);
        Mockito.when((Object)transformMeta.getName()).thenReturn((Object)TRANSFORM_META);
        Mockito.when((Object)pipelineMeta.findTransform(TRANSFORM_META)).thenReturn((Object)transformMeta);
        Mockito.when((Object)transformMeta.getTargetTransformPartitioningMeta()).thenReturn((Object)((TransformPartitioningMeta)Mockito.mock(TransformPartitioningMeta.class)));
        this.baseTransform = new BaseTransform(transformMeta, null, null, 0, pipelineMeta, (Pipeline)Mockito.spy((Object)new LocalPipelineEngine()));
        AtomicBoolean condition = new AtomicBoolean(true);
        ArrayList<RowSetsModifier> rowSetsModifiers = new ArrayList<RowSetsModifier>();
        for (int i = 0; i < modifiersAmount; ++i) {
            rowSetsModifiers.add(new RowSetsModifier(condition));
        }
        ArrayList<RowSetsTraverser> rowSetsTraversers = new ArrayList<RowSetsTraverser>();
        for (int i = 0; i < traversersAmount; ++i) {
            rowSetsTraversers.add(new RowSetsTraverser(condition));
        }
        ConcurrencyTestRunner runner = new ConcurrencyTestRunner(rowSetsModifiers, rowSetsTraversers, condition);
        runner.runConcurrentTest();
        runner.checkNoExceptionRaised();
    }

    private class RowListenersTraverser
    extends StopOnErrorCallable<BaseTransform> {
        RowListenersTraverser(AtomicBoolean condition) {
            super(condition);
        }

        BaseTransform doCall() throws Exception {
            for (IRowListener rowListener : BaseTransformConcurrencyTest.this.baseTransform.getRowListeners()) {
                rowListener.rowWrittenEvent((IRowMeta)Mockito.mock(IRowMeta.class), new Object[0]);
            }
            return null;
        }
    }

    private class RowListenersModifier
    extends StopOnErrorCallable<BaseTransform> {
        RowListenersModifier(AtomicBoolean condition) {
            super(condition);
        }

        BaseTransform doCall() {
            BaseTransformConcurrencyTest.this.baseTransform.addRowListener((IRowListener)Mockito.mock(IRowListener.class));
            return null;
        }
    }

    private class RowSetsTraverser
    extends StopOnErrorCallable<BaseTransform> {
        RowSetsTraverser(AtomicBoolean condition) {
            super(condition);
        }

        BaseTransform doCall() {
            for (IRowSet rowSet : BaseTransformConcurrencyTest.this.baseTransform.getInputRowSets()) {
                rowSet.setRowMeta((IRowMeta)Mockito.mock(IRowMeta.class));
            }
            for (IRowSet rowSet : BaseTransformConcurrencyTest.this.baseTransform.getOutputRowSets()) {
                rowSet.setRowMeta((IRowMeta)Mockito.mock(IRowMeta.class));
            }
            return null;
        }
    }

    private class RowSetsModifier
    extends StopOnErrorCallable<BaseTransform> {
        RowSetsModifier(AtomicBoolean condition) {
            super(condition);
        }

        BaseTransform doCall() {
            BaseTransformConcurrencyTest.this.baseTransform.addRowSetToInputRowSets((IRowSet)Mockito.mock(IRowSet.class));
            BaseTransformConcurrencyTest.this.baseTransform.addRowSetToOutputRowSets((IRowSet)Mockito.mock(IRowSet.class));
            return null;
        }
    }
}

