/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.concurrency;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hop.concurrency.ConcurrencyTestRunner;
import org.apache.hop.concurrency.ExecutionResult;
import org.apache.hop.concurrency.StopOnErrorCallable;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.junit.Assert;
import org.junit.Test;

public class RowMetaConcurrencyTest {
    private static final int cycles = 50;

    @Test
    public void fiveAddersAgainstTenReaders() throws Exception {
        int addersAmount = 5;
        int readersAmount = 10;
        AtomicBoolean condition = new AtomicBoolean(true);
        RowMeta rowMeta = new RowMeta();
        ArrayList<Adder> adders = new ArrayList<Adder>(5);
        for (int i = 0; i < 5; ++i) {
            adders.add(new Adder(condition, rowMeta, 50, "adder" + i));
        }
        ArrayList<Getter> getters = new ArrayList<Getter>(10);
        for (int i = 0; i < 10; ++i) {
            getters.add(new Getter(condition, rowMeta));
        }
        ConcurrencyTestRunner runner = new ConcurrencyTestRunner(adders, getters, condition);
        runner.runConcurrentTest();
        runner.checkNoExceptionRaised();
        HashSet results = new HashSet(250);
        for (List list : runner.getMonitoredTasksResults()) {
            results.addAll(list);
        }
        List metas = rowMeta.getValueMetaList();
        Assert.assertEquals((long)250L, (long)metas.size());
        Assert.assertEquals((long)250L, (long)results.size());
        for (IValueMeta meta : metas) {
            Assert.assertTrue((String)meta.getName(), (boolean)results.remove(meta));
        }
        Assert.assertTrue((boolean)results.isEmpty());
    }

    @Test
    public void fiveShufflersAgainstTenSearchers() throws Exception {
        int elementsAmount = 100;
        int shufflersAmount = 5;
        int searchersAmount = 10;
        RowMeta rowMeta = new RowMeta();
        for (int i = 0; i < 100; ++i) {
            rowMeta.addValueMeta((IValueMeta)new ValueMetaString("meta_" + i));
        }
        AtomicBoolean condition = new AtomicBoolean(true);
        ArrayList<Shuffler> shufflers = new ArrayList<Shuffler>(5);
        for (int i = 0; i < 5; ++i) {
            shufflers.add(new Shuffler(condition, rowMeta, 50));
        }
        ArrayList<Searcher> searchers = new ArrayList<Searcher>(10);
        for (int i = 0; i < 10; ++i) {
            String name = "meta_" + new Random().nextInt(100);
            Assert.assertTrue((rowMeta.indexOfValue(name) >= 0 ? 1 : 0) != 0);
            searchers.add(new Searcher(condition, rowMeta, name));
        }
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(shufflers, searchers, (AtomicBoolean)condition);
    }

    @Test
    public void addRemoveSearch() throws Exception {
        int addersAmount = 5;
        int removeAmount = 10;
        int searchersAmount = 10;
        RowMeta rowMeta = new RowMeta();
        ArrayList<String> toRemove = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            String name = "toBeRemoved_" + i;
            toRemove.add(name);
            rowMeta.addValueMeta((IValueMeta)new ValueMetaString(name));
        }
        AtomicBoolean condition = new AtomicBoolean(true);
        ArrayList<Searcher> searchers = new ArrayList<Searcher>(10);
        for (int i = 0; i < 10; ++i) {
            String name = "kept_" + i;
            rowMeta.addValueMeta((IValueMeta)new ValueMetaString(name));
            searchers.add(new Searcher(condition, rowMeta, name));
        }
        List<Remover> removers = Collections.singletonList(new Remover(condition, rowMeta, toRemove));
        ArrayList<Adder> adders = new ArrayList<Adder>(5);
        for (int i = 0; i < 5; ++i) {
            adders.add(new Adder(condition, rowMeta, 50, "adder" + i));
        }
        ArrayList<StopOnErrorCallable> monitored = new ArrayList<StopOnErrorCallable>();
        monitored.addAll(adders);
        monitored.addAll(removers);
        ConcurrencyTestRunner runner = new ConcurrencyTestRunner(monitored, searchers, condition);
        runner.runConcurrentTest();
        runner.checkNoExceptionRaised();
        Map results = runner.getMonitoredResults();
        for (Remover remover : removers) {
            ExecutionResult result = (ExecutionResult)results.get((Object)remover);
            Assert.assertTrue((boolean)((List)result.getResult()).isEmpty());
            for (String name : remover.getToRemove()) {
                Assert.assertEquals((String)name, (long)-1L, (long)rowMeta.indexOfValue(name));
            }
        }
        HashSet metas = new HashSet(rowMeta.getValueMetaList());
        for (Adder adder : adders) {
            ExecutionResult result = (ExecutionResult)results.get((Object)adder);
            for (IValueMeta meta : (List)result.getResult()) {
                Assert.assertTrue((String)meta.getName(), (boolean)metas.remove(meta));
            }
        }
        Assert.assertEquals((long)10L, (long)metas.size());
    }

    private static class Remover
    extends StopOnErrorCallable<List<String>> {
        private final RowMeta rowMeta;
        private final List<String> toRemove;

        public Remover(AtomicBoolean condition, RowMeta rowMeta, List<String> toRemove) {
            super(condition);
            this.rowMeta = rowMeta;
            this.toRemove = toRemove;
        }

        List<String> doCall() throws Exception {
            Random random = new Random();
            LinkedList<String> result = new LinkedList<String>(this.toRemove);
            Iterator it = result.iterator();
            while (it.hasNext() && this.condition.get()) {
                String name = (String)it.next();
                this.rowMeta.removeValueMeta(name);
                it.remove();
                Thread.sleep(random.nextInt(100));
            }
            return result;
        }

        public List<String> getToRemove() {
            return this.toRemove;
        }
    }

    private static class Shuffler
    extends StopOnErrorCallable<Object> {
        private final RowMeta rowMeta;
        private final int cycles;

        public Shuffler(AtomicBoolean condition, RowMeta rowMeta, int cycles) {
            super(condition);
            this.rowMeta = rowMeta;
            this.cycles = cycles;
        }

        Object doCall() throws Exception {
            Random random = new Random();
            for (int i = 0; i < this.cycles && this.condition.get(); ++i) {
                ArrayList list = new ArrayList(this.rowMeta.getValueMetaList());
                Collections.shuffle(list);
                this.rowMeta.setValueMetaList(list);
                Thread.sleep(random.nextInt(100));
            }
            return null;
        }
    }

    private static class Searcher
    extends StopOnErrorCallable<Object> {
        private final RowMeta rowMeta;
        private final String name;

        public Searcher(AtomicBoolean condition, RowMeta rowMeta, String name) {
            super(condition);
            this.rowMeta = rowMeta;
            this.name = name;
        }

        Object doCall() throws Exception {
            Random random = new Random();
            while (this.condition.get()) {
                int index = this.rowMeta.indexOfValue(this.name);
                if (index < 0) {
                    throw new IllegalStateException(this.name + " was not found among " + this.rowMeta.getValueMetaList());
                }
                Thread.sleep(random.nextInt(100));
            }
            return null;
        }
    }

    private static class Adder
    extends StopOnErrorCallable<List<IValueMeta>> {
        private final RowMeta rowMeta;
        private final int cycles;
        private final String nameSeed;

        public Adder(AtomicBoolean condition, RowMeta rowMeta, int cycles, String nameSeed) {
            super(condition);
            this.rowMeta = rowMeta;
            this.cycles = cycles;
            this.nameSeed = nameSeed;
        }

        List<IValueMeta> doCall() throws Exception {
            Random random = new Random();
            ArrayList<IValueMeta> result = new ArrayList<IValueMeta>(this.cycles);
            for (int i = 0; i < this.cycles && this.condition.get(); ++i) {
                ValueMetaString added = new ValueMetaString(this.nameSeed + "_" + i);
                this.rowMeta.addValueMeta((IValueMeta)added);
                result.add((IValueMeta)added);
                Thread.sleep(random.nextInt(100));
            }
            return result;
        }
    }

    private static class Getter
    extends StopOnErrorCallable<Object> {
        private final RowMeta rowMeta;

        public Getter(AtomicBoolean condition, RowMeta rowMeta) {
            super(condition);
            this.rowMeta = rowMeta;
        }

        Object doCall() throws Exception {
            Random random = new Random();
            while (this.condition.get()) {
                int acc = 0;
                for (IValueMeta meta : this.rowMeta.getValueMetaList()) {
                    acc += meta.getType() / 10;
                }
                Thread.sleep(random.nextInt(Math.max(100, acc)));
            }
            return null;
        }
    }
}

