/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.concurrency;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.ListUtils;
import org.apache.hop.concurrency.ConcurrencyTestRunner;
import org.apache.hop.concurrency.StopOnErrorCallable;
import org.apache.hop.workflow.WorkflowConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engines.local.LocalWorkflowEngine;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.WorkflowMap;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class WorkflowMapConcurrencyTest {
    public static final String WORKFLOW_NAME_STRING = "workflow";
    public static final String WORKFLOW_ID_STRING = "workflow";
    public static final int INITIAL_WORKFLOW_MAP_SIZE = 100;
    private static final int gettersAmount = 20;
    private static final int replaceAmount = 20;
    private static final int updatersAmount = 20;
    private static final int updatersCycles = 100;
    private static WorkflowMap workflowMap;

    @BeforeClass
    public static void init() {
        workflowMap = new WorkflowMap();
        for (int i = 0; i < 100; ++i) {
            workflowMap.addWorkflow("workflow" + i, "workflow" + i, WorkflowMapConcurrencyTest.mockWorkflow(i), (WorkflowConfiguration)Mockito.mock(WorkflowConfiguration.class));
        }
    }

    private static IWorkflowEngine<WorkflowMeta> mockWorkflow(int id) {
        IWorkflowEngine workflow = (IWorkflowEngine)Mockito.mock(LocalWorkflowEngine.class);
        Mockito.when((Object)workflow.getWorkflowName()).thenReturn((Object)"workflow");
        Mockito.when((Object)workflow.getContainerId()).thenReturn((Object)("workflow" + id));
        return workflow;
    }

    @Test
    public void updateGetAndReplaceConcurrently() throws Exception {
        AtomicBoolean condition = new AtomicBoolean(true);
        AtomicInteger generator = new AtomicInteger(10);
        ArrayList<Updater> updaters = new ArrayList<Updater>();
        for (int i = 0; i < 20; ++i) {
            Updater updater = new Updater(workflowMap, generator, 100);
            updaters.add(updater);
        }
        ArrayList<Getter> getters = new ArrayList<Getter>();
        for (int i = 0; i < 20; ++i) {
            getters.add(new Getter(workflowMap, condition));
        }
        ArrayList<Replacer> replacers = new ArrayList<Replacer>();
        for (int i = 0; i < 20; ++i) {
            replacers.add(new Replacer(workflowMap, condition));
        }
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(updaters, (List)ListUtils.union(replacers, getters), (AtomicBoolean)condition);
    }

    private static class Replacer
    extends StopOnErrorCallable<Object> {
        private final WorkflowMap workflowMap;
        private final Random random;

        public Replacer(WorkflowMap workflowMap, AtomicBoolean condition) {
            super(condition);
            this.workflowMap = workflowMap;
            this.random = new Random();
        }

        public Object doCall() throws Exception {
            int i = this.random.nextInt(100);
            String workflowName = "workflow" + i;
            String workflowId = "workflow" + i;
            HopServerObjectEntry entry = new HopServerObjectEntry(workflowName, workflowId);
            this.workflowMap.replaceWorkflow(WorkflowMapConcurrencyTest.mockWorkflow(i + 1), WorkflowMapConcurrencyTest.mockWorkflow(i + 1), (WorkflowConfiguration)Mockito.mock(WorkflowConfiguration.class));
            return null;
        }
    }

    private static class Updater
    implements Callable<Exception> {
        private final WorkflowMap workflowMap;
        private final AtomicInteger generator;
        private final int cycles;

        public Updater(WorkflowMap workflowMap, AtomicInteger generator, int cycles) {
            this.workflowMap = workflowMap;
            this.generator = generator;
            this.cycles = cycles;
        }

        @Override
        public Exception call() throws Exception {
            Exception exception = null;
            try {
                for (int i = 0; i < this.cycles; ++i) {
                    int id = this.generator.get();
                    this.workflowMap.addWorkflow("workflow" + id, "workflow" + id, WorkflowMapConcurrencyTest.mockWorkflow(id), (WorkflowConfiguration)Mockito.mock(WorkflowConfiguration.class));
                }
            }
            catch (Exception e) {
                exception = e;
            }
            return exception;
        }
    }

    private static class Getter
    extends StopOnErrorCallable<Object> {
        private final WorkflowMap workflowMap;
        private final Random random;

        public Getter(WorkflowMap workflowMap, AtomicBoolean condition) {
            super(condition);
            this.workflowMap = workflowMap;
            this.random = new Random();
        }

        public Object doCall() throws Exception {
            while (this.condition.get()) {
                int i = this.random.nextInt(100);
                HopServerObjectEntry entry = (HopServerObjectEntry)this.workflowMap.getWorkflowObjects().get(i);
                if (entry == null) {
                    throw new IllegalStateException(String.format("Returned HopServerObjectEntry must not be null. EntryId = %d", i));
                }
                String workflowName = "workflow" + i;
                IWorkflowEngine workflow = this.workflowMap.getWorkflow(entry.getName());
                if (workflow == null) {
                    throw new IllegalStateException(String.format("Returned workflow must not be null. Workflow name = %s", workflowName));
                }
                WorkflowConfiguration workflowConfiguration = this.workflowMap.getConfiguration(entry.getName());
                if (workflowConfiguration != null) continue;
                throw new IllegalStateException(String.format("Returned workflowConfiguration must not be null. Workflow name = %s", workflowName));
            }
            return null;
        }
    }
}

