/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.concurrency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.ListUtils;
import org.apache.hop.concurrency.ConcurrencyTestRunner;
import org.apache.hop.concurrency.StopOnErrorCallable;
import org.apache.hop.core.gui.WorkflowTracker;
import org.apache.hop.workflow.ActionResult;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class WorkflowTrackerConcurrencyTest {
    private static final int gettersAmount = 10;
    private static final int searchersAmount = 20;
    private static final int updatersAmount = 5;
    private static final int updatersCycles = 10;
    private static final int jobsLimit = 20;
    private final WorkflowTracker tracker;

    @BeforeClass
    public static void setUp() {
        int jobsToBeAdded = 50;
        Assert.assertTrue((String)"The limit of stored workflows must be less than the amount of children to be added", (20 < jobsToBeAdded ? 1 : 0) != 0);
    }

    @Parameterized.Parameters
    public static List<Object[]> getData() {
        return Arrays.asList({new WorkflowTracker(WorkflowTrackerConcurrencyTest.mockWorkflowMeta("parent"))}, {new WorkflowTracker(WorkflowTrackerConcurrencyTest.mockWorkflowMeta("parent"), 20)});
    }

    private static WorkflowMeta mockWorkflowMeta(String name) {
        WorkflowMeta meta = (WorkflowMeta)Mockito.mock(WorkflowMeta.class);
        Mockito.when((Object)meta.getName()).thenReturn((Object)name);
        return meta;
    }

    public WorkflowTrackerConcurrencyTest(WorkflowTracker tracker) {
        this.tracker = tracker;
    }

    @Test
    public void readAndUpdateTrackerConcurrently() throws Exception {
        AtomicBoolean condition = new AtomicBoolean(true);
        ArrayList<Getter> getters = new ArrayList<Getter>(10);
        for (int i = 0; i < 10; ++i) {
            getters.add(new Getter(condition, this.tracker));
        }
        ArrayList<Searcher> searchers = new ArrayList<Searcher>(20);
        for (int i = 0; i < 20; ++i) {
            int lookingFor = 25 + i;
            Assert.assertTrue((String)"We are looking for reachable index", (lookingFor < 50 ? 1 : 0) != 0);
            searchers.add(new Searcher(condition, this.tracker, WorkflowTrackerConcurrencyTest.mockActionMeta("workflow-action-" + lookingFor)));
        }
        AtomicInteger generator = new AtomicInteger(0);
        ArrayList<Updater> updaters = new ArrayList<Updater>(5);
        for (int i = 0; i < 5; ++i) {
            updaters.add(new Updater(this.tracker, 10, generator, "workflow-action-%d"));
        }
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(updaters, (List)ListUtils.union(getters, searchers), (AtomicBoolean)condition);
        Assert.assertEquals((long)50L, (long)generator.get());
    }

    static ActionMeta mockActionMeta(String name) {
        ActionMeta copy = (ActionMeta)Mockito.mock(ActionMeta.class);
        Mockito.when((Object)copy.getName()).thenReturn((Object)name);
        return copy;
    }

    private static class Updater
    implements Callable<Exception> {
        private final WorkflowTracker tracker;
        private final int cycles;
        private final AtomicInteger idGenerator;
        private final String resultNameTemplate;

        public Updater(WorkflowTracker tracker, int cycles, AtomicInteger idGenerator, String resultNameTemplate) {
            this.tracker = tracker;
            this.cycles = cycles;
            this.idGenerator = idGenerator;
            this.resultNameTemplate = resultNameTemplate;
        }

        @Override
        public Exception call() throws Exception {
            Exception exception = null;
            try {
                for (int i = 0; i < this.cycles; ++i) {
                    int id = this.idGenerator.getAndIncrement();
                    ActionResult result = new ActionResult();
                    result.setActionName(String.format(this.resultNameTemplate, id));
                    WorkflowTracker child = new WorkflowTracker(WorkflowTrackerConcurrencyTest.mockWorkflowMeta("child-" + id), result);
                    this.tracker.addWorkflowTracker(child);
                }
            }
            catch (Exception e) {
                exception = e;
            }
            return exception;
        }
    }

    private static class Searcher
    extends StopOnErrorCallable<Object> {
        private final WorkflowTracker tracker;
        private final ActionMeta copy;

        public Searcher(AtomicBoolean condition, WorkflowTracker tracker, ActionMeta copy) {
            super(condition);
            this.tracker = tracker;
            this.copy = copy;
        }

        Object doCall() throws Exception {
            while (this.condition.get()) {
                this.tracker.findWorkflowTracker(this.copy);
            }
            return null;
        }
    }

    private static class Getter
    extends StopOnErrorCallable<Object> {
        private final WorkflowTracker tracker;
        private final Random random;

        public Getter(AtomicBoolean condition, WorkflowTracker tracker) {
            super(condition);
            this.tracker = tracker;
            this.random = new Random();
        }

        public Object doCall() throws Exception {
            while (this.condition.get()) {
                int i;
                WorkflowTracker t;
                int amount = this.tracker.nrWorkflowTrackers();
                if (amount == 0 || (t = this.tracker.getWorkflowTracker(i = this.random.nextInt(amount))) != null) continue;
                throw new IllegalStateException(String.format("Returned tracker must not be null. Index = %d, trackers' amount = %d", i, amount));
            }
            return null;
        }
    }
}

