/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.auth.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hop.core.auth.DelegatingKerberosConsumer;
import org.apache.hop.core.auth.DelegatingKerberosConsumerForClassloaderBridging;
import org.apache.hop.core.auth.DelegatingNoAuthConsumer;
import org.apache.hop.core.auth.DelegatingUsernamePasswordConsumer;
import org.apache.hop.core.auth.IKerberosAuthenticationProviderProxy;
import org.apache.hop.core.auth.KerberosAuthenticationProvider;
import org.apache.hop.core.auth.NoAuthenticationAuthenticationProvider;
import org.apache.hop.core.auth.UsernamePasswordAuthenticationProvider;
import org.apache.hop.core.auth.core.AuthenticationConsumerInvocationHandler;
import org.apache.hop.core.auth.core.AuthenticationConsumptionException;
import org.apache.hop.core.auth.core.AuthenticationFactoryException;
import org.apache.hop.core.auth.core.AuthenticationManager;
import org.apache.hop.core.auth.core.IAuthenticationConsumer;
import org.apache.hop.core.auth.core.IAuthenticationConsumerFactory;
import org.apache.hop.core.auth.core.IAuthenticationPerformer;
import org.apache.hop.core.auth.core.IAuthenticationPerformerFactory;
import org.apache.hop.core.auth.core.IAuthenticationProvider;
import org.apache.hop.core.auth.core.impl.ClassloaderBridgingAuthenticationPerformer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class AuthenticationManagerTest {
    private AuthenticationManager manager;
    private NoAuthenticationAuthenticationProvider noAuthenticationAuthenticationProvider;

    @Before
    public void setup() {
        this.manager = new AuthenticationManager();
        this.noAuthenticationAuthenticationProvider = new NoAuthenticationAuthenticationProvider();
        this.manager.registerAuthenticationProvider((IAuthenticationProvider)this.noAuthenticationAuthenticationProvider);
    }

    @Test
    public void testNoAuthProviderAndConsumer() throws AuthenticationConsumptionException, AuthenticationFactoryException {
        this.manager.registerConsumerClass(DelegatingNoAuthConsumer.class);
        IAuthenticationConsumer consumer = (IAuthenticationConsumer)Mockito.mock(IAuthenticationConsumer.class);
        this.manager.getAuthenticationPerformer(Object.class, IAuthenticationConsumer.class, "NO_AUTH").perform((Object)consumer);
        ((IAuthenticationConsumer)Mockito.verify((Object)consumer)).consume((Object)this.noAuthenticationAuthenticationProvider);
    }

    @Test
    public void testUsernamePasswordProviderConsumer() throws AuthenticationConsumptionException, AuthenticationFactoryException {
        this.manager.registerConsumerClass(DelegatingNoAuthConsumer.class);
        this.manager.registerConsumerClass(DelegatingUsernamePasswordConsumer.class);
        UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider = new UsernamePasswordAuthenticationProvider("upass", "u", "pass");
        this.manager.registerAuthenticationProvider((IAuthenticationProvider)usernamePasswordAuthenticationProvider);
        IAuthenticationConsumer consumer = (IAuthenticationConsumer)Mockito.mock(IAuthenticationConsumer.class);
        this.manager.getAuthenticationPerformer(Object.class, IAuthenticationConsumer.class, usernamePasswordAuthenticationProvider.getId()).perform((Object)consumer);
        ((IAuthenticationConsumer)Mockito.verify((Object)consumer)).consume((Object)usernamePasswordAuthenticationProvider);
    }

    @Test
    public void testKerberosProviderConsumer() throws AuthenticationConsumptionException, AuthenticationFactoryException {
        this.manager.registerConsumerClass(DelegatingNoAuthConsumer.class);
        this.manager.registerConsumerClass(DelegatingUsernamePasswordConsumer.class);
        this.manager.registerConsumerClass(DelegatingKerberosConsumer.class);
        KerberosAuthenticationProvider kerberosAuthenticationProvider = new KerberosAuthenticationProvider("kerb", "kerb", true, "pass", true, "none");
        this.manager.registerAuthenticationProvider((IAuthenticationProvider)kerberosAuthenticationProvider);
        IAuthenticationConsumer consumer = (IAuthenticationConsumer)Mockito.mock(IAuthenticationConsumer.class);
        this.manager.getAuthenticationPerformer(Object.class, IAuthenticationConsumer.class, kerberosAuthenticationProvider.getId()).perform((Object)consumer);
        ((IAuthenticationConsumer)Mockito.verify((Object)consumer)).consume((Object)kerberosAuthenticationProvider);
    }

    @Test
    public void testGetSupportedPerformers() throws AuthenticationConsumptionException, AuthenticationFactoryException {
        this.manager.registerConsumerClass(DelegatingNoAuthConsumer.class);
        this.manager.registerConsumerClass(DelegatingUsernamePasswordConsumer.class);
        this.manager.registerConsumerClass(DelegatingKerberosConsumer.class);
        UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider = new UsernamePasswordAuthenticationProvider("upass", "u", "pass");
        this.manager.registerAuthenticationProvider((IAuthenticationProvider)usernamePasswordAuthenticationProvider);
        KerberosAuthenticationProvider kerberosAuthenticationProvider = new KerberosAuthenticationProvider("kerb", "kerb", true, "pass", true, "none");
        this.manager.registerAuthenticationProvider((IAuthenticationProvider)kerberosAuthenticationProvider);
        List performers = this.manager.getSupportedAuthenticationPerformers(Object.class, IAuthenticationConsumer.class);
        Assert.assertEquals((long)3L, (long)performers.size());
        HashSet<String> ids = new HashSet<String>(Arrays.asList("NO_AUTH", usernamePasswordAuthenticationProvider.getId(), kerberosAuthenticationProvider.getId()));
        for (IAuthenticationPerformer performer : performers) {
            ids.remove(performer.getAuthenticationProvider().getId());
        }
        Assert.assertEquals((long)0L, (long)ids.size());
    }

    @Test
    public void testRegisterUnregisterProvider() throws AuthenticationFactoryException {
        this.manager.registerConsumerClass(DelegatingNoAuthConsumer.class);
        this.manager.registerConsumerClass(DelegatingUsernamePasswordConsumer.class);
        List performers = this.manager.getSupportedAuthenticationPerformers(Object.class, IAuthenticationConsumer.class);
        Assert.assertEquals((long)1L, (long)performers.size());
        HashSet<String> ids = new HashSet<String>(Arrays.asList("NO_AUTH"));
        for (IAuthenticationPerformer performer : performers) {
            ids.remove(performer.getAuthenticationProvider().getId());
        }
        Assert.assertEquals((long)0L, (long)ids.size());
        UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider = new UsernamePasswordAuthenticationProvider("upass", "u", "pass");
        this.manager.registerAuthenticationProvider((IAuthenticationProvider)usernamePasswordAuthenticationProvider);
        performers = this.manager.getSupportedAuthenticationPerformers(Object.class, IAuthenticationConsumer.class);
        Assert.assertEquals((long)2L, (long)performers.size());
        ids = new HashSet<String>(Arrays.asList("NO_AUTH", usernamePasswordAuthenticationProvider.getId()));
        for (IAuthenticationPerformer performer : performers) {
            ids.remove(performer.getAuthenticationProvider().getId());
        }
        Assert.assertEquals((long)0L, (long)ids.size());
        this.manager.unregisterAuthenticationProvider((IAuthenticationProvider)usernamePasswordAuthenticationProvider);
        performers = this.manager.getSupportedAuthenticationPerformers(Object.class, IAuthenticationConsumer.class);
        Assert.assertEquals((long)1L, (long)performers.size());
        ids = new HashSet<String>(Arrays.asList("NO_AUTH"));
        for (IAuthenticationPerformer performer : performers) {
            ids.remove(performer.getAuthenticationProvider().getId());
        }
        Assert.assertEquals((long)0L, (long)ids.size());
    }

    @Test
    public void testRegisterConsumerFactory() throws AuthenticationConsumptionException, AuthenticationFactoryException {
        IAuthenticationConsumer authConsumer = (IAuthenticationConsumer)Mockito.mock(IAuthenticationConsumer.class);
        IAuthenticationConsumerFactory factory = (IAuthenticationConsumerFactory)Mockito.mock(IAuthenticationConsumerFactory.class);
        Mockito.when((Object)factory.getReturnType()).thenReturn(Object.class);
        Mockito.when((Object)factory.getCreateArgType()).thenReturn(IAuthenticationConsumer.class);
        Mockito.when((Object)factory.getConsumedType()).thenReturn(KerberosAuthenticationProvider.class);
        Mockito.when((Object)factory.create((Object)authConsumer)).thenReturn((Object)authConsumer);
        KerberosAuthenticationProvider kerberosAuthenticationProvider = new KerberosAuthenticationProvider("kerb", "kerb", true, "pass", true, "none");
        this.manager.registerAuthenticationProvider((IAuthenticationProvider)kerberosAuthenticationProvider);
        this.manager.registerConsumerFactory(factory);
        this.manager.getAuthenticationPerformer(Object.class, IAuthenticationConsumer.class, kerberosAuthenticationProvider.getId()).perform((Object)authConsumer);
        ((IAuthenticationConsumer)Mockito.verify((Object)authConsumer)).consume((Object)kerberosAuthenticationProvider);
    }

    @Test
    public void testClassLoaderBridgingPerformer() throws AuthenticationConsumptionException, AuthenticationFactoryException {
        this.manager.setAuthenticationPerformerFactory(new IAuthenticationPerformerFactory(){

            public <ReturnType, CreateArgType, ConsumedType> IAuthenticationPerformer<ReturnType, CreateArgType> create(IAuthenticationProvider authenticationProvider, IAuthenticationConsumerFactory<ReturnType, CreateArgType, ConsumedType> authenticationConsumer) {
                if (AuthenticationConsumerInvocationHandler.isCompatible((Class)authenticationConsumer.getConsumedType(), (Object)authenticationProvider)) {
                    return new ClassloaderBridgingAuthenticationPerformer(authenticationProvider, authenticationConsumer);
                }
                return null;
            }
        });
        this.manager.registerConsumerClass(DelegatingNoAuthConsumer.class);
        this.manager.registerConsumerClass(DelegatingUsernamePasswordConsumer.class);
        this.manager.registerConsumerClass(DelegatingKerberosConsumerForClassloaderBridging.class);
        KerberosAuthenticationProvider kerberosAuthenticationProvider = new KerberosAuthenticationProvider("kerb", "kerb", true, "pass", true, "none");
        this.manager.registerAuthenticationProvider((IAuthenticationProvider)kerberosAuthenticationProvider);
        IAuthenticationConsumer consumer = (IAuthenticationConsumer)Mockito.mock(IAuthenticationConsumer.class);
        IAuthenticationPerformer performer = this.manager.getAuthenticationPerformer(Object.class, IAuthenticationConsumer.class, kerberosAuthenticationProvider.getId());
        Assert.assertNotNull((Object)performer);
        performer.perform((Object)consumer);
        ArgumentCaptor captor = ArgumentCaptor.forClass(IKerberosAuthenticationProviderProxy.class);
        ((IAuthenticationConsumer)Mockito.verify((Object)consumer)).consume((Object)((IKerberosAuthenticationProviderProxy)captor.capture()));
        Assert.assertEquals((Object)kerberosAuthenticationProvider.getId(), (Object)((IKerberosAuthenticationProviderProxy)captor.getValue()).getId());
        Assert.assertEquals((Object)kerberosAuthenticationProvider.getDisplayName(), (Object)((IKerberosAuthenticationProviderProxy)captor.getValue()).getDisplayName());
        Assert.assertEquals((Object)kerberosAuthenticationProvider.getPrincipal(), (Object)((IKerberosAuthenticationProviderProxy)captor.getValue()).getPrincipal());
        Assert.assertEquals((Object)kerberosAuthenticationProvider.getPassword(), (Object)((IKerberosAuthenticationProviderProxy)captor.getValue()).getPassword());
        Assert.assertEquals((Object)kerberosAuthenticationProvider.getKeytabLocation(), (Object)((IKerberosAuthenticationProviderProxy)captor.getValue()).getKeytabLocation());
        Assert.assertEquals((Object)kerberosAuthenticationProvider.isUseKeytab(), (Object)((IKerberosAuthenticationProviderProxy)captor.getValue()).isUseKeytab());
        Assert.assertEquals((Object)kerberosAuthenticationProvider.isUseExternalCredentials(), (Object)((IKerberosAuthenticationProviderProxy)captor.getValue()).isUseExternalCredentials());
    }
}

