/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hop.core.compress.CompressionInputStream;
import org.apache.hop.core.compress.CompressionPluginType;
import org.apache.hop.core.compress.CompressionProviderFactory;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class CompressionInputStreamTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();
    public static final String PROVIDER_NAME = "None";
    public CompressionProviderFactory factory = null;
    public CompressionInputStream inStream = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((IPluginType)CompressionPluginType.getInstance());
        PluginRegistry.init();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
        ICompressionProvider provider = this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayInputStream in = CompressionInputStreamTest.createTestInputStream();
        this.inStream = new DummyCompressionIS(in, provider);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        Assert.assertNotNull((Object)this.inStream);
    }

    @Test
    public void getCompressionProvider() {
        ICompressionProvider provider = this.inStream.getCompressionProvider();
        Assert.assertEquals((Object)provider.getName(), (Object)PROVIDER_NAME);
    }

    @Test
    public void testNextEntry() throws IOException {
        Assert.assertNull((Object)this.inStream.nextEntry());
    }

    @Test
    public void testClose() throws IOException {
        ICompressionProvider provider = this.inStream.getCompressionProvider();
        ByteArrayInputStream in = CompressionInputStreamTest.createTestInputStream();
        this.inStream = new DummyCompressionIS(in, provider);
        this.inStream.close();
    }

    @Test
    public void testRead() throws IOException {
        ICompressionProvider provider = this.inStream.getCompressionProvider();
        ByteArrayInputStream in = CompressionInputStreamTest.createTestInputStream();
        this.inStream = new DummyCompressionIS(in, provider);
        Assert.assertEquals((long)this.inStream.available(), (long)this.inStream.read(new byte[100], 0, this.inStream.available()));
    }

    @Test
    public void delegatesReadBuffer() throws Exception {
        ByteArrayInputStream in = CompressionInputStreamTest.createTestInputStream();
        in = (ByteArrayInputStream)Mockito.spy((Object)in);
        this.inStream = new DummyCompressionIS(in, this.inStream.getCompressionProvider());
        this.inStream.read(new byte[16]);
        ((ByteArrayInputStream)Mockito.verify((Object)in)).read((byte[])Matchers.any(byte[].class));
    }

    @Test
    public void delegatesReadBufferWithParams() throws Exception {
        ByteArrayInputStream in = CompressionInputStreamTest.createTestInputStream();
        in = (ByteArrayInputStream)Mockito.spy((Object)in);
        this.inStream = new DummyCompressionIS(in, this.inStream.getCompressionProvider());
        this.inStream.read(new byte[16], 0, 16);
        ((ByteArrayInputStream)Mockito.verify((Object)in)).read((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
    }

    private static ByteArrayInputStream createTestInputStream() {
        return new ByteArrayInputStream("Test".getBytes());
    }

    private static class DummyCompressionIS
    extends CompressionInputStream {
        public DummyCompressionIS(InputStream in, ICompressionProvider provider) {
            super(in, provider);
        }
    }
}

