/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hop.core.compress.CompressionOutputStream;
import org.apache.hop.core.compress.CompressionPluginType;
import org.apache.hop.core.compress.CompressionProviderFactory;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class CompressionOutputStreamTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();
    public static final String PROVIDER_NAME = "None";
    public CompressionProviderFactory factory = null;
    public CompressionOutputStream outStream = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((IPluginType)CompressionPluginType.getInstance());
        PluginRegistry.init();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
        ICompressionProvider provider = this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        this.outStream = new DummyCompressionOS(in, provider);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        Assert.assertNotNull((Object)this.outStream);
    }

    @Test
    public void getCompressionProvider() {
        ICompressionProvider provider = this.outStream.getCompressionProvider();
        Assert.assertEquals((Object)provider.getName(), (Object)PROVIDER_NAME);
    }

    @Test
    public void testClose() throws IOException {
        ICompressionProvider provider = this.outStream.getCompressionProvider();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outStream = new DummyCompressionOS(out, provider);
        this.outStream.close();
    }

    @Test
    public void testWrite() throws IOException {
        ICompressionProvider provider = this.outStream.getCompressionProvider();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outStream = new DummyCompressionOS(out, provider);
        this.outStream.write("Test".getBytes());
    }

    @Test
    public void testAddEntry() throws IOException {
        ICompressionProvider provider = this.outStream.getCompressionProvider();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outStream = new DummyCompressionOS(out, provider);
        this.outStream.addEntry(null, null);
    }

    private static class DummyCompressionOS
    extends CompressionOutputStream {
        public DummyCompressionOS(OutputStream out, ICompressionProvider provider) {
            super(out, provider);
        }
    }
}

