/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress.gzip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.hop.core.compress.CompressionPluginType;
import org.apache.hop.core.compress.CompressionProviderFactory;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.compress.gzip.GzipCompressionInputStream;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class GzipCompressionInputStreamTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();
    public static final String PROVIDER_NAME = "GZip";
    protected CompressionProviderFactory factory = null;
    protected GzipCompressionInputStream inStream = null;
    protected ICompressionProvider provider = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((IPluginType)CompressionPluginType.getInstance());
        PluginRegistry.init();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
        this.provider = this.factory.getCompressionProviderByName(PROVIDER_NAME);
        this.inStream = new GzipCompressionInputStream(this.createGZIPInputStream(), this.provider){};
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        Assert.assertNotNull((Object)this.inStream);
    }

    @Test
    public void getZIPCompressionProvider() {
        ICompressionProvider provider = this.inStream.getCompressionProvider();
        Assert.assertEquals((Object)provider.getName(), (Object)PROVIDER_NAME);
    }

    @Test
    public void testNextEntry() throws IOException {
        Assert.assertNull((Object)this.inStream.nextEntry());
    }

    @Test
    public void testClose() throws IOException {
        this.inStream = new GzipCompressionInputStream(this.createGZIPInputStream(), this.provider){};
        this.inStream.close();
    }

    @Test
    public void testRead() throws IOException {
        this.inStream = new GzipCompressionInputStream(this.createGZIPInputStream(), this.provider){};
        this.inStream.read(new byte[100], 0, this.inStream.available());
    }

    protected InputStream createGZIPInputStream() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        byte[] testBytes = "Test".getBytes();
        gos.write(testBytes);
        ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
        return in;
    }
}

