/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress.gzip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.hop.core.compress.CompressionPluginType;
import org.apache.hop.core.compress.CompressionProviderFactory;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.compress.gzip.GzipCompressionInputStream;
import org.apache.hop.core.compress.gzip.GzipCompressionOutputStream;
import org.apache.hop.core.compress.gzip.GzipCompressionProvider;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class GzipCompressionProviderTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();
    public static final String PROVIDER_NAME = "GZip";
    public CompressionProviderFactory factory = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((IPluginType)CompressionPluginType.getInstance());
        PluginRegistry.init();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        GzipCompressionProvider ncp = new GzipCompressionProvider();
        Assert.assertNotNull((Object)ncp);
    }

    @Test
    public void testGetName() {
        GzipCompressionProvider provider = (GzipCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        Assert.assertNotNull((Object)provider);
        Assert.assertEquals((Object)PROVIDER_NAME, (Object)provider.getName());
    }

    @Test
    public void testGetProviderAttributes() {
        GzipCompressionProvider provider = (GzipCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        Assert.assertEquals((Object)"GZIP compression", (Object)provider.getDescription());
        Assert.assertTrue((boolean)provider.supportsInput());
        Assert.assertTrue((boolean)provider.supportsOutput());
        Assert.assertEquals((Object)"gz", (Object)provider.getDefaultExtension());
    }

    @Test
    public void testCreateInputStream() throws IOException {
        GzipCompressionProvider provider = (GzipCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        byte[] testBytes = "Test".getBytes();
        gos.write(testBytes);
        ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
        GZIPInputStream gis = new GZIPInputStream(in);
        in = new ByteArrayInputStream(baos.toByteArray());
        GzipCompressionInputStream ncis = provider.createInputStream((InputStream)in);
        Assert.assertNotNull((Object)ncis);
        GzipCompressionInputStream ncis2 = provider.createInputStream((InputStream)gis);
        Assert.assertNotNull((Object)ncis2);
    }

    @Test
    public void testCreateOutputStream() throws IOException {
        GzipCompressionProvider provider = (GzipCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(out);
        GzipCompressionOutputStream outStream = new GzipCompressionOutputStream((OutputStream)out, (ICompressionProvider)provider);
        Assert.assertNotNull((Object)outStream);
        out = new ByteArrayOutputStream();
        GzipCompressionOutputStream ncis = provider.createOutputStream((OutputStream)out);
        Assert.assertNotNull((Object)ncis);
        GzipCompressionOutputStream ncis2 = provider.createOutputStream((OutputStream)gos);
        Assert.assertNotNull((Object)ncis2);
    }
}

