/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.hop.core.compress.CompressionPluginType;
import org.apache.hop.core.compress.CompressionProviderFactory;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.compress.zip.ZipCompressionInputStream;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ZipCompressionInputStreamTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();
    public static final String PROVIDER_NAME = "Zip";
    public CompressionProviderFactory factory = null;
    public ZipCompressionInputStream inStream = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((IPluginType)CompressionPluginType.getInstance());
        PluginRegistry.init();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
        ICompressionProvider provider = this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayInputStream in = new ByteArrayInputStream("Test".getBytes());
        this.inStream = new ZipCompressionInputStream(in, provider){};
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        Assert.assertNotNull((Object)this.inStream);
    }

    @Test
    public void getZIPCompressionProvider() {
        ICompressionProvider provider = this.inStream.getCompressionProvider();
        Assert.assertEquals((Object)provider.getName(), (Object)PROVIDER_NAME);
    }

    @Test
    public void testNextEntry() throws IOException {
        Assert.assertNotNull((Object)this.createZIPInputStream().getNextEntry());
    }

    @Test
    public void testClose() throws IOException {
        this.createZIPInputStream().close();
    }

    @Test
    public void testRead() throws IOException {
        ICompressionProvider provider = this.inStream.getCompressionProvider();
        ByteArrayInputStream in = new ByteArrayInputStream("Test".getBytes());
        this.inStream = new ZipCompressionInputStream(in, provider){};
        this.inStream.read(new byte[100], 0, this.inStream.available());
    }

    private ZipInputStream createZIPInputStream() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream gos = new ZipOutputStream(baos);
        gos.putNextEntry(new ZipEntry("./test.txt"));
        byte[] testBytes = "Test".getBytes();
        gos.write(testBytes);
        ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
        return new ZipInputStream(in);
    }
}

