/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.hop.core.Const;
import org.apache.hop.core.compress.CompressionPluginType;
import org.apache.hop.core.compress.CompressionProviderFactory;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.compress.zip.ZipCompressionOutputStream;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ZipCompressionOutputStreamTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();
    public static final String PROVIDER_NAME = "Zip";
    public CompressionProviderFactory factory = null;
    public ZipCompressionOutputStream outStream = null;
    private ByteArrayOutputStream internalStream;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((IPluginType)CompressionPluginType.getInstance());
        PluginRegistry.init();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
        ICompressionProvider provider = this.factory.getCompressionProviderByName(PROVIDER_NAME);
        this.internalStream = new ByteArrayOutputStream();
        this.outStream = new ZipCompressionOutputStream((OutputStream)this.internalStream, provider);
    }

    @After
    public void tearDown() throws Exception {
        this.internalStream = null;
    }

    @Test
    public void testCtor() {
        Assert.assertNotNull((Object)this.outStream);
    }

    @Test
    public void getCompressionProvider() {
        ICompressionProvider provider = this.outStream.getCompressionProvider();
        Assert.assertEquals((Object)provider.getName(), (Object)PROVIDER_NAME);
    }

    @Test
    public void testClose() throws IOException {
        ICompressionProvider provider = this.outStream.getCompressionProvider();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outStream = new ZipCompressionOutputStream((OutputStream)out, provider);
        this.outStream.close();
    }

    @Test
    public void testAddEntryAndWrite() throws IOException {
        ICompressionProvider provider = this.outStream.getCompressionProvider();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outStream = new ZipCompressionOutputStream((OutputStream)out, provider);
        this.outStream.addEntry("./test.zip", null);
        this.outStream.write("Test".getBytes());
    }

    @Test
    public void directoriesHierarchyIsIgnored() throws Exception {
        this.outStream.addEntry(ZipCompressionOutputStreamTest.createFilePath("1", "~", "hop", "dir"), "txt");
        this.outStream.close();
        Map<String, String> map = ZipCompressionOutputStreamTest.readArchive(this.internalStream.toByteArray());
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"1.txt", (Object)map.keySet().iterator().next());
    }

    @Test
    public void extraZipExtensionIsIgnored() throws Exception {
        this.outStream.addEntry(ZipCompressionOutputStreamTest.createFilePath("1.zip", "~", "hop", "dir"), "txt");
        this.outStream.close();
        Map<String, String> map = ZipCompressionOutputStreamTest.readArchive(this.internalStream.toByteArray());
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"1.txt", (Object)map.keySet().iterator().next());
    }

    @Test
    public void absentExtensionIsOk() throws Exception {
        this.outStream.addEntry(ZipCompressionOutputStreamTest.createFilePath("1", "~", "hop", "dir"), null);
        this.outStream.close();
        Map<String, String> map = ZipCompressionOutputStreamTest.readArchive(this.internalStream.toByteArray());
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"1", (Object)map.keySet().iterator().next());
    }

    @Test
    public void createsWellFormedArchive() throws Exception {
        this.outStream.addEntry("1", "txt");
        this.outStream.write("1.txt".getBytes());
        this.outStream.addEntry("2", "txt");
        this.outStream.write("2.txt".getBytes());
        this.outStream.close();
        Map<String, String> map = ZipCompressionOutputStreamTest.readArchive(this.internalStream.toByteArray());
        Assert.assertEquals((Object)"1.txt", (Object)map.remove("1.txt"));
        Assert.assertEquals((Object)"2.txt", (Object)map.remove("2.txt"));
        Assert.assertTrue((boolean)map.isEmpty());
    }

    private static String createFilePath(String file, String ... directories) {
        StringBuilder sb = new StringBuilder();
        for (String dir : directories) {
            sb.append(dir).append(Const.FILE_SEPARATOR);
        }
        return sb.append(file).toString();
    }

    private static Map<String, String> readArchive(byte[] bytes) throws Exception {
        ZipEntry entry;
        HashMap<String, String> result = new HashMap<String, String>();
        ZipInputStream stream = new ZipInputStream(new ByteArrayInputStream(bytes));
        byte[] buf = new byte[256];
        while ((entry = stream.getNextEntry()) != null) {
            int read;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((read = stream.read(buf)) > 0) {
                os.write(buf, 0, read);
            }
            result.put(entry.getName(), new String(os.toByteArray()));
        }
        return result;
    }
}

