/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.hop.core.compress.CompressionPluginType;
import org.apache.hop.core.compress.CompressionProviderFactory;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.compress.zip.ZipCompressionInputStream;
import org.apache.hop.core.compress.zip.ZipCompressionOutputStream;
import org.apache.hop.core.compress.zip.ZipCompressionProvider;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ZipCompressionProviderTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();
    public static final String PROVIDER_NAME = "Zip";
    public CompressionProviderFactory factory = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((IPluginType)CompressionPluginType.getInstance());
        PluginRegistry.init();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        ZipCompressionProvider ncp = new ZipCompressionProvider();
        Assert.assertNotNull((Object)ncp);
    }

    @Test
    public void testGetName() {
        ZipCompressionProvider provider = (ZipCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        Assert.assertNotNull((Object)provider);
        Assert.assertEquals((Object)PROVIDER_NAME, (Object)provider.getName());
    }

    @Test
    public void testGetProviderAttributes() {
        ZipCompressionProvider provider = (ZipCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        Assert.assertEquals((Object)"ZIP compression", (Object)provider.getDescription());
        Assert.assertTrue((boolean)provider.supportsInput());
        Assert.assertTrue((boolean)provider.supportsOutput());
        Assert.assertEquals((Object)"zip", (Object)provider.getDefaultExtension());
    }

    @Test
    public void testCreateInputStream() throws IOException {
        ZipCompressionProvider provider = (ZipCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayInputStream in = new ByteArrayInputStream("Test".getBytes());
        ZipInputStream zis = new ZipInputStream(in);
        ZipCompressionInputStream inStream = new ZipCompressionInputStream((InputStream)in, (ICompressionProvider)provider);
        Assert.assertNotNull((Object)inStream);
        ZipCompressionInputStream ncis = provider.createInputStream((InputStream)in);
        Assert.assertNotNull((Object)ncis);
        ZipCompressionInputStream ncis2 = provider.createInputStream((InputStream)zis);
        Assert.assertNotNull((Object)ncis2);
    }

    @Test
    public void testCreateOutputStream() throws IOException {
        ZipCompressionProvider provider = (ZipCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(out);
        ZipCompressionOutputStream outStream = new ZipCompressionOutputStream((OutputStream)out, (ICompressionProvider)provider);
        Assert.assertNotNull((Object)outStream);
        ZipCompressionOutputStream ncis = provider.createOutputStream((OutputStream)out);
        Assert.assertNotNull((Object)ncis);
        ZipCompressionOutputStream ncis2 = provider.createOutputStream((OutputStream)zos);
        Assert.assertNotNull((Object)ncis2);
    }
}

