/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui;

import org.apache.hop.core.gui.WorkflowTracker;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.apache.hop.workflow.ActionResult;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class WorkflowTrackerTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddJobTracker() throws Exception {
        String old = System.getProperty("HOP_MAX_WORKFLOW_TRACKER_SIZE");
        Integer maxTestSize = 30;
        try {
            System.setProperty("HOP_MAX_WORKFLOW_TRACKER_SIZE", maxTestSize.toString());
            WorkflowMeta workflowMeta = (WorkflowMeta)Mockito.mock(WorkflowMeta.class);
            WorkflowTracker workflowTracker = new WorkflowTracker(workflowMeta);
            for (int n = 0; n < maxTestSize * 2; ++n) {
                workflowTracker.addWorkflowTracker((WorkflowTracker)Mockito.mock(WorkflowTracker.class));
            }
            Assert.assertTrue((String)"More JobTrackers than allowed were added", (workflowTracker.getTotalNumberOfItems() <= maxTestSize ? 1 : 0) != 0);
        }
        finally {
            if (old == null) {
                System.clearProperty("HOP_MAX_WORKFLOW_TRACKER_SIZE");
            } else {
                System.setProperty("HOP_MAX_WORKFLOW_TRACKER_SIZE", old);
            }
        }
    }

    @Test
    public void findJobTracker_EntryNameIsNull() {
        WorkflowTracker workflowTracker = WorkflowTrackerTest.createTracker();
        workflowTracker.addWorkflowTracker(WorkflowTrackerTest.createTracker());
        ActionMeta actionMeta = WorkflowTrackerTest.createActionMeta(null);
        Assert.assertNull((Object)workflowTracker.findWorkflowTracker(actionMeta));
    }

    @Test
    public void findJobTracker_EntryNameNotFound() {
        WorkflowTracker workflowTracker = WorkflowTrackerTest.createTracker();
        for (int i = 0; i < 3; ++i) {
            workflowTracker.addWorkflowTracker(WorkflowTrackerTest.createTracker(Integer.toString(i)));
        }
        ActionMeta copy = WorkflowTrackerTest.createActionMeta("not match");
        Assert.assertNull((Object)workflowTracker.findWorkflowTracker(copy));
    }

    @Test
    public void findJobTracker_EntryNameFound() {
        WorkflowTracker[] children;
        WorkflowTracker workflowTracker = WorkflowTrackerTest.createTracker();
        for (WorkflowTracker child : children = new WorkflowTracker[]{WorkflowTrackerTest.createTracker("0"), WorkflowTrackerTest.createTracker("1"), WorkflowTrackerTest.createTracker("2")}) {
            workflowTracker.addWorkflowTracker(child);
        }
        ActionMeta actionMeta = WorkflowTrackerTest.createActionMeta("1");
        Assert.assertEquals((Object)children[1], (Object)workflowTracker.findWorkflowTracker(actionMeta));
    }

    private static WorkflowTracker createTracker() {
        return WorkflowTrackerTest.createTracker(null);
    }

    private static WorkflowTracker createTracker(String actionName) {
        WorkflowMeta workflowMeta = (WorkflowMeta)Mockito.mock(WorkflowMeta.class);
        WorkflowTracker workflowTracker = new WorkflowTracker(workflowMeta);
        if (actionName != null) {
            ActionResult result = (ActionResult)Mockito.mock(ActionResult.class);
            Mockito.when((Object)result.getActionName()).thenReturn((Object)actionName);
            workflowTracker.setActionResult(result);
        }
        return workflowTracker;
    }

    private static ActionMeta createActionMeta(String actionName) {
        IAction action = (IAction)Mockito.mock(IAction.class);
        Mockito.when((Object)action.getName()).thenReturn((Object)actionName);
        ActionMeta actionMeta = new ActionMeta(action);
        return actionMeta;
    }
}

