/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.injection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hop.core.HopClientEnvironment;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.injection.bean.BeanInjectionInfo;
import org.apache.hop.core.injection.bean.BeanInjector;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.memory.MemoryMetadataProvider;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;

@Ignore
public abstract class BaseMetadataInjectionTest<Meta extends ITransformMeta> {
    protected BeanInjectionInfo<Meta> info;
    protected BeanInjector<Meta> injector;
    protected Meta meta;
    protected Set<String> nonTestedProperties;
    protected IHopMetadataProvider metadataProvider;

    protected void setup(Meta meta) throws Exception {
        HopClientEnvironment.init();
        this.meta = meta;
        this.metadataProvider = new MemoryMetadataProvider();
        this.info = new BeanInjectionInfo(meta.getClass());
        this.injector = new BeanInjector(this.info, this.metadataProvider);
        this.nonTestedProperties = new HashSet(this.info.getProperties().keySet());
        for (BeanInjectionInfo.Group group : this.info.getGroups()) {
            List properties = group.getProperties();
            for (BeanInjectionInfo.Property property : properties) {
                this.nonTestedProperties.add(property.getKey());
            }
        }
    }

    @After
    public void after() {
        Assert.assertTrue((String)("Some properties where not tested: " + this.nonTestedProperties), (boolean)this.nonTestedProperties.isEmpty());
    }

    protected List<RowMetaAndData> setValue(IValueMeta valueMeta, Object ... values) {
        RowMeta rowsMeta = new RowMeta();
        rowsMeta.addValueMeta(valueMeta);
        ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
        if (values != null) {
            for (Object v : values) {
                rows.add(new RowMetaAndData((IRowMeta)rowsMeta, new Object[]{v}));
            }
        }
        return rows;
    }

    protected void skipPropertyTest(String propertyName) {
        this.nonTestedProperties.remove(propertyName);
    }

    protected void check(String propertyName, IBooleanGetter getter) throws HopException {
        ValueMetaString valueMetaString = new ValueMetaString("f");
        this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMetaString, "Y"), "f");
        Assert.assertEquals((Object)true, (Object)getter.get());
        this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMetaString, "N"), "f");
        Assert.assertEquals((Object)false, (Object)getter.get());
        ValueMetaBoolean valueMetaBoolean = new ValueMetaBoolean("f");
        this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMetaBoolean, true), "f");
        Assert.assertEquals((Object)true, (Object)getter.get());
        this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMetaBoolean, false), "f");
        Assert.assertEquals((Object)false, (Object)getter.get());
        this.skipPropertyTest(propertyName);
    }

    protected void check(String propertyName, IStringGetter getter, String ... values) throws HopException {
        ValueMetaString valueMeta = new ValueMetaString("f");
        if (values.length == 0) {
            values = new String[]{"v", "v2", null};
        }
        String correctValue = null;
        for (String v : values) {
            this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMeta, v), "f");
            if (v != null) {
                correctValue = v;
            }
            Assert.assertEquals((Object)correctValue, (Object)getter.get());
        }
        this.skipPropertyTest(propertyName);
    }

    protected void check(String propertyName, IEnumGetter getter, Class<?> enumType) throws HopException {
        ?[] values;
        ValueMetaString valueMeta = new ValueMetaString("f");
        for (Object v : values = enumType.getEnumConstants()) {
            this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMeta, v), "f");
            Assert.assertEquals(v, getter.get());
        }
        try {
            this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMeta, "###"), "f");
            Assert.fail((String)"Should be passed to enum");
        }
        catch (HopException hopException) {
            // empty catch block
        }
        this.skipPropertyTest(propertyName);
    }

    protected void check(String propertyName, IIntGetter getter) throws HopException {
        ValueMetaString valueMetaString = new ValueMetaString("f");
        this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMetaString, "1"), "f");
        Assert.assertEquals((long)1L, (long)getter.get());
        this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMetaString, "45"), "f");
        Assert.assertEquals((long)45L, (long)getter.get());
        ValueMetaInteger valueMetaInteger = new ValueMetaInteger("f");
        this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMetaInteger, 1234L), "f");
        Assert.assertEquals((long)1234L, (long)getter.get());
        this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMetaInteger, Integer.MAX_VALUE), "f");
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)getter.get());
        this.skipPropertyTest(propertyName);
    }

    protected void checkStringToInt(String propertyName, IIntGetter getter, String[] codes, int[] ids) throws HopException {
        if (codes.length != ids.length) {
            throw new RuntimeException("Wrong codes/ids sizes");
        }
        ValueMetaString valueMetaString = new ValueMetaString("f");
        for (int i = 0; i < codes.length; ++i) {
            this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMetaString, codes[i]), "f");
            Assert.assertEquals((long)ids[i], (long)getter.get());
        }
        this.skipPropertyTest(propertyName);
    }

    protected void check(String propertyName, ILongGetter getter) throws HopException {
        ValueMetaString valueMetaString = new ValueMetaString("f");
        this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMetaString, "1"), "f");
        Assert.assertEquals((long)1L, (long)getter.get());
        this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMetaString, "45"), "f");
        Assert.assertEquals((long)45L, (long)getter.get());
        ValueMetaInteger valueMetaInteger = new ValueMetaInteger("f");
        this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMetaInteger, 1234L), "f");
        Assert.assertEquals((long)1234L, (long)getter.get());
        this.injector.setProperty(this.meta, propertyName, this.setValue((IValueMeta)valueMetaInteger, Long.MAX_VALUE), "f");
        Assert.assertEquals((long)Long.MAX_VALUE, (long)getter.get());
        this.skipPropertyTest(propertyName);
    }

    public static int[] getTypeCodes(String[] typeNames) {
        int[] typeCodes = new int[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            typeCodes[i] = ValueMetaBase.getType((String)typeNames[i]);
        }
        return typeCodes;
    }

    public static interface ILongGetter {
        public long get();
    }

    public static interface IIntGetter {
        public int get();
    }

    public static interface IEnumGetter {
        public Enum<?> get();
    }

    public static interface IStringGetter {
        public String get();
    }

    public static interface IBooleanGetter {
        public boolean get();
    }
}

