/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.injection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.injection.MetaBeanLevel1;
import org.apache.hop.core.injection.MetaBeanLevel3;
import org.apache.hop.core.injection.MetaBeanWrong1;
import org.apache.hop.core.injection.MetaBeanWrong2;
import org.apache.hop.core.injection.MetaBeanWrong3;
import org.apache.hop.core.injection.MetaBeanWrong4;
import org.apache.hop.core.injection.MetaBeanWrong5;
import org.apache.hop.core.injection.MetaBeanWrong6;
import org.apache.hop.core.injection.MetaBeanWrong7;
import org.apache.hop.core.injection.bean.BeanInjectionInfo;
import org.apache.hop.core.injection.bean.BeanInjector;
import org.apache.hop.core.injection.inheritance.MetaBeanChild;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.memory.MemoryMetadataProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class MetaAnnotationInjectionTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();
    private static final String FIELD_ONE = "FIELD_ONE";
    private static final String COMPLEX_NAME = "COMPLEX_NAME";
    private static final String TEST_NAME = "TEST_NAME";
    private IHopMetadataProvider metadataProvider;

    @Before
    public void before() {
        HopLogStore.init();
        this.metadataProvider = new MemoryMetadataProvider();
    }

    @Test
    public void testInjectionDescription() throws Exception {
        BeanInjectionInfo ri = new BeanInjectionInfo(MetaBeanLevel1.class);
        Assert.assertEquals((long)3L, (long)ri.getGroups().size());
        Assert.assertEquals((Object)"", (Object)((BeanInjectionInfo.Group)ri.getGroups().get(0)).getKey());
        Assert.assertEquals((Object)"FILENAME_LINES", (Object)((BeanInjectionInfo.Group)ri.getGroups().get(1)).getKey());
        Assert.assertEquals((Object)"FILENAME_LINES2", (Object)((BeanInjectionInfo.Group)ri.getGroups().get(2)).getKey());
        Assert.assertTrue((boolean)ri.getProperties().containsKey("SEPARATOR"));
        Assert.assertTrue((boolean)ri.getProperties().containsKey("FILENAME"));
        Assert.assertTrue((boolean)ri.getProperties().containsKey("BASE"));
        Assert.assertTrue((boolean)ri.getProperties().containsKey("FIRST"));
        Assert.assertEquals((Object)"FILENAME_LINES", (Object)((BeanInjectionInfo.Property)ri.getProperties().get("FILENAME")).getGroupKey());
        Assert.assertEquals((Object)"!DESCRIPTION!", (Object)ri.getDescription("DESCRIPTION"));
    }

    @Test
    public void testInjectionSets() throws Exception {
        MetaBeanLevel1 obj = new MetaBeanLevel1();
        RowMeta meta = new RowMeta();
        meta.addValueMeta((IValueMeta)new ValueMetaString("f1"));
        meta.addValueMeta((IValueMeta)new ValueMetaString("f2"));
        meta.addValueMeta((IValueMeta)new ValueMetaString("fstrint"));
        meta.addValueMeta((IValueMeta)new ValueMetaString("fstrlong"));
        meta.addValueMeta((IValueMeta)new ValueMetaString("fstrboolean"));
        ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
        rows.add(new RowMetaAndData((IRowMeta)meta, new Object[]{"<sep>", "/tmp/file.txt", "123", "1234567891213", "y"}));
        rows.add(new RowMetaAndData((IRowMeta)meta, new Object[]{"<sep>", "/tmp/file2.txt", "123", "1234567891213", "y"}));
        BeanInjector inj = MetaAnnotationInjectionTest.buildBeanInjectorFor(MetaBeanLevel1.class, this.metadataProvider);
        inj.setProperty((Object)obj, "SEPARATOR", rows, "f1");
        inj.setProperty((Object)obj, "FILENAME", rows, "f2");
        inj.setProperty((Object)obj, "FILENAME_ARRAY", rows, "f2");
        inj.setProperty((Object)obj, "FBOOLEAN", rows, "fstrboolean");
        inj.setProperty((Object)obj, "FINT", rows, "fstrint");
        inj.setProperty((Object)obj, "FLONG", rows, "fstrlong");
        inj.setProperty((Object)obj, "FIRST", rows, "fstrint");
        Assert.assertEquals((Object)"<sep>", (Object)obj.getSub().getSeparator());
        Assert.assertEquals((Object)"/tmp/file.txt", (Object)obj.getSub().getFiles()[0].getName());
        Assert.assertTrue((boolean)obj.fboolean);
        Assert.assertEquals((long)123L, (long)obj.fint);
        Assert.assertEquals((long)1234567891213L, (long)obj.flong);
        Assert.assertEquals((Object)"123", (Object)obj.getSub().first());
        Assert.assertArrayEquals((Object[])new String[]{"/tmp/file.txt", "/tmp/file2.txt"}, (Object[])obj.getSub().getFilenames());
    }

    @Test
    public void testInjectionConstant() throws Exception {
        MetaBeanLevel1 obj = new MetaBeanLevel1();
        BeanInjector inj = MetaAnnotationInjectionTest.buildBeanInjectorFor(MetaBeanLevel1.class, this.metadataProvider);
        inj.setProperty((Object)obj, "SEPARATOR", null, "<sep>");
        inj.setProperty((Object)obj, "FINT", null, "123");
        inj.setProperty((Object)obj, "FLONG", null, "1234567891213");
        inj.setProperty((Object)obj, "FBOOLEAN", null, "true");
        inj.setProperty((Object)obj, "FILENAME", null, "f1");
        inj.setProperty((Object)obj, "FILENAME_ARRAY", null, "f2");
        Assert.assertEquals((Object)"<sep>", (Object)obj.getSub().getSeparator());
        Assert.assertTrue((boolean)obj.fboolean);
        Assert.assertEquals((long)123L, (long)obj.fint);
        Assert.assertEquals((long)1234567891213L, (long)obj.flong);
        Assert.assertNull((Object)obj.getSub().getFiles());
        Assert.assertEquals((Object)"f2", (Object)obj.getSub().getFilenames()[0]);
        obj.getSub().files = new MetaBeanLevel3[]{new MetaBeanLevel3(), new MetaBeanLevel3()};
        obj.getSub().filenames = new String[]{"", "", ""};
        inj.setProperty((Object)obj, "FILENAME", null, "f1");
        inj.setProperty((Object)obj, "FILENAME_ARRAY", null, "f2");
        Assert.assertEquals((long)2L, (long)obj.getSub().getFiles().length);
        Assert.assertEquals((Object)"f1", (Object)obj.getSub().getFiles()[0].getName());
        Assert.assertEquals((Object)"f1", (Object)obj.getSub().getFiles()[1].getName());
        Assert.assertArrayEquals((Object[])new String[]{null, null, null, "f2"}, (Object[])obj.getSub().getFilenames());
    }

    @Test
    public void testInjectionForArrayPropertyWithoutDefaultConstructor_class_parameter() throws HopException {
        BeanInjector beanInjector = MetaAnnotationInjectionTest.buildBeanInjectorFor(MetadataBean.class, this.metadataProvider);
        MetadataBean targetBean = new MetadataBean();
        beanInjector.setProperty((Object)targetBean, COMPLEX_NAME, MetaAnnotationInjectionTest.createRowMetaAndData(), FIELD_ONE);
        Assert.assertNotNull((Object)targetBean.getComplexField());
        Assert.assertTrue((targetBean.getComplexField().length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TEST_NAME, (Object)targetBean.getComplexField()[0].getFieldName());
    }

    @Test
    public void testInjectionForArrayPropertyWithoutDefaultConstructorInterface_parameter() throws HopException {
        BeanInjector beanInjector = MetaAnnotationInjectionTest.buildBeanInjectorFor(MetadataBeanImplementsInterface.class, this.metadataProvider);
        MetadataBeanImplementsInterface targetBean = new MetadataBeanImplementsInterface();
        beanInjector.setProperty((Object)targetBean, COMPLEX_NAME, MetaAnnotationInjectionTest.createRowMetaAndData(), FIELD_ONE);
        Assert.assertNotNull((Object)targetBean.getComplexField());
        Assert.assertTrue((targetBean.getComplexField().length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TEST_NAME, (Object)targetBean.getComplexField()[0].getFieldName());
    }

    @Test
    public void testWrongDeclarations() throws Exception {
        try {
            new BeanInjectionInfo(MetaBeanWrong1.class);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new BeanInjectionInfo(MetaBeanWrong2.class);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new BeanInjectionInfo(MetaBeanWrong3.class);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new BeanInjectionInfo(MetaBeanWrong4.class);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new BeanInjectionInfo(MetaBeanWrong5.class);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new BeanInjectionInfo(MetaBeanWrong6.class);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new BeanInjectionInfo(MetaBeanWrong7.class);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGenerics() throws Exception {
        BeanInjectionInfo ri = new BeanInjectionInfo(MetaBeanChild.class);
        Assert.assertTrue((ri.getProperties().size() == 7 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ri.getProperties().containsKey("BASE_ITEM_NAME"));
        Assert.assertTrue((boolean)ri.getProperties().containsKey("ITEM_CHILD_NAME"));
        Assert.assertTrue((boolean)ri.getProperties().containsKey("A"));
        Assert.assertTrue((boolean)ri.getProperties().containsKey("ITEM.BASE_ITEM_NAME"));
        Assert.assertTrue((boolean)ri.getProperties().containsKey("ITEM.ITEM_CHILD_NAME"));
        Assert.assertTrue((boolean)ri.getProperties().containsKey("SUB.BASE_ITEM_NAME"));
        Assert.assertTrue((boolean)ri.getProperties().containsKey("SUB.ITEM_CHILD_NAME"));
        Assert.assertEquals(String.class, (Object)((BeanInjectionInfo.Property)ri.getProperties().get("A")).getPropertyClass());
    }

    private static BeanInjector buildBeanInjectorFor(Class<?> clazz, IHopMetadataProvider metadataProvider) {
        BeanInjectionInfo metaBeanInfo = new BeanInjectionInfo(clazz);
        return new BeanInjector(metaBeanInfo, metadataProvider);
    }

    private static List<RowMetaAndData> createRowMetaAndData() {
        RowMeta meta = new RowMeta();
        meta.addValueMeta((IValueMeta)new ValueMetaString(FIELD_ONE));
        return Collections.singletonList(new RowMetaAndData((IRowMeta)meta, new Object[]{TEST_NAME}));
    }

    public static class ComplexFieldWithInterfaceArg {
        @Injection(name="COMPLEX_NAME", group="COMPLEX")
        private String fieldName;
        private final MetadataInterface parentMeta;

        public ComplexFieldWithInterfaceArg(MetadataInterface parentMeta) {
            this.parentMeta = parentMeta;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public MetadataInterface getParentMeta() {
            return this.parentMeta;
        }
    }

    @InjectionSupported(localizationPrefix="", groups={"COMPLEX"})
    public static class MetadataBeanImplementsInterface
    implements MetadataInterface {
        @InjectionDeep
        private ComplexFieldWithInterfaceArg[] complexField;

        public ComplexFieldWithInterfaceArg[] getComplexField() {
            return this.complexField;
        }

        public void setComplexField(ComplexFieldWithInterfaceArg[] complexField) {
            this.complexField = complexField;
        }
    }

    public static class ComplexField {
        @Injection(name="COMPLEX_NAME", group="COMPLEX")
        private String fieldName;
        private final MetadataBean parentMeta;

        public ComplexField(MetadataBean parentMeta) {
            this.parentMeta = parentMeta;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public MetadataBean getParentMeta() {
            return this.parentMeta;
        }
    }

    @InjectionSupported(localizationPrefix="", groups={"COMPLEX"})
    public static class MetadataBean {
        @InjectionDeep
        private ComplexField[] complexField;

        public ComplexField[] getComplexField() {
            return this.complexField;
        }

        public void setComplexField(ComplexField[] complexField) {
            this.complexField = complexField;
        }
    }

    private static interface MetadataInterface {
    }
}

