/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.injection;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.injection.bean.BeanInjectionInfo;
import org.apache.hop.core.injection.bean.BeanInjector;
import org.apache.hop.core.injection.bean.BeanLevelInfo;
import org.apache.hop.core.injection.metadata.PropBeanChild;
import org.apache.hop.core.injection.metadata.PropBeanGrandChild;
import org.apache.hop.core.injection.metadata.PropBeanListChild;
import org.apache.hop.core.injection.metadata.PropBeanParent;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMetaBuilder;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.memory.MemoryMetadataProvider;
import org.junit.Assert;
import org.junit.Test;

public class MetaPropInjectionTest {
    @Test
    public void testHopMetadataPropertyInjectionInfo() throws Exception {
        BeanInjectionInfo info = new BeanInjectionInfo(PropBeanParent.class);
        Assert.assertEquals((long)4L, (long)info.getGroups().size());
        Assert.assertEquals((long)11L, (long)info.getProperties().size());
        BeanInjectionInfo.Property prop = (BeanInjectionInfo.Property)info.getProperties().get("str");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((long)2L, (long)prop.getPath().size());
        BeanLevelInfo beanLevelInfo = (BeanLevelInfo)prop.getPath().get(1);
        Assert.assertEquals(String.class, (Object)beanLevelInfo.leafClass);
        Assert.assertEquals((Object)"stringField", (Object)beanLevelInfo.field.getName());
        prop = (BeanInjectionInfo.Property)info.getProperties().get("int");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((long)2L, (long)prop.getPath().size());
        beanLevelInfo = (BeanLevelInfo)prop.getPath().get(1);
        Assert.assertEquals(Integer.TYPE, (Object)beanLevelInfo.leafClass);
        Assert.assertEquals((Object)"intField", (Object)beanLevelInfo.field.getName());
        prop = (BeanInjectionInfo.Property)info.getProperties().get("long");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((long)2L, (long)prop.getPath().size());
        beanLevelInfo = (BeanLevelInfo)prop.getPath().get(1);
        Assert.assertEquals(Long.TYPE, (Object)beanLevelInfo.leafClass);
        Assert.assertEquals((Object)"longField", (Object)beanLevelInfo.field.getName());
        prop = (BeanInjectionInfo.Property)info.getProperties().get("boolean");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((long)2L, (long)prop.getPath().size());
        beanLevelInfo = (BeanLevelInfo)prop.getPath().get(1);
        Assert.assertEquals(Boolean.TYPE, (Object)beanLevelInfo.leafClass);
        Assert.assertEquals((Object)"booleanField", (Object)beanLevelInfo.field.getName());
        prop = (BeanInjectionInfo.Property)info.getProperties().get("child1");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((long)3L, (long)prop.getPath().size());
        beanLevelInfo = (BeanLevelInfo)prop.getPath().get(1);
        Assert.assertEquals(PropBeanChild.class, (Object)beanLevelInfo.leafClass);
        Assert.assertEquals((Object)"child", (Object)beanLevelInfo.field.getName());
        beanLevelInfo = (BeanLevelInfo)prop.getPath().get(2);
        Assert.assertEquals(String.class, (Object)beanLevelInfo.leafClass);
        Assert.assertEquals((Object)"childField1", (Object)beanLevelInfo.field.getName());
        prop = (BeanInjectionInfo.Property)info.getProperties().get("child2");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((long)3L, (long)prop.getPath().size());
        beanLevelInfo = (BeanLevelInfo)prop.getPath().get(1);
        Assert.assertEquals(PropBeanChild.class, (Object)beanLevelInfo.leafClass);
        Assert.assertEquals((Object)"child", (Object)beanLevelInfo.field.getName());
        beanLevelInfo = (BeanLevelInfo)prop.getPath().get(2);
        Assert.assertEquals(String.class, (Object)beanLevelInfo.leafClass);
        Assert.assertEquals((Object)"childField2", (Object)beanLevelInfo.field.getName());
        prop = (BeanInjectionInfo.Property)info.getProperties().get("f1");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((long)3L, (long)prop.getPath().size());
        beanLevelInfo = (BeanLevelInfo)prop.getPath().get(1);
        Assert.assertEquals(PropBeanListChild.class, (Object)beanLevelInfo.leafClass);
        Assert.assertEquals((Object)"children", (Object)beanLevelInfo.field.getName());
        beanLevelInfo = (BeanLevelInfo)prop.getPath().get(2);
        Assert.assertEquals(String.class, (Object)beanLevelInfo.leafClass);
        Assert.assertEquals((Object)"f1", (Object)beanLevelInfo.field.getName());
        prop = (BeanInjectionInfo.Property)info.getProperties().get("f2");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((long)3L, (long)prop.getPath().size());
        beanLevelInfo = (BeanLevelInfo)prop.getPath().get(1);
        Assert.assertEquals(PropBeanListChild.class, (Object)beanLevelInfo.leafClass);
        Assert.assertEquals((Object)"children", (Object)beanLevelInfo.field.getName());
        beanLevelInfo = (BeanLevelInfo)prop.getPath().get(2);
        Assert.assertEquals(String.class, (Object)beanLevelInfo.leafClass);
        Assert.assertEquals((Object)"f2", (Object)beanLevelInfo.field.getName());
        prop = (BeanInjectionInfo.Property)info.getProperties().get("string");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((long)3L, (long)prop.getPath().size());
        beanLevelInfo = (BeanLevelInfo)prop.getPath().get(1);
        Assert.assertEquals(List.class, (Object)beanLevelInfo.leafClass);
        Assert.assertEquals((Object)"strings", (Object)beanLevelInfo.field.getName());
        beanLevelInfo = (BeanLevelInfo)prop.getPath().get(2);
        Assert.assertEquals(String.class, (Object)beanLevelInfo.leafClass);
        Assert.assertNull((Object)beanLevelInfo.field);
        Assert.assertNull((Object)beanLevelInfo.getter);
        Assert.assertNull((Object)beanLevelInfo.setter);
        prop = (BeanInjectionInfo.Property)info.getProperties().get("grand_child_name");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((long)4L, (long)prop.getPath().size());
        Assert.assertEquals(PropBeanParent.class, (Object)((BeanLevelInfo)prop.getPath().get((int)0)).leafClass);
        Assert.assertEquals(PropBeanChild.class, (Object)((BeanLevelInfo)prop.getPath().get((int)1)).leafClass);
        Assert.assertEquals(PropBeanGrandChild.class, (Object)((BeanLevelInfo)prop.getPath().get((int)2)).leafClass);
        Assert.assertEquals(String.class, (Object)((BeanLevelInfo)prop.getPath().get((int)3)).leafClass);
        prop = (BeanInjectionInfo.Property)info.getProperties().get("grand_child_description");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((long)4L, (long)prop.getPath().size());
        Assert.assertEquals(PropBeanParent.class, (Object)((BeanLevelInfo)prop.getPath().get((int)0)).leafClass);
        Assert.assertEquals(PropBeanChild.class, (Object)((BeanLevelInfo)prop.getPath().get((int)1)).leafClass);
        Assert.assertEquals(PropBeanGrandChild.class, (Object)((BeanLevelInfo)prop.getPath().get((int)2)).leafClass);
        Assert.assertEquals(String.class, (Object)((BeanLevelInfo)prop.getPath().get((int)3)).leafClass);
    }

    @Test
    public void testHopMetadataPropertyInjection() throws Exception {
        PropBeanParent parent = new PropBeanParent();
        BeanInjectionInfo info = new BeanInjectionInfo(PropBeanParent.class);
        RowMetaAndData parentMetadata = new RowMetaAndData();
        parentMetadata.addValue((IValueMeta)new ValueMetaString("stringValue"), (Object)"someString");
        parentMetadata.addValue((IValueMeta)new ValueMetaString("intValue"), (Object)"123");
        parentMetadata.addValue((IValueMeta)new ValueMetaString("longValue"), (Object)"987654321");
        parentMetadata.addValue((IValueMeta)new ValueMetaString("booleanValue"), (Object)"true");
        parentMetadata.addValue((IValueMeta)new ValueMetaString("childValue1"), (Object)"cv1");
        parentMetadata.addValue((IValueMeta)new ValueMetaString("childValue2"), (Object)"cv2");
        parentMetadata.addValue((IValueMeta)new ValueMetaString("grandChildName"), (Object)"someName");
        parentMetadata.addValue((IValueMeta)new ValueMetaString("grandChildDescription"), (Object)"someDescription");
        BeanInjector injector = new BeanInjector(info, (IHopMetadataProvider)new MemoryMetadataProvider());
        injector.setProperty((Object)parent, "str", Arrays.asList(parentMetadata), "stringValue");
        injector.setProperty((Object)parent, "int", Arrays.asList(parentMetadata), "intValue");
        injector.setProperty((Object)parent, "long", Arrays.asList(parentMetadata), "longValue");
        injector.setProperty((Object)parent, "boolean", Arrays.asList(parentMetadata), "booleanValue");
        injector.setProperty((Object)parent, "child1", Arrays.asList(parentMetadata), "childValue1");
        injector.setProperty((Object)parent, "child2", Arrays.asList(parentMetadata), "childValue2");
        injector.setProperty((Object)parent, "grand_child_name", Arrays.asList(parentMetadata), "grandChildName");
        injector.setProperty((Object)parent, "grand_child_description", Arrays.asList(parentMetadata), "grandChildDescription");
        Assert.assertEquals((Object)parent.getStringField(), (Object)"someString");
        Assert.assertEquals((long)parent.getIntField(), (long)123L);
        Assert.assertEquals((long)parent.getLongField(), (long)987654321L);
        Assert.assertTrue((boolean)parent.isBooleanField());
        Assert.assertEquals((Object)parent.getChild().getChildField1(), (Object)"cv1");
        Assert.assertEquals((Object)parent.getChild().getChildField2(), (Object)"cv2");
        Assert.assertEquals((Object)"someName", (Object)parent.getChild().getGrandChild().getGrandChildName());
        Assert.assertEquals((Object)"someDescription", (Object)parent.getChild().getGrandChild().getGrandChildDescription());
        IRowMeta stringRowMeta = new RowMetaBuilder().addString("stringField").build();
        List<RowMetaAndData> stringsRows = Arrays.asList(new RowMetaAndData(stringRowMeta, new Object[]{"string1"}), new RowMetaAndData(stringRowMeta, new Object[]{"string2"}), new RowMetaAndData(stringRowMeta, new Object[]{"string3"}));
        injector.setProperty((Object)parent, "string", stringsRows, "stringField");
        Assert.assertEquals((long)3L, (long)parent.getStrings().size());
        Assert.assertEquals((Object)"string1", (Object)parent.getStrings().get(0));
        Assert.assertEquals((Object)"string2", (Object)parent.getStrings().get(1));
        Assert.assertEquals((Object)"string3", (Object)parent.getStrings().get(2));
        IRowMeta entriesRowMeta = new RowMetaBuilder().addString("fieldF1").addString("fieldF2").build();
        List<RowMetaAndData> entriesRows = Arrays.asList(new RowMetaAndData(entriesRowMeta, new Object[]{"f1_1", "f2_1"}), new RowMetaAndData(entriesRowMeta, new Object[]{"f1_2", "f2_2"}), new RowMetaAndData(entriesRowMeta, new Object[]{"f1_3", "f2_3"}));
        injector.setProperty((Object)parent, "f1", entriesRows, "fieldF1");
        injector.setProperty((Object)parent, "f2", entriesRows, "fieldF2");
        Assert.assertEquals((long)3L, (long)parent.getChildren().size());
        Assert.assertEquals((Object)new PropBeanListChild("f1_1", "f2_1"), (Object)parent.getChildren().get(0));
        Assert.assertEquals((Object)new PropBeanListChild("f1_2", "f2_2"), (Object)parent.getChildren().get(1));
        Assert.assertEquals((Object)new PropBeanListChild("f1_3", "f2_3"), (Object)parent.getChildren().get(2));
    }
}

