/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import java.io.OutputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.logging.HopLoggingEvent;
import org.apache.hop.core.logging.LogChannelFileWriter;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingRegistry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class LogChannelFileWriterTest {
    String id = "1";
    String logMessage = "Log message";
    @Mock
    FileObject fileObject;
    @Mock
    FileContent fileContent;
    @Mock
    OutputStream outputStream;
    @Captor
    ArgumentCaptor<byte[]> captor;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.fileObject.getContent()).thenReturn((Object)this.fileContent);
        Mockito.when((Object)this.fileContent.getOutputStream(Matchers.anyBoolean())).thenReturn((Object)this.outputStream);
    }

    @Test
    public void test() throws Exception {
        LogChannelFileWriter writer = new LogChannelFileWriter(this.id, this.fileObject, false);
        LoggingRegistry.getInstance().getLogChannelFileWriterBuffer(this.id).addEvent(new HopLoggingEvent((Object)this.logMessage, System.currentTimeMillis(), LogLevel.BASIC));
        writer.flush();
        ((OutputStream)Mockito.verify((Object)this.outputStream)).write((byte[])this.captor.capture());
        String arguments = new String((byte[])this.captor.getValue());
        Assert.assertTrue((boolean)arguments.contains(this.logMessage));
    }

    @Test
    public void testStartStopLogging() throws Exception {
        LogChannelFileWriter writer = new LogChannelFileWriter(this.id, this.fileObject, false);
        ((OutputStream)Mockito.doAnswer(invocationOnMock -> {
            Thread.sleep(2000L);
            return null;
        }).when((Object)this.outputStream)).close();
        writer.startLogging();
        Thread.sleep(500L);
        ((OutputStream)Mockito.verify((Object)this.outputStream, (VerificationMode)Mockito.atLeastOnce())).write((byte[])Matchers.any(byte[].class));
        ((OutputStream)Mockito.verify((Object)this.outputStream, (VerificationMode)Mockito.atLeastOnce())).flush();
        ((OutputStream)Mockito.verify((Object)this.outputStream, (VerificationMode)Mockito.never())).close();
        writer.stopLogging();
        ((OutputStream)Mockito.verify((Object)this.outputStream)).close();
    }
}

