/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LogMessage;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class LogMessageTest {
    private LogMessage logMessage;
    private static final String LOG_MESSAGE = "Test Message";
    private static final LogLevel LOG_LEVEL = LogLevel.BASIC;
    private static String treeLogChannelId;
    private static String simpleLogChannelId;
    @ClassRule
    public static RestoreHopEngineEnvironment env;

    @Before
    public void setUp() {
        treeLogChannelId = LoggingRegistry.getInstance().registerLoggingSource((Object)LogMessageTest.getTreeLoggingObject());
    }

    @After
    public void tearDown() {
        LoggingRegistry.getInstance().removeIncludingChildren(treeLogChannelId);
        System.clearProperty("HOP_LOG_MARK_MAPPINGS");
    }

    @Test
    public void testWhenLogMarkMappingTurnOn_DetailedSubjectUsed() throws Exception {
        this.turnOnLogMarkMapping();
        this.logMessage = new LogMessage(LOG_MESSAGE, treeLogChannelId, LOG_LEVEL);
        Assert.assertTrue((boolean)LOG_MESSAGE.equals(this.logMessage.getMessage()));
        Assert.assertTrue((boolean)LOG_LEVEL.equals((Object)this.logMessage.getLevel()));
        Assert.assertTrue((boolean)treeLogChannelId.equals(this.logMessage.getLogChannelId()));
        Assert.assertTrue((boolean)"[PIPELINE_SUBJECT].[TRANSFORM_SUBJECT].PIPELINE_CHILD_SUBJECT".equals(this.logMessage.getSubject()));
    }

    @Test
    public void testWhenLogMarkMappingTurnOff_SimpleSubjectUsed() throws Exception {
        this.turnOffLogMarkMapping();
        this.logMessage = new LogMessage(LOG_MESSAGE, treeLogChannelId, LOG_LEVEL);
        Assert.assertTrue((boolean)LOG_MESSAGE.equals(this.logMessage.getMessage()));
        Assert.assertTrue((boolean)LOG_LEVEL.equals((Object)this.logMessage.getLevel()));
        Assert.assertTrue((boolean)treeLogChannelId.equals(this.logMessage.getLogChannelId()));
        Assert.assertTrue((boolean)"PIPELINE_CHILD_SUBJECT".equals(this.logMessage.getSubject()));
    }

    @Test
    public void testWhenLogMarkMappingTurnOnAndNoSubMappingUsed_DetailedSubjectContainsOnlySimpleSubject() throws Exception {
        this.turnOnLogMarkMapping();
        simpleLogChannelId = LoggingRegistry.getInstance().registerLoggingSource((Object)LogMessageTest.getLoggingObjectWithOneParent());
        this.logMessage = new LogMessage(LOG_MESSAGE, simpleLogChannelId, LOG_LEVEL);
        Assert.assertTrue((boolean)LOG_MESSAGE.equals(this.logMessage.getMessage()));
        Assert.assertTrue((boolean)LOG_LEVEL.equals((Object)this.logMessage.getLevel()));
        Assert.assertTrue((boolean)simpleLogChannelId.equals(this.logMessage.getLogChannelId()));
        Assert.assertTrue((boolean)"PIPELINE_SUBJECT".equals(this.logMessage.getSubject()));
        LoggingRegistry.getInstance().removeIncludingChildren(simpleLogChannelId);
    }

    @Test
    public void testToString() throws Exception {
        this.turnOnLogMarkMapping();
        simpleLogChannelId = LoggingRegistry.getInstance().registerLoggingSource((Object)LogMessageTest.getLoggingObjectWithOneParent());
        LogMessage msg = new LogMessage("Log message", simpleLogChannelId, LogLevel.DEBUG);
        Assert.assertEquals((Object)"PIPELINE_SUBJECT - Log message", (Object)msg.toString());
    }

    @Test
    public void testToString_withOneArgument() throws Exception {
        this.turnOnLogMarkMapping();
        simpleLogChannelId = LoggingRegistry.getInstance().registerLoggingSource((Object)LogMessageTest.getLoggingObjectWithOneParent());
        LogMessage msg = new LogMessage("Log message for {0}", simpleLogChannelId, (Object[])new String[]{"Test"}, LogLevel.DEBUG);
        Assert.assertEquals((Object)"PIPELINE_SUBJECT - Log message for Test", (Object)msg.toString());
    }

    @Test
    public void testGetMessage() {
        LogMessage msg = new LogMessage("m {0}, {1}, {2}, {3}, {4,number,#.00}, {5} {foe}", "Channel 01", new Object[]{"Foo", "{abc}", "", null, 123}, LogLevel.DEBUG);
        Assert.assertEquals((Object)"m Foo, {abc}, , null, 123.00, {5} {foe}", (Object)msg.getMessage());
    }

    private void turnOnLogMarkMapping() {
        HopConfig.getInstance().setDescribedVariable(new DescribedVariable("HOP_LOG_MARK_MAPPINGS", "Y", ""));
    }

    private void turnOffLogMarkMapping() {
        HopConfig.getInstance().setDescribedVariable(new DescribedVariable("HOP_LOG_MARK_MAPPINGS", "N", ""));
    }

    private static ILoggingObject getTreeLoggingObject() {
        SimpleLoggingObject rootLogObject = new SimpleLoggingObject("ROOT_SUBJECT", LoggingObjectType.HOP_GUI, null);
        SimpleLoggingObject pipelineLogObject = new SimpleLoggingObject("PIPELINE_SUBJECT", LoggingObjectType.PIPELINE, (ILoggingObject)rootLogObject);
        SimpleLoggingObject transformLogObject = new SimpleLoggingObject("TRANSFORM_SUBJECT", LoggingObjectType.TRANSFORM, (ILoggingObject)pipelineLogObject);
        SimpleLoggingObject pipelineChildLogObject = new SimpleLoggingObject("PIPELINE_CHILD_SUBJECT", LoggingObjectType.PIPELINE, (ILoggingObject)transformLogObject);
        return pipelineChildLogObject;
    }

    private static ILoggingObject getLoggingObjectWithOneParent() {
        SimpleLoggingObject rootLogObject = new SimpleLoggingObject("ROOT_SUBJECT", LoggingObjectType.HOP_GUI, null);
        SimpleLoggingObject pipelineLogObject = new SimpleLoggingObject("PIPELINE_SUBJECT", LoggingObjectType.PIPELINE, (ILoggingObject)rootLogObject);
        return pipelineLogObject;
    }

    static {
        env = new RestoreHopEngineEnvironment();
    }
}

