/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.metadata;

import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.memory.MemoryMetadataProvider;
import org.apache.hop.server.HopServer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SerializableMetadataProviderTest {
    @Before
    public void before() throws Exception {
        HopEnvironment.init();
    }

    @Test
    public void testRoundTrip() throws Exception {
        MemoryMetadataProvider source = new MemoryMetadataProvider();
        IHopMetadataSerializer sourceSerializer = source.getSerializer(HopServer.class);
        HopServer sourceServer1 = new HopServer("server1", "hostname1", "8181", "8182", "username1", "password1", null, null, null, false);
        sourceSerializer.save((IHopMetadata)sourceServer1);
        HopServer sourceServer2 = new HopServer("server2", "hostname2", "8282", "8283", "username2", "password2", null, null, null, true);
        sourceSerializer.save((IHopMetadata)sourceServer2);
        SerializableMetadataProvider serializableMetadataProvider = new SerializableMetadataProvider((IHopMetadataProvider)source);
        String json = serializableMetadataProvider.toJson();
        SerializableMetadataProvider target = new SerializableMetadataProvider(json);
        IHopMetadataSerializer targetSerializer = target.getSerializer(HopServer.class);
        HopServer targetServer1 = (HopServer)targetSerializer.load("server1");
        Assert.assertNotNull((Object)targetServer1);
        Assert.assertEquals((Object)sourceServer1.getName(), (Object)targetServer1.getName());
        Assert.assertEquals((Object)sourceServer1.getHostname(), (Object)targetServer1.getHostname());
        Assert.assertEquals((Object)sourceServer1.getPort(), (Object)targetServer1.getPort());
        Assert.assertEquals((Object)sourceServer1.getUsername(), (Object)targetServer1.getUsername());
        Assert.assertEquals((Object)sourceServer1.getPassword(), (Object)targetServer1.getPassword());
        HopServer targetServer2 = (HopServer)targetSerializer.load("server2");
        Assert.assertNotNull((Object)targetServer2);
        Assert.assertEquals((Object)sourceServer2.getName(), (Object)targetServer2.getName());
        Assert.assertEquals((Object)sourceServer2.getHostname(), (Object)targetServer2.getHostname());
        Assert.assertEquals((Object)sourceServer2.getPort(), (Object)targetServer2.getPort());
        Assert.assertEquals((Object)sourceServer2.getUsername(), (Object)targetServer2.getUsername());
        Assert.assertEquals((Object)sourceServer2.getPassword(), (Object)targetServer2.getPassword());
    }
}

