/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileNotFoundException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.core.row.value.ValueMetaBigNumber;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class ValueDataUtilTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();
    private static String yyyy_MM_dd = "yyyy-MM-dd";

    @BeforeClass
    public static void setUpBeforeClass() throws HopException {
        HopEnvironment.init();
    }

    @Test
    public void testPlus() throws HopValueException {
        long longValue = 1L;
        Assert.assertEquals((Object)longValue, (Object)ValueDataUtil.plus((IValueMeta)new ValueMetaInteger(), (Object)longValue, (IValueMeta)new ValueMetaString(), (Object)""));
    }

    @Test
    public void checksumTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        String checksum = ValueDataUtil.createChecksum((IValueMeta)new ValueMetaString(), (Object)path, (String)"MD5", (boolean)false);
        Assert.assertEquals((Object)"098f6bcd4621d373cade4e832627b4f6", (Object)checksum);
    }

    @Test
    public void checksumMissingFileTest() throws Exception {
        String nonExistingFile = "nonExistingFile";
        String checksum = ValueDataUtil.createChecksum((IValueMeta)new ValueMetaString(), (Object)nonExistingFile, (String)"MD5", (boolean)false);
        Assert.assertNull((Object)checksum);
    }

    @Test
    public void checksumNullPathTest() throws Exception {
        String nonExistingFile = "nonExistingFile";
        String checksum = ValueDataUtil.createChecksum((IValueMeta)new ValueMetaString(), (Object)nonExistingFile, (String)"MD5", (boolean)false);
        Assert.assertNull((Object)checksum);
    }

    @Test
    public void checksumWithFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        String checksum = ValueDataUtil.createChecksum((IValueMeta)new ValueMetaString(), (Object)path, (String)"MD5", (boolean)true);
        Assert.assertEquals((Object)"098f6bcd4621d373cade4e832627b4f6", (Object)checksum);
    }

    @Test
    public void checksumWithoutFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        String checksum = ValueDataUtil.createChecksum((IValueMeta)new ValueMetaString(), (Object)path, (String)"MD5", (boolean)false);
        Assert.assertEquals((Object)"098f6bcd4621d373cade4e832627b4f6", (Object)checksum);
    }

    @Test
    public void checksumNoFailIfNoFileTest() throws HopFileNotFoundException {
        String nonExistingFile = "nonExistingFile";
        String checksum = ValueDataUtil.createChecksum((IValueMeta)new ValueMetaString(), (Object)nonExistingFile, (String)"MD5", (boolean)false);
        Assert.assertNull((Object)checksum);
    }

    @Test(expected=HopFileNotFoundException.class)
    public void checksumFailIfNoFileTest() throws HopFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        ValueDataUtil.createChecksum((IValueMeta)new ValueMetaString(), (Object)nonExistingPath, (String)"MD5", (boolean)true);
    }

    @Test
    public void checksumNullPathNoFailTest() throws HopFileNotFoundException {
        Assert.assertNull((Object)ValueDataUtil.createChecksum((IValueMeta)new ValueMetaString(), null, (String)"MD5", (boolean)false));
    }

    @Test
    public void checksumNullPathFailTest() throws HopFileNotFoundException {
        Assert.assertNull((Object)ValueDataUtil.createChecksum((IValueMeta)new ValueMetaString(), null, (String)"MD5", (boolean)true));
    }

    @Test
    public void checksumCRC32Test() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        long checksum = ValueDataUtil.checksumCRC32((IValueMeta)new ValueMetaString(), (Object)path, (boolean)false);
        Assert.assertEquals((long)3632233996L, (long)checksum);
    }

    @Test
    public void checksumCRC32MissingFileTest() throws Exception {
        String nonExistingFile = "nonExistingFile";
        long checksum = ValueDataUtil.checksumCRC32((IValueMeta)new ValueMetaString(), (Object)nonExistingFile, (boolean)false);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void checksumCRC32NullPathTest() throws Exception {
        String nonExistingFile = "nonExistingFile";
        long checksum = ValueDataUtil.checksumCRC32((IValueMeta)new ValueMetaString(), (Object)nonExistingFile, (boolean)false);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void checksumCRC32WithoutFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        long checksum = ValueDataUtil.checksumCRC32((IValueMeta)new ValueMetaString(), (Object)path, (boolean)false);
        Assert.assertEquals((long)3632233996L, (long)checksum);
    }

    @Test
    public void checksumCRC32NoFailIfNoFileTest() throws HopFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        long checksum = ValueDataUtil.checksumCRC32((IValueMeta)new ValueMetaString(), (Object)nonExistingPath, (boolean)false);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test(expected=HopFileNotFoundException.class)
    public void checksumCRC32FailIfNoFileTest() throws HopFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        ValueDataUtil.checksumCRC32((IValueMeta)new ValueMetaString(), (Object)nonExistingPath, (boolean)true);
    }

    @Test
    public void checksumCRC32NullPathNoFailTest() throws HopFileNotFoundException {
        long checksum = ValueDataUtil.checksumCRC32((IValueMeta)new ValueMetaString(), null, (boolean)false);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void checksumCRC32NullPathFailTest() throws HopFileNotFoundException {
        long checksum = ValueDataUtil.checksumCRC32((IValueMeta)new ValueMetaString(), null, (boolean)true);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void checksumAdlerWithFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        long checksum = ValueDataUtil.checksumAdler32((IValueMeta)new ValueMetaString(), (Object)path, (boolean)true);
        Assert.assertEquals((long)73204161L, (long)checksum);
    }

    @Test
    public void checksumAdlerWithoutFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        long checksum = ValueDataUtil.checksumAdler32((IValueMeta)new ValueMetaString(), (Object)path, (boolean)false);
        Assert.assertEquals((long)73204161L, (long)checksum);
    }

    @Test
    public void checksumAdlerNoFailIfNoFileTest() throws HopFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        long checksum = ValueDataUtil.checksumAdler32((IValueMeta)new ValueMetaString(), (Object)nonExistingPath, (boolean)false);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test(expected=HopFileNotFoundException.class)
    public void checksumAdlerFailIfNoFileTest() throws HopFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        ValueDataUtil.checksumAdler32((IValueMeta)new ValueMetaString(), (Object)nonExistingPath, (boolean)true);
    }

    @Test
    public void checksumAdlerNullPathNoFailTest() throws HopFileNotFoundException {
        long checksum = ValueDataUtil.checksumAdler32((IValueMeta)new ValueMetaString(), null, (boolean)false);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void checksumAdlerNullPathFailTest() throws HopFileNotFoundException {
        long checksum = ValueDataUtil.checksumAdler32((IValueMeta)new ValueMetaString(), null, (boolean)true);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void xmlFileWellFormedTest() throws HopFileNotFoundException {
        String xmlFilePath = this.getClass().getResource("xml-sample.xml").getPath();
        boolean wellFormed = ValueDataUtil.isXmlFileWellFormed((IValueMeta)new ValueMetaString(), (Object)xmlFilePath, (boolean)true);
        Assert.assertTrue((boolean)wellFormed);
    }

    @Test
    public void xmlFileBadlyFormedTest() throws HopFileNotFoundException {
        String invalidXmlFilePath = this.getClass().getResource("invalid-xml-sample.xml").getPath();
        boolean wellFormed = ValueDataUtil.isXmlFileWellFormed((IValueMeta)new ValueMetaString(), (Object)invalidXmlFilePath, (boolean)true);
        Assert.assertFalse((boolean)wellFormed);
    }

    @Test
    public void xmlFileWellFormedWithFailIfNoFileTest() throws HopFileNotFoundException {
        String xmlFilePath = this.getClass().getResource("xml-sample.xml").getPath();
        boolean wellFormed = ValueDataUtil.isXmlFileWellFormed((IValueMeta)new ValueMetaString(), (Object)xmlFilePath, (boolean)true);
        Assert.assertTrue((boolean)wellFormed);
    }

    @Test
    public void xmlFileWellFormedWithoutFailIfNoFileTest() throws HopFileNotFoundException {
        String xmlFilePath = this.getClass().getResource("xml-sample.xml").getPath();
        boolean wellFormed = ValueDataUtil.isXmlFileWellFormed((IValueMeta)new ValueMetaString(), (Object)xmlFilePath, (boolean)false);
        Assert.assertTrue((boolean)wellFormed);
    }

    @Test
    public void xmlFileBadlyFormedWithFailIfNoFileTest() throws HopFileNotFoundException {
        String invalidXmlFilePath = this.getClass().getResource("invalid-xml-sample.xml").getPath();
        boolean wellFormed = ValueDataUtil.isXmlFileWellFormed((IValueMeta)new ValueMetaString(), (Object)invalidXmlFilePath, (boolean)true);
        Assert.assertFalse((boolean)wellFormed);
    }

    @Test
    public void xmlFileBadlyFormedWithNoFailIfNoFileTest() throws HopFileNotFoundException {
        String invalidXmlFilePath = this.getClass().getResource("invalid-xml-sample.xml").getPath();
        boolean wellFormed = ValueDataUtil.isXmlFileWellFormed((IValueMeta)new ValueMetaString(), (Object)invalidXmlFilePath, (boolean)false);
        Assert.assertFalse((boolean)wellFormed);
    }

    @Test
    public void xmlFileWellFormedNoFailIfNoFileTest() throws HopFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        boolean wellFormed = ValueDataUtil.isXmlFileWellFormed((IValueMeta)new ValueMetaString(), (Object)nonExistingPath, (boolean)false);
        Assert.assertFalse((boolean)wellFormed);
    }

    @Test(expected=HopFileNotFoundException.class)
    public void xmlFileWellFormedFailIfNoFileTest() throws HopFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        ValueDataUtil.isXmlFileWellFormed((IValueMeta)new ValueMetaString(), (Object)nonExistingPath, (boolean)true);
    }

    @Test
    public void xmlFileWellFormedNullPathNoFailTest() throws HopFileNotFoundException {
        boolean wellFormed = ValueDataUtil.isXmlFileWellFormed((IValueMeta)new ValueMetaString(), null, (boolean)false);
        Assert.assertFalse((boolean)wellFormed);
    }

    @Test
    public void xmlFileWellFormedNullPathFailTest() throws HopFileNotFoundException {
        boolean wellFormed = ValueDataUtil.isXmlFileWellFormed((IValueMeta)new ValueMetaString(), null, (boolean)true);
        Assert.assertFalse((boolean)wellFormed);
    }

    @Test
    public void loadFileContentInBinary() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        byte[] content = ValueDataUtil.loadFileContentInBinary((IValueMeta)new ValueMetaString(), (Object)path, (boolean)true);
        Assert.assertTrue((boolean)Arrays.equals("test".getBytes(), content));
    }

    @Test
    public void loadFileContentInBinaryNoFailIfNoFileTest() throws Exception {
        String nonExistingPath = "nonExistingPath";
        Assert.assertNull((Object)ValueDataUtil.loadFileContentInBinary((IValueMeta)new ValueMetaString(), (Object)nonExistingPath, (boolean)false));
    }

    @Test(expected=HopFileNotFoundException.class)
    public void loadFileContentInBinaryFailIfNoFileTest() throws HopFileNotFoundException, HopValueException {
        String nonExistingPath = "nonExistingPath";
        ValueDataUtil.loadFileContentInBinary((IValueMeta)new ValueMetaString(), (Object)nonExistingPath, (boolean)true);
    }

    @Test
    public void loadFileContentInBinaryNullPathNoFailTest() throws Exception {
        Assert.assertNull((Object)ValueDataUtil.loadFileContentInBinary((IValueMeta)new ValueMetaString(), null, (boolean)false));
    }

    @Test
    public void loadFileContentInBinaryNullPathFailTest() throws HopFileNotFoundException, HopValueException {
        Assert.assertNull((Object)ValueDataUtil.loadFileContentInBinary((IValueMeta)new ValueMetaString(), null, (boolean)true));
    }

    @Test
    public void getFileEncodingWithFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        String encoding = ValueDataUtil.getFileEncoding((IValueMeta)new ValueMetaString(), (Object)path, (boolean)true);
        Assert.assertEquals((Object)"US-ASCII", (Object)encoding);
    }

    @Test
    public void getFileEncodingWithoutFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        String encoding = ValueDataUtil.getFileEncoding((IValueMeta)new ValueMetaString(), (Object)path, (boolean)false);
        Assert.assertEquals((Object)"US-ASCII", (Object)encoding);
    }

    @Test
    public void getFileEncodingNoFailIfNoFileTest() throws Exception {
        String nonExistingPath = "nonExistingPath";
        String encoding = ValueDataUtil.getFileEncoding((IValueMeta)new ValueMetaString(), (Object)nonExistingPath, (boolean)false);
        Assert.assertNull((Object)encoding);
    }

    @Test(expected=HopFileNotFoundException.class)
    public void getFileEncodingFailIfNoFileTest() throws HopFileNotFoundException, HopValueException {
        String nonExistingPath = "nonExistingPath";
        ValueDataUtil.getFileEncoding((IValueMeta)new ValueMetaString(), (Object)nonExistingPath, (boolean)true);
    }

    @Test
    public void getFileEncodingNullPathNoFailTest() throws Exception {
        String encoding = ValueDataUtil.getFileEncoding((IValueMeta)new ValueMetaString(), null, (boolean)false);
        Assert.assertNull((Object)encoding);
    }

    @Test
    public void getFileEncodingNullPathFailTest() throws HopFileNotFoundException, HopValueException {
        String encoding = ValueDataUtil.getFileEncoding((IValueMeta)new ValueMetaString(), null, (boolean)true);
        Assert.assertNull((Object)encoding);
    }

    @Test
    public void testMulitplyBigNumbers() throws Exception {
        BigDecimal field1 = new BigDecimal("123456789012345678901.1234567890123456789");
        BigDecimal field2 = new BigDecimal("1.0");
        BigDecimal field3 = new BigDecimal("2.0");
        BigDecimal expResult1 = new BigDecimal("123456789012345678901.1234567890123456789");
        BigDecimal expResult2 = new BigDecimal("246913578024691357802.2469135780246913578");
        BigDecimal expResult3 = new BigDecimal("123456789012345678901.1200000000000000000");
        BigDecimal expResult4 = new BigDecimal("246913578024691357802");
        Assert.assertEquals((Object)expResult1, (Object)ValueDataUtil.multiplyBigDecimals((BigDecimal)field1, (BigDecimal)field2, null));
        Assert.assertEquals((Object)expResult2, (Object)ValueDataUtil.multiplyBigDecimals((BigDecimal)field1, (BigDecimal)field3, null));
        Assert.assertEquals((Object)expResult3, (Object)ValueDataUtil.multiplyBigDecimals((BigDecimal)field1, (BigDecimal)field2, (MathContext)new MathContext(23)));
        Assert.assertEquals((Object)expResult4, (Object)ValueDataUtil.multiplyBigDecimals((BigDecimal)field1, (BigDecimal)field3, (MathContext)new MathContext(21)));
    }

    @Test
    public void testDivisionBigNumbers() throws Exception {
        BigDecimal field1 = new BigDecimal("123456789012345678901.1234567890123456789");
        BigDecimal field2 = new BigDecimal("1.0");
        BigDecimal field3 = new BigDecimal("2.0");
        BigDecimal expResult1 = new BigDecimal("123456789012345678901.1234567890123456789");
        BigDecimal expResult2 = new BigDecimal("61728394506172839450.56172839450617283945");
        BigDecimal expResult3 = new BigDecimal("123456789012345678901.12");
        BigDecimal expResult4 = new BigDecimal("61728394506172839450.6");
        Assert.assertEquals((Object)expResult1, (Object)ValueDataUtil.divideBigDecimals((BigDecimal)field1, (BigDecimal)field2, null));
        Assert.assertEquals((Object)expResult2, (Object)ValueDataUtil.divideBigDecimals((BigDecimal)field1, (BigDecimal)field3, null));
        Assert.assertEquals((Object)expResult3, (Object)ValueDataUtil.divideBigDecimals((BigDecimal)field1, (BigDecimal)field2, (MathContext)new MathContext(23)));
        Assert.assertEquals((Object)expResult4, (Object)ValueDataUtil.divideBigDecimals((BigDecimal)field1, (BigDecimal)field3, (MathContext)new MathContext(21)));
    }

    @Test
    public void testRemainderBigNumbers() throws Exception {
        BigDecimal field1 = new BigDecimal("123456789012345678901.1234567890123456789");
        BigDecimal field2 = new BigDecimal("1.0");
        BigDecimal field3 = new BigDecimal("2.0");
        BigDecimal expResult1 = new BigDecimal("0.1234567890123456789");
        BigDecimal expResult2 = new BigDecimal("1.1234567890123456789");
        Assert.assertEquals((Object)expResult1, (Object)ValueDataUtil.remainder((IValueMeta)new ValueMetaBigNumber(), (Object)field1, (IValueMeta)new ValueMetaBigNumber(), (Object)field2));
        Assert.assertEquals((Object)expResult2, (Object)ValueDataUtil.remainder((IValueMeta)new ValueMetaBigNumber(), (Object)field1, (IValueMeta)new ValueMetaBigNumber(), (Object)field3));
    }

    @Test
    public void testSumWithNullValues() throws Exception {
        ValueMetaInteger metaA = new ValueMetaInteger();
        metaA.setStorageType(0);
        ValueMetaInteger metaB = new ValueMetaInteger();
        metaA.setStorageType(0);
        Assert.assertNull((Object)ValueDataUtil.sum((IValueMeta)metaA, null, (IValueMeta)metaB, null));
        Long valueB = new Long(2L);
        ValueDataUtil.sum((IValueMeta)metaA, null, (IValueMeta)metaB, (Object)valueB);
    }

    @Test
    public void testSumConvertingStorageTypeToNormal() throws Exception {
        IValueMeta metaA = (IValueMeta)Mockito.mock(ValueMetaInteger.class);
        metaA.setStorageType(1);
        ValueMetaInteger metaB = new ValueMetaInteger();
        metaB.setStorageType(1);
        String valueB = "2";
        Mockito.when((Object)metaA.convertData((IValueMeta)metaB, (Object)valueB)).thenAnswer(invocation -> new Long(2L));
        Object returnValue = ValueDataUtil.sum((IValueMeta)metaA, null, (IValueMeta)metaB, (Object)valueB);
        ((IValueMeta)Mockito.verify((Object)metaA)).convertData((IValueMeta)metaB, (Object)valueB);
        Assert.assertEquals((Object)2L, (Object)returnValue);
        Assert.assertEquals((long)metaA.getStorageType(), (long)0L);
    }
}

