/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.hop.core.util.JavaScriptUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class JavaScriptUtilsTest {
    private static final String UNDEFINED = Undefined.class.getName();
    private static final String JAVA_OBJECT = NativeJavaObject.class.getName();
    private static final String NATIVE_NUMBER = "org.mozilla.javascript.NativeNumber";
    private static Context ctx;
    private static ScriptableObject scope;

    @BeforeClass
    public static void setUp() throws Exception {
        ctx = Context.enter();
        scope = ctx.initStandardObjects();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        scope = null;
        ctx = null;
        Context.exit();
    }

    private static Scriptable getIntValue() {
        return Context.toObject((Object)new Long(1L), (Scriptable)scope);
    }

    private static Scriptable getDoubleValue() {
        return Context.toObject((Object)new Double(1.0), (Scriptable)scope);
    }

    @Test
    public void jsToNumber_Undefined() throws Exception {
        Assert.assertNull((Object)JavaScriptUtils.jsToNumber(null, (String)UNDEFINED));
    }

    @Test
    public void jsToNumber_NativeJavaObject_Double() throws Exception {
        Scriptable value = JavaScriptUtilsTest.getDoubleValue();
        Number number = JavaScriptUtils.jsToNumber((Object)value, (String)JAVA_OBJECT);
        Assert.assertEquals((double)1.0, (double)number.doubleValue(), (double)1.0E-6);
    }

    @Test
    public void jsToNumber_NativeJavaObject_Int() throws Exception {
        Scriptable value = JavaScriptUtilsTest.getIntValue();
        Number number = JavaScriptUtils.jsToNumber((Object)value, (String)JAVA_OBJECT);
        Assert.assertEquals((double)1.0, (double)number.doubleValue(), (double)1.0E-6);
    }

    @Test
    public void jsToNumber_NativeNumber() throws Exception {
        Scriptable value = Context.toObject((Object)1.0, (Scriptable)scope);
        Number number = JavaScriptUtils.jsToNumber((Object)value, (String)NATIVE_NUMBER);
        Assert.assertEquals((double)1.0, (double)number.doubleValue(), (double)1.0E-6);
    }

    @Test
    public void jsToNumber_JavaNumber() throws Exception {
        Number number = JavaScriptUtils.jsToNumber((Object)1.0, (String)Double.class.getName());
        Assert.assertEquals((double)1.0, (double)number.doubleValue(), (double)1.0E-6);
    }

    @Test
    public void jsToInteger_Undefined() throws Exception {
        Assert.assertNull((Object)JavaScriptUtils.jsToInteger(null, Undefined.class));
    }

    @Test
    public void jsToInteger_NaturalNumbers() throws Exception {
        Number[] naturalNumbers;
        for (Number number : naturalNumbers = new Number[]{(byte)1, (short)1, 1, 1L}) {
            Assert.assertEquals((Object)1L, (Object)JavaScriptUtils.jsToInteger((Object)number, number.getClass()));
        }
    }

    @Test
    public void jsToInteger_String() throws Exception {
        Assert.assertEquals((Object)1L, (Object)JavaScriptUtils.jsToInteger((Object)"1", String.class));
    }

    @Test(expected=NumberFormatException.class)
    public void jsToInteger_String_Unparseable() throws Exception {
        JavaScriptUtils.jsToInteger((Object)"q", String.class);
    }

    @Test
    public void jsToInteger_Double() throws Exception {
        Assert.assertEquals((Object)1L, (Object)JavaScriptUtils.jsToInteger((Object)1.0, Double.class));
    }

    @Test
    public void jsToInteger_NativeJavaObject_Int() throws Exception {
        Scriptable value = JavaScriptUtilsTest.getIntValue();
        Assert.assertEquals((Object)1L, (Object)JavaScriptUtils.jsToInteger((Object)value, NativeJavaObject.class));
    }

    @Test
    public void jsToInteger_NativeJavaObject_Double() throws Exception {
        Scriptable value = JavaScriptUtilsTest.getDoubleValue();
        Assert.assertEquals((Object)1L, (Object)JavaScriptUtils.jsToInteger((Object)value, NativeJavaObject.class));
    }

    @Test
    public void jsToInteger_Other_Int() throws Exception {
        Assert.assertEquals((Object)1L, (Object)JavaScriptUtils.jsToInteger((Object)1, this.getClass()));
    }

    @Test(expected=NumberFormatException.class)
    public void jsToInteger_Other_String() throws Exception {
        JavaScriptUtils.jsToInteger((Object)"qwerty", this.getClass());
    }

    @Test
    public void jsToString_Undefined() throws Exception {
        Assert.assertEquals((Object)"null", (Object)JavaScriptUtils.jsToString(null, (String)UNDEFINED));
    }

    @Test
    public void jsToString_NativeJavaObject_Int() throws Exception {
        Assert.assertEquals((Object)"1", (Object)JavaScriptUtils.jsToString((Object)JavaScriptUtilsTest.getIntValue(), (String)JAVA_OBJECT));
    }

    @Test
    public void jsToString_NativeJavaObject_Double() throws Exception {
        Assert.assertEquals((Object)"1", (Object)JavaScriptUtils.jsToString((Object)JavaScriptUtilsTest.getDoubleValue(), (String)JAVA_OBJECT));
        Scriptable value = Context.toObject((Object)new Double(1.23), (Scriptable)scope);
        Assert.assertEquals((Object)"1.23", (Object)JavaScriptUtils.jsToString((Object)value, (String)JAVA_OBJECT));
    }

    @Test
    public void jsToString_String() throws Exception {
        Assert.assertEquals((Object)"qwerty", (Object)JavaScriptUtils.jsToString((Object)"qwerty", (String)String.class.getName()));
    }

    @Test
    public void jsToDate_Undefined() throws Exception {
        Assert.assertNull((Object)JavaScriptUtils.jsToDate(null, (String)UNDEFINED));
    }

    @Test
    public void jsToDate_NativeDate() throws Exception {
        Date date = new Date(1L);
        Scriptable value = ctx.newObject((Scriptable)scope, "Date", new Object[]{date.getTime()});
        Assert.assertEquals((Object)date, (Object)JavaScriptUtils.jsToDate((Object)value, (String)"org.mozilla.javascript.NativeDate"));
    }

    @Test
    public void jsToDate_NativeJavaObject() throws Exception {
        Scriptable value = Context.toObject((Object)new Date(1L), (Scriptable)scope);
        Assert.assertEquals((Object)new Date(1L), (Object)JavaScriptUtils.jsToDate((Object)value, (String)JAVA_OBJECT));
    }

    @Test
    public void jsToDate_Double() throws Exception {
        Assert.assertEquals((Object)new Date(1L), (Object)JavaScriptUtils.jsToDate((Object)1.0, (String)Double.class.getName()));
    }

    @Test
    public void jsToDate_String() throws Exception {
        Assert.assertEquals((Object)new Date(1L), (Object)JavaScriptUtils.jsToDate((Object)"1.0", (String)String.class.getName()));
    }

    @Test(expected=NumberFormatException.class)
    public void jsToDate_String_Unparseable() throws Exception {
        JavaScriptUtils.jsToDate((Object)"qwerty", (String)String.class.getName());
    }

    @Test
    public void jsToBigNumber_Undefined() throws Exception {
        Assert.assertNull((Object)JavaScriptUtils.jsToBigNumber(null, (String)UNDEFINED));
    }

    @Test
    public void jsToBigNumber_NativeNumber() throws Exception {
        Scriptable value = Context.toObject((Object)1.0, (Scriptable)scope);
        BigDecimal number = JavaScriptUtils.jsToBigNumber((Object)value, (String)NATIVE_NUMBER);
        Assert.assertEquals((double)1.0, (double)number.doubleValue(), (double)1.0E-6);
    }

    @Test
    public void jsToBigNumber_NativeJavaObject_Int() throws Exception {
        Assert.assertEquals((double)1.0, (double)JavaScriptUtils.jsToBigNumber((Object)JavaScriptUtilsTest.getIntValue(), (String)JAVA_OBJECT).doubleValue(), (double)1.0E-6);
    }

    @Test
    public void jsToBigNumber_NativeJavaObject_Double() throws Exception {
        Assert.assertEquals((double)1.0, (double)JavaScriptUtils.jsToBigNumber((Object)JavaScriptUtilsTest.getDoubleValue(), (String)JAVA_OBJECT).doubleValue(), (double)1.0E-6);
    }

    @Test
    public void jsToBigNumber_NativeJavaObject_BigDecimal() throws Exception {
        Scriptable object = Context.toObject((Object)BigDecimal.ONE, (Scriptable)scope);
        Assert.assertEquals((double)1.0, (double)JavaScriptUtils.jsToBigNumber((Object)object, (String)JAVA_OBJECT).doubleValue(), (double)1.0E-6);
    }

    @Test
    public void jsToBigNumber_NaturalNumbers() throws Exception {
        Number[] naturalNumbers;
        for (Number number : naturalNumbers = new Number[]{(byte)1, (short)1, 1, 1L}) {
            Assert.assertEquals((double)1.0, (double)JavaScriptUtils.jsToBigNumber((Object)number, (String)number.getClass().getName()).doubleValue(), (double)1.0E-6);
        }
    }

    @Test
    public void jsToBigNumber_Double() throws Exception {
        Assert.assertEquals((double)1.0, (double)JavaScriptUtils.jsToBigNumber((Object)1.0, (String)Double.class.getName()).doubleValue(), (double)1.0E-6);
    }

    @Test
    public void jsToBigNumber_String() throws Exception {
        Assert.assertEquals((double)1.0, (double)JavaScriptUtils.jsToBigNumber((Object)"1", (String)String.class.getName()).doubleValue(), (double)1.0E-6);
    }

    @Test(expected=RuntimeException.class)
    public void jsToBigNumber_UnknownClass() throws Exception {
        JavaScriptUtils.jsToBigNumber((Object)"1", (String)"qwerty");
    }

    @Test(expected=RuntimeException.class)
    public void convertFromJs_TypeNone() throws Exception {
        JavaScriptUtils.convertFromJs(null, (int)0, (String)"qwerty");
    }

    @Test
    public void convertFromJs_TypeBoolean() throws Exception {
        Object o = new Object();
        Object o2 = JavaScriptUtils.convertFromJs((Object)o, (int)4, (String)"qwerty");
        Assert.assertEquals((Object)o, (Object)o2);
    }

    @Test
    public void convertFromJs_TypeBinary() throws Exception {
        byte[] bytes = new byte[]{0, 1};
        Object converted = JavaScriptUtils.convertFromJs((Object)bytes, (int)8, (String)"qwerty");
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(byte[].class)));
        Assert.assertArrayEquals((byte[])bytes, (byte[])((byte[])converted));
    }
}

