/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.HopClientEnvironment;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.row.RowMetaBuilder;
import org.apache.hop.execution.ExecutionData;
import org.apache.hop.execution.ExecutionDataBuilder;
import org.apache.hop.execution.ExecutionDataSetMeta;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExecutionDataTest {
    @Before
    public void before() throws Exception {
        HopClientEnvironment.init();
    }

    @Test
    public void testSerialization() throws Exception {
        IRowMeta rowMeta = new RowMetaBuilder().addInteger("id", 9).addString("firstName", 35).addString("lastName", 35).addBoolean("enabled").addNumber("someNumber", 7, 3).addBigNumber("bigNumber", 25, 10).addDate("logDate").build();
        List rows = Arrays.asList({1L, "Apache", "Hop", true, 987.654, new BigDecimal("132384738943236.2345678901"), new Date()}, {2L, "Apache", "Beam", false, 876.543, new BigDecimal("132344728963226.2325679902"), new Date()}, {3L, "Apache", "Spark", true, 765.432, new BigDecimal("231385738943236.1325658801"), new Date()}, {4L, "Apache", "Flink", false, 654.321, new BigDecimal("290375731946235.9325653811"), new Date()}, {5L, "GCP", "Dataflow", true, 543.21, new BigDecimal("910365731946235.5322603719"), new Date()}, {6L, "Nulls", null, null, null, null, null});
        ExecutionDataSetMeta setMeta = new ExecutionDataSetMeta("firstRows", "12345-logchannel-id", "transformName", "0", "First rows of transform");
        ExecutionData data = ExecutionDataBuilder.of().addDataSets(Map.of("firstRows", new RowBuffer(rowMeta, rows))).addSetMeta(Map.of("firstRows", setMeta)).withParentId("parentId").withOwnerId("ownerId").build();
        ObjectMapper objectMapper = HopJson.newMapper();
        String json = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)data);
        Assert.assertNotNull((Object)json);
        ExecutionData copy = (ExecutionData)objectMapper.readValue(json, ExecutionData.class);
        Assert.assertNotNull((Object)copy);
        Assert.assertEquals((Object)data, (Object)copy);
    }
}

