/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.history.AuditEvent;
import org.apache.hop.history.AuditManager;
import org.apache.hop.history.IAuditManager;
import org.apache.hop.history.local.LocalAuditManager;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AuditManagerTest {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Test
    public void testSingleton() {
        AuditManager instance1 = AuditManager.getInstance();
        AuditManager instance2 = AuditManager.getInstance();
        Assert.assertEquals((Object)instance1, (Object)instance2);
    }

    @Test
    public void testHasAnActiveAuditManager() {
        Assert.assertNotNull((Object)AuditManager.getActive());
    }

    @Test
    public void testRegisterEvent() throws HopException {
        IAuditManager mockManager = (IAuditManager)Mockito.mock(IAuditManager.class);
        AuditManager.getInstance().setActiveAuditManager(mockManager);
        AuditManager.registerEvent((String)"", (String)"", (String)"", (String)"");
        ((IAuditManager)Mockito.verify((Object)mockManager, (VerificationMode)Mockito.times((int)1))).storeEvent((AuditEvent)Matchers.any());
    }

    @Test
    public void testEvents() throws HopException {
        String group = "testEvents";
        IAuditManager mockManager = (IAuditManager)Mockito.mock(IAuditManager.class);
        AuditManager.getInstance().setActiveAuditManager(mockManager);
        ArrayList<AuditEvent> events = new ArrayList<AuditEvent>();
        events.add(new AuditEvent(group, "type1", "name1", "operation1", new Date()));
        events.add(new AuditEvent(group, "type1", "name2", "operation1", new Date()));
        Mockito.when((Object)mockManager.findEvents(group, "type1", false)).thenReturn(events);
        List allEvents = AuditManager.findEvents((String)group, (String)"type1", (String)"operation1", (int)10, (boolean)false);
        Assert.assertEquals((String)"Not getting all events", (long)2L, (long)allEvents.size());
    }

    @Test
    public void testFindUniqueEvents() throws HopException {
        String group = "testFindUniqueEvents";
        IAuditManager mockManager = (IAuditManager)Mockito.mock(IAuditManager.class);
        AuditManager.getInstance().setActiveAuditManager(mockManager);
        ArrayList<AuditEvent> events = new ArrayList<AuditEvent>();
        events.add(new AuditEvent(group, "type1", "name1", "operation1", new Date()));
        events.add(new AuditEvent(group, "type1", "name2", "operation1", new Date()));
        Mockito.when((Object)mockManager.findEvents(group, "type1", true)).thenReturn(events);
        List uniqueEvents = AuditManager.findEvents((String)group, (String)"type1", (String)"operation1", (int)10, (boolean)true);
        Assert.assertEquals((String)"Not getting unique events", (long)2L, (long)uniqueEvents.size());
    }

    @Ignore
    @Test
    public void testFindAllEventsWithDefaultAuditManager() throws HopException {
        AuditManager.getInstance().setActiveAuditManager((IAuditManager)new LocalAuditManager(this.testFolder.getRoot().getAbsolutePath()));
        String group = "testFindAllEventsWithDefaultAuditManager";
        AuditManager.clearEvents();
        AuditManager.registerEvent((String)group, (String)"type1", (String)"name1", (String)"operation1");
        AuditManager.registerEvent((String)group, (String)"type1", (String)"name1", (String)"operation1");
        AuditManager.registerEvent((String)group, (String)"type1", (String)"name1", (String)"operation1");
        AuditManager.registerEvent((String)group, (String)"type1", (String)"name2", (String)"operation1");
        AuditManager.registerEvent((String)group, (String)"type2", (String)"name2", (String)"operation1");
        List allEvents = AuditManager.findEvents((String)group, (String)"type1", (String)"operation1", (int)10, (boolean)false);
        Assert.assertEquals((String)"Not getting unique events", (long)4L, (long)allEvents.size());
        AuditManager.clearEvents();
    }

    @Test
    public void testFindUniqueEventsWithDefaultAuditManager() throws HopException {
        AuditManager.getInstance().setActiveAuditManager((IAuditManager)new LocalAuditManager(this.testFolder.getRoot().getAbsolutePath()));
        String group = "testFindUniqueEventsWithDefaultAuditManager";
        AuditManager.clearEvents();
        AuditManager.registerEvent((String)group, (String)"type1", (String)"name1", (String)"operation1");
        AuditManager.registerEvent((String)group, (String)"type1", (String)"name1", (String)"operation1");
        List uniqueEvents = AuditManager.findEvents((String)group, (String)"type1", (String)"operation1", (int)10, (boolean)true);
        Assert.assertEquals((String)"Not getting unique events", (long)1L, (long)uniqueEvents.size());
        AuditManager.clearEvents();
    }

    @Test
    public void testFindMaxEvents() throws HopException {
        String group = "testFindMaxEvents";
        IAuditManager mockManager = (IAuditManager)Mockito.mock(IAuditManager.class);
        AuditManager.getInstance().setActiveAuditManager(mockManager);
        ArrayList<AuditEvent> events = new ArrayList<AuditEvent>();
        events.add(new AuditEvent(group, "type1", "name1", "operation1", new Date()));
        events.add(new AuditEvent(group, "type1", "name2", "operation1", new Date()));
        events.add(new AuditEvent(group, "type1", "name3", "operation1", new Date()));
        events.add(new AuditEvent(group, "type1", "name4", "operation1", new Date()));
        Mockito.when((Object)mockManager.findEvents(group, "type1", false)).thenReturn(events);
        List maxEvents = AuditManager.findEvents((String)group, (String)"type1", (String)"operation1", (int)2, (boolean)false);
        Assert.assertEquals((String)"Not getting unique events", (long)2L, (long)maxEvents.size());
    }

    @Ignore
    public void testClearEvents() throws HopException {
        AuditManager.getInstance().setActiveAuditManager((IAuditManager)new LocalAuditManager(this.testFolder.getRoot().getAbsolutePath()));
        for (int i = 0; i < 100; ++i) {
            AuditManager.getActive().clearEvents();
            String group = "testClearEvents";
            AuditManager.registerEvent((String)group, (String)"type1", (String)"name1", (String)"operation1");
            AuditManager.registerEvent((String)group, (String)"type1", (String)"name1", (String)"operation1");
            Assert.assertEquals((String)"Problem in registering event", (long)2L, (long)AuditManager.findEvents((String)group, (String)"type1", (String)"operation1", (int)10, (boolean)false).size());
            AuditManager.clearEvents();
            Assert.assertEquals((String)"Problem in clearning event", (long)0L, (long)AuditManager.findEvents((String)group, (String)"type1", (String)"operation1", (int)10, (boolean)false).size());
        }
    }
}

