/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.listeners.IContentChangedListener;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.memory.MemoryMetadataProvider;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.ITransformMetaChangeListener;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.DummyMeta;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PipelineMetaTest {
    public static final String TRANSFORM_NAME = "Any transform name";
    private PipelineMeta pipelineMeta;
    private IVariables variables;
    private IHopMetadataProvider metadataProvider;

    @BeforeClass
    public static void initHop() throws Exception {
        HopEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.pipelineMeta = new PipelineMeta();
        this.variables = new Variables();
        this.metadataProvider = new MemoryMetadataProvider();
    }

    @Test
    public void testGetMinimum() {
        Point minimalCanvasPoint = new Point(0, 0);
        Point transformPoint = new Point(500, 500);
        Point point = this.pipelineMeta.getMinimum();
        Assert.assertEquals((long)minimalCanvasPoint.x, (long)point.x);
        Assert.assertEquals((long)minimalCanvasPoint.y, (long)point.y);
        TransformMeta transformMeta = (TransformMeta)Mockito.mock(TransformMeta.class);
        Mockito.when((Object)transformMeta.getLocation()).thenReturn((Object)transformPoint);
        this.pipelineMeta.addTransform(transformMeta);
        Point actualTransformPoint = this.pipelineMeta.getMinimum();
        Assert.assertEquals((long)(transformPoint.x - 20), (long)actualTransformPoint.x);
        Assert.assertEquals((long)(transformPoint.y - 20), (long)actualTransformPoint.y);
    }

    @Test
    public void testContentChangeListener() throws Exception {
        IContentChangedListener listener = (IContentChangedListener)Mockito.mock(IContentChangedListener.class);
        this.pipelineMeta.addContentChangedListener(listener);
        this.pipelineMeta.setChanged();
        this.pipelineMeta.setChanged(true);
        ((IContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).contentChanged(ArgumentMatchers.same((Object)this.pipelineMeta));
        this.pipelineMeta.clearChanged();
        this.pipelineMeta.setChanged(false);
        ((IContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).contentSafe(ArgumentMatchers.same((Object)this.pipelineMeta));
        this.pipelineMeta.removeContentChangedListener(listener);
        this.pipelineMeta.setChanged();
        this.pipelineMeta.setChanged(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testCompare() throws Exception {
        PipelineMeta pipelineMeta = new PipelineMeta();
        pipelineMeta.setNameSynchronizedWithFilename(false);
        pipelineMeta.setFilename("aFile");
        pipelineMeta.setName("aName");
        PipelineMeta pipelineMeta2 = new PipelineMeta();
        pipelineMeta2.setNameSynchronizedWithFilename(false);
        pipelineMeta2.setFilename("aFile");
        pipelineMeta2.setName("aName");
        Assert.assertEquals((long)0L, (long)pipelineMeta.compare(pipelineMeta, pipelineMeta2));
        pipelineMeta2.setFilename(null);
        Assert.assertEquals((long)1L, (long)pipelineMeta.compare(pipelineMeta, pipelineMeta2));
        Assert.assertEquals((long)-1L, (long)pipelineMeta.compare(pipelineMeta2, pipelineMeta));
        pipelineMeta2.setFilename("aFile");
        pipelineMeta2.setName(null);
        Assert.assertEquals((long)1L, (long)pipelineMeta.compare(pipelineMeta, pipelineMeta2));
        Assert.assertEquals((long)-1L, (long)pipelineMeta.compare(pipelineMeta2, pipelineMeta));
        pipelineMeta2.setFilename("aFile2");
        pipelineMeta2.setName("aName");
        Assert.assertEquals((long)-1L, (long)pipelineMeta.compare(pipelineMeta, pipelineMeta2));
        Assert.assertEquals((long)1L, (long)pipelineMeta.compare(pipelineMeta2, pipelineMeta));
        pipelineMeta2.setFilename("aFile");
        pipelineMeta2.setName("aName2");
        Assert.assertEquals((long)-1L, (long)pipelineMeta.compare(pipelineMeta, pipelineMeta2));
        Assert.assertEquals((long)1L, (long)pipelineMeta.compare(pipelineMeta2, pipelineMeta));
        pipelineMeta.setFilename(null);
        pipelineMeta2.setFilename(null);
        pipelineMeta2.setName("aName");
        Assert.assertEquals((long)0L, (long)pipelineMeta.compare(pipelineMeta, pipelineMeta2));
    }

    @Test
    public void testEquals() throws Exception {
        PipelineMeta pipelineMeta = new PipelineMeta();
        pipelineMeta.setFilename("1");
        pipelineMeta.setName("2");
        Assert.assertFalse((boolean)pipelineMeta.equals((Object)"somethingelse"));
        PipelineMeta pipelineMeta2 = new PipelineMeta();
        pipelineMeta2.setFilename("1");
        pipelineMeta2.setName("2");
        Assert.assertTrue((boolean)pipelineMeta.equals((Object)pipelineMeta2));
    }

    @Test
    public void testPipelineHops() throws Exception {
        PipelineMeta pipelineMeta = new PipelineMeta();
        pipelineMeta.setFilename("pipelineFile");
        pipelineMeta.setName("myPipeline");
        TransformMeta transform1 = new TransformMeta("name1", null);
        TransformMeta transform2 = new TransformMeta("name2", null);
        TransformMeta transform3 = new TransformMeta("name3", null);
        TransformMeta transform4 = new TransformMeta("name4", null);
        PipelineHopMeta hopMeta1 = new PipelineHopMeta(transform1, transform2, true);
        PipelineHopMeta hopMeta2 = new PipelineHopMeta(transform2, transform3, true);
        PipelineHopMeta hopMeta3 = new PipelineHopMeta(transform3, transform4, false);
        pipelineMeta.addPipelineHop(0, hopMeta1);
        pipelineMeta.addPipelineHop(1, hopMeta2);
        pipelineMeta.addPipelineHop(2, hopMeta3);
        List hops = pipelineMeta.getPipelineHopTransforms(true);
        Assert.assertSame((Object)transform1, hops.get(0));
        Assert.assertSame((Object)transform2, hops.get(1));
        Assert.assertSame((Object)transform3, hops.get(2));
        Assert.assertSame((Object)transform4, hops.get(3));
        Assert.assertEquals((Object)hopMeta2, (Object)pipelineMeta.findPipelineHop("name2 --> name3 (enabled)"));
        Assert.assertEquals((Object)hopMeta3, (Object)pipelineMeta.findPipelineHopFrom(transform3));
        Assert.assertEquals((Object)hopMeta2, (Object)pipelineMeta.findPipelineHop(hopMeta2));
        Assert.assertEquals((Object)hopMeta1, (Object)pipelineMeta.findPipelineHop(transform1, transform2));
        Assert.assertEquals(null, (Object)pipelineMeta.findPipelineHop(transform3, transform4, false));
        Assert.assertEquals((Object)hopMeta3, (Object)pipelineMeta.findPipelineHop(transform3, transform4, true));
        Assert.assertEquals((Object)hopMeta2, (Object)pipelineMeta.findPipelineHopTo(transform3));
        pipelineMeta.removePipelineHop(0);
        hops = pipelineMeta.getPipelineHopTransforms(true);
        Assert.assertSame((Object)transform2, hops.get(0));
        Assert.assertSame((Object)transform3, hops.get(1));
        Assert.assertSame((Object)transform4, hops.get(2));
        pipelineMeta.removePipelineHop(hopMeta2);
        hops = pipelineMeta.getPipelineHopTransforms(true);
        Assert.assertSame((Object)transform3, hops.get(0));
        Assert.assertSame((Object)transform4, hops.get(1));
    }

    @Test
    public void testGetAllPipelineHops() throws Exception {
        PipelineMeta pipelineMeta = new PipelineMeta();
        pipelineMeta.setFilename("pipelineFile");
        pipelineMeta.setName("myPipeline");
        TransformMeta transform1 = new TransformMeta("name1", null);
        TransformMeta transform2 = new TransformMeta("name2", null);
        TransformMeta transform3 = new TransformMeta("name3", null);
        TransformMeta transform4 = new TransformMeta("name4", null);
        PipelineHopMeta hopMeta1 = new PipelineHopMeta(transform1, transform2, true);
        PipelineHopMeta hopMeta2 = new PipelineHopMeta(transform2, transform3, true);
        PipelineHopMeta hopMeta3 = new PipelineHopMeta(transform2, transform4, true);
        pipelineMeta.addPipelineHop(0, hopMeta1);
        pipelineMeta.addPipelineHop(1, hopMeta2);
        pipelineMeta.addPipelineHop(2, hopMeta3);
        List allPipelineHopFrom = pipelineMeta.findAllPipelineHopFrom(transform2);
        Assert.assertEquals((Object)transform3, (Object)((PipelineHopMeta)allPipelineHopFrom.get(0)).getToTransform());
        Assert.assertEquals((Object)transform4, (Object)((PipelineHopMeta)allPipelineHopFrom.get(1)).getToTransform());
    }

    @Test
    public void testAddTransformWithChangeListenerInterface() {
        TransformMeta transformMeta = (TransformMeta)Mockito.mock(TransformMeta.class);
        TransformMetaChangeListenerInterfaceMock metaInterface = (TransformMetaChangeListenerInterfaceMock)Mockito.mock(TransformMetaChangeListenerInterfaceMock.class);
        Mockito.when((Object)transformMeta.getTransform()).thenReturn((Object)metaInterface);
        Assert.assertEquals((long)0L, (long)this.pipelineMeta.transforms.size());
        Assert.assertEquals((long)0L, (long)this.pipelineMeta.transformChangeListeners.size());
        this.pipelineMeta.addTransform(0, transformMeta);
        Assert.assertEquals((long)1L, (long)this.pipelineMeta.transforms.size());
        Assert.assertEquals((long)1L, (long)this.pipelineMeta.transformChangeListeners.size());
        this.pipelineMeta.addTransform(0, transformMeta);
        Assert.assertEquals((long)2L, (long)this.pipelineMeta.transforms.size());
        Assert.assertEquals((long)2L, (long)this.pipelineMeta.transformChangeListeners.size());
    }

    @Test
    public void testIsAnySelectedTransformUsedInPipelineHopsNothingSelectedCase() {
        List<TransformMeta> selectedTransforms = Arrays.asList(new TransformMeta(), new TransformMeta(), new TransformMeta());
        this.pipelineMeta.getTransforms().addAll(selectedTransforms);
        Assert.assertFalse((boolean)this.pipelineMeta.isAnySelectedTransformUsedInPipelineHops());
    }

    @Test
    public void testIsAnySelectedTransformUsedInPipelineHopsAnySelectedCase() {
        TransformMeta transformMeta = new TransformMeta();
        transformMeta.setName(TRANSFORM_NAME);
        PipelineHopMeta pipelineHopMeta = new PipelineHopMeta();
        transformMeta.setSelected(true);
        List<TransformMeta> selectedTransforms = Arrays.asList(new TransformMeta(), transformMeta, new TransformMeta());
        pipelineHopMeta.setToTransform(transformMeta);
        pipelineHopMeta.setFromTransform(transformMeta);
        this.pipelineMeta.getTransforms().addAll(selectedTransforms);
        this.pipelineMeta.addPipelineHop(pipelineHopMeta);
        Assert.assertTrue((boolean)this.pipelineMeta.isAnySelectedTransformUsedInPipelineHops());
    }

    @Test
    public void testCloneWithParam() throws Exception {
        PipelineMeta pipelineMeta = new PipelineMeta();
        pipelineMeta.setFilename("pipelineFile");
        pipelineMeta.setName("myPipeline");
        pipelineMeta.addParameterDefinition("key", "defValue", "description");
        Object clone = pipelineMeta.realClone(true);
        Assert.assertNotNull((Object)clone);
    }

    private static TransformMeta mockTransformMeta(String name) {
        TransformMeta meta = (TransformMeta)Mockito.mock(TransformMeta.class);
        Mockito.when((Object)meta.getName()).thenReturn((Object)name);
        return meta;
    }

    @Test
    public void testLoadXml() throws HopException {
        final String directory = "/home/admin";
        Node workflowNode = (Node)Mockito.mock(Node.class);
        NodeList nodeList = new NodeList(){
            ArrayList<Node> nodes = new ArrayList();
            {
                Node nodeInfo = (Node)Mockito.mock(Node.class);
                Mockito.when((Object)nodeInfo.getNodeName()).thenReturn((Object)"info");
                Mockito.when((Object)nodeInfo.getChildNodes()).thenReturn((Object)this);
                Node nodeDirectory = (Node)Mockito.mock(Node.class);
                Mockito.when((Object)nodeDirectory.getNodeName()).thenReturn((Object)"directory");
                Node child = (Node)Mockito.mock(Node.class);
                Mockito.when((Object)nodeDirectory.getFirstChild()).thenReturn((Object)child);
                Mockito.when((Object)child.getNodeValue()).thenReturn((Object)directory);
                this.nodes.add(nodeDirectory);
                this.nodes.add(nodeInfo);
            }

            @Override
            public Node item(int index) {
                return this.nodes.get(index);
            }

            @Override
            public int getLength() {
                return this.nodes.size();
            }
        };
        Mockito.when((Object)workflowNode.getChildNodes()).thenReturn((Object)nodeList);
        PipelineMeta meta = new PipelineMeta();
        IVariables variables = (IVariables)Mockito.mock(IVariables.class);
        Mockito.when((Object)variables.getVariableNames()).thenReturn((Object)new String[0]);
        meta.loadXml(workflowNode, null, this.metadataProvider, variables);
        meta.setInternalHopVariables(variables);
    }

    @Test
    public void infoTransformFieldsAreNotIncludedInGetTransformFields() throws HopTransformException {
        PipelineMeta pipelineMeta = new PipelineMeta();
        TransformMeta toBeAppended1 = this.testTransform("toBeAppended1", Collections.emptyList(), Arrays.asList("field1", "field2"));
        TransformMeta toBeAppended2 = this.testTransform("toBeAppended2", Collections.emptyList(), Arrays.asList("field1", "field2"));
        TransformMeta append = this.testTransform("append", Arrays.asList("toBeAppended1", "toBeAppended2"), Collections.singletonList("outputField"));
        TransformMeta after = new TransformMeta("after", (ITransformMeta)new DummyMeta());
        this.wireUpTestPipelineMeta(pipelineMeta, toBeAppended1, toBeAppended2, append, after);
        IRowMeta results = pipelineMeta.getTransformFields(this.variables, append, after, (IProgressMonitor)Mockito.mock(IProgressMonitor.class));
        Assert.assertThat((Object)1, (Matcher)CoreMatchers.equalTo((Object)results.size()));
        Assert.assertThat((Object)"outputField", (Matcher)CoreMatchers.equalTo((Object)results.getFieldNames()[0]));
    }

    @Test
    public void prevTransformFieldsAreIncludedInGetTransformFields() throws HopTransformException {
        PipelineMeta pipelineMeta = new PipelineMeta();
        TransformMeta prevTransform1 = this.testTransform("prevTransform1", Collections.emptyList(), Arrays.asList("field1", "field2"));
        TransformMeta prevTransform2 = this.testTransform("prevTransform2", Collections.emptyList(), Arrays.asList("field3", "field4", "field5"));
        TransformMeta someTransform = this.testTransform("transform", Arrays.asList("prevTransform1"), Arrays.asList("outputField"));
        TransformMeta after = new TransformMeta("after", (ITransformMeta)new DummyMeta());
        this.wireUpTestPipelineMeta(pipelineMeta, prevTransform1, prevTransform2, someTransform, after);
        IRowMeta results = pipelineMeta.getTransformFields(this.variables, someTransform, after, (IProgressMonitor)Mockito.mock(IProgressMonitor.class));
        Assert.assertThat((Object)4, (Matcher)CoreMatchers.equalTo((Object)results.size()));
        Assert.assertThat((Object)new String[]{"field3", "field4", "field5", "outputField"}, (Matcher)CoreMatchers.equalTo((Object)results.getFieldNames()));
    }

    @Test
    public void findPreviousTransformsNullMeta() {
        PipelineMeta pipelineMeta = new PipelineMeta();
        List result = pipelineMeta.findPreviousTransforms(null, false);
        Assert.assertThat((Object)0, (Matcher)CoreMatchers.equalTo((Object)result.size()));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo(new ArrayList()));
    }

    private void wireUpTestPipelineMeta(PipelineMeta pipelineMeta, TransformMeta toBeAppended1, TransformMeta toBeAppended2, TransformMeta append, TransformMeta after) {
        pipelineMeta.addTransform(append);
        pipelineMeta.addTransform(after);
        pipelineMeta.addTransform(toBeAppended1);
        pipelineMeta.addTransform(toBeAppended2);
        pipelineMeta.addPipelineHop(new PipelineHopMeta(toBeAppended1, append));
        pipelineMeta.addPipelineHop(new PipelineHopMeta(toBeAppended2, append));
        pipelineMeta.addPipelineHop(new PipelineHopMeta(append, after));
    }

    private TransformMeta testTransform(String name, List<String> infoTransformNames, List<String> fieldNames) throws HopTransformException {
        ITransformMeta smi = this.transformMetaInterfaceWithFields((ITransformMeta)new DummyMeta(), infoTransformNames, fieldNames);
        return new TransformMeta(name, smi);
    }

    private ITransformMeta transformMetaInterfaceWithFields(ITransformMeta smi, List<String> infoTransformNames, List<String> fieldNames) throws HopTransformException {
        RowMeta rowMetaWithFields = new RowMeta();
        TransformIOMeta transformIOMeta = (TransformIOMeta)Mockito.mock(TransformIOMeta.class);
        Mockito.when((Object)transformIOMeta.getInfoTransformNames()).thenReturn((Object)infoTransformNames.toArray(new String[0]));
        fieldNames.stream().forEach(field -> rowMetaWithFields.addValueMeta((IValueMeta)new ValueMetaString(field)));
        ITransformMeta newSmi = (ITransformMeta)Mockito.spy((Object)smi);
        Mockito.when((Object)newSmi.getTransformIOMeta()).thenReturn((Object)transformIOMeta);
        ((ITransformMeta)Mockito.doAnswer(invocationOnMock -> {
            IRowMeta passedRmi = (IRowMeta)invocationOnMock.getArguments()[0];
            passedRmi.addRowMeta((IRowMeta)rowMetaWithFields);
            return null;
        }).when((Object)newSmi)).getFields((IRowMeta)Mockito.any(), (String)Mockito.any(), (IRowMeta[])Mockito.any(), (TransformMeta)Mockito.any(), (IVariables)Mockito.any(), (IHopMetadataProvider)Mockito.any());
        return newSmi;
    }

    private TransformMeta createTransformMeta(String name) {
        TransformMeta transformMeta = (TransformMeta)Mockito.mock(TransformMeta.class);
        Mockito.when((Object)transformMeta.getName()).thenReturn((Object)name);
        return transformMeta;
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithFilename() {
        PipelineMeta pipelineMetaTest = new PipelineMeta();
        pipelineMetaTest.setFilename("hasFilename");
        this.variables.setVariable("Internal.Entry.Current.Folder", "Original value defined at run execution");
        this.variables.setVariable("Internal.Pipeline.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        pipelineMetaTest.setInternalEntryCurrentDirectory(this.variables);
        Assert.assertEquals((Object)"file:///C:/SomeFilenameDirectory", (Object)this.variables.getVariable("Internal.Entry.Current.Folder"));
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithoutFilename() {
        PipelineMeta pipelineMetaTest = new PipelineMeta();
        this.variables.setVariable("Internal.Entry.Current.Folder", "Original value defined at run execution");
        this.variables.setVariable("Internal.Pipeline.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        pipelineMetaTest.setInternalEntryCurrentDirectory(this.variables);
        Assert.assertEquals((Object)"Original value defined at run execution", (Object)this.variables.getVariable("Internal.Entry.Current.Folder"));
    }

    @Test
    public void testSerialization1() throws Exception {
        this.pipelineMeta.setName("testSerialization1");
        this.pipelineMeta.setDescription("description of testSerialization1");
        this.pipelineMeta.setExtendedDescription("extended description of testSerialization1");
        this.pipelineMeta.addNote(new NotePadMeta("Test note", 50, 50, 300, 20));
        TransformMeta one = new TransformMeta("one", (ITransformMeta)new DummyMeta());
        one.setLocation(100, 200);
        TransformMeta two = new TransformMeta("two", (ITransformMeta)new DummyMeta());
        one.setLocation(200, 200);
        this.pipelineMeta.addTransform(one);
        this.pipelineMeta.addTransform(two);
        this.pipelineMeta.addPipelineHop(new PipelineHopMeta(one, two));
        String xml = this.pipelineMeta.getXml(this.variables);
        PipelineMeta copy = new PipelineMeta(XmlHandler.loadXmlString((String)xml, (String)"pipeline"), this.metadataProvider);
        Assert.assertEquals((Object)xml, (Object)copy.getXml(this.variables));
    }

    public static abstract class TransformMetaChangeListenerInterfaceMock
    implements ITransformMeta,
    ITransformMetaChangeListener {
        public abstract Object clone();
    }
}

