/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.util.concurrent.CountDownLatch;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.apache.hop.pipeline.IExecutionFinishedListener;
import org.apache.hop.pipeline.IExecutionStoppedListener;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PipelineTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();
    @Mock
    private ITransform transformMock;
    @Mock
    private ITransform transformMock2;
    @Mock
    private ITransformData data;
    @Mock
    private ITransformData data2;
    @Mock
    private TransformMeta transformMeta;
    @Mock
    private TransformMeta transformMeta2;
    @Mock
    private PipelineMeta pipelineMeta;
    int count = 10000;
    IPipelineEngine<PipelineMeta> pipeline;
    PipelineMeta meta;
    private final IExecutionFinishedListener<IPipelineEngine<PipelineMeta>> listener = pipeline -> {};
    private final IExecutionStoppedListener<IPipelineEngine<PipelineMeta>> pipelineStoppedListener = pipeline -> {};

    @BeforeClass
    public static void beforeClass() throws HopException {
        HopEnvironment.init();
    }

    @Before
    public void beforeTest() throws HopException {
        this.meta = new PipelineMeta();
        this.pipeline = new LocalPipelineEngine(this.meta);
        this.pipeline.setLogChannel((ILogChannel)Mockito.mock(ILogChannel.class));
        this.pipeline.prepareExecution();
        this.pipeline.startThreads();
    }

    @Test(timeout=1000L)
    public void pipelineWithNoTransformsIsNotEndless() throws Exception {
        LocalPipelineEngine pipelineWithNoTransforms = new LocalPipelineEngine(new PipelineMeta());
        pipelineWithNoTransforms = (Pipeline)Mockito.spy((Object)pipelineWithNoTransforms);
        pipelineWithNoTransforms.prepareExecution();
        pipelineWithNoTransforms.startThreads();
        ((Pipeline)Mockito.verify((Object)pipelineWithNoTransforms)).fireExecutionStartedListeners();
        ((Pipeline)Mockito.verify((Object)pipelineWithNoTransforms)).fireExecutionFinishedListeners();
    }

    @Test
    public void testPipelineFinishListenersConcurrentModification() throws HopException, InterruptedException {
        CountDownLatch start = new CountDownLatch(1);
        PipelineFinishListenerAdder add = new PipelineFinishListenerAdder(this.pipeline, start);
        PipelineFinishListenerFirer firer = new PipelineFinishListenerFirer(this.pipeline, start);
        this.startThreads(add, firer, start);
        Assert.assertEquals((String)"All listeners are added: no ConcurrentModificationException", (long)this.count, (long)add.c);
        Assert.assertEquals((String)"All Finish listeners are iterated over: no ConcurrentModificationException", (long)this.count, (long)firer.c);
    }

    @Test
    public void testPipelineStartListenersConcurrentModification() throws InterruptedException {
        CountDownLatch start = new CountDownLatch(1);
        PipelineFinishListenerAdder add = new PipelineFinishListenerAdder(this.pipeline, start);
        PipelineStartListenerFirer starter = new PipelineStartListenerFirer(this.pipeline, start);
        this.startThreads(add, starter, start);
        Assert.assertEquals((String)"All listeners are added: no ConcurrentModificationException", (long)this.count, (long)add.c);
        Assert.assertEquals((String)"All Start listeners are iterated over: no ConcurrentModificationException", (long)this.count, (long)starter.c);
    }

    @Test
    public void testPipelineStoppedListenersConcurrentModification() throws InterruptedException {
        CountDownLatch start = new CountDownLatch(1);
        PipelineStoppedCaller stopper = new PipelineStoppedCaller(this.pipeline, start);
        PipelineStopListenerAdder adder = new PipelineStopListenerAdder(this.pipeline, start);
        this.startThreads(stopper, adder, start);
        Assert.assertEquals((String)"All pipeline stop listeners is added", (long)this.count, (long)adder.c);
        Assert.assertEquals((String)"All stop call success", (long)this.count, (long)stopper.c);
    }

    @Test
    public void testFirePipelineFinishedListeners() throws Exception {
        LocalPipelineEngine pipeline = new LocalPipelineEngine();
        IExecutionFinishedListener mockListener = (IExecutionFinishedListener)Mockito.mock(IExecutionFinishedListener.class);
        pipeline.addExecutionFinishedListener(mockListener);
        pipeline.fireExecutionFinishedListeners();
        ((IExecutionFinishedListener)Mockito.verify((Object)mockListener)).finished((Object)pipeline);
    }

    @Test(expected=HopException.class)
    public void testFireExecutionFinishedListenersExceptionOnPipelineFinished() throws Exception {
        LocalPipelineEngine pipeline = new LocalPipelineEngine();
        IExecutionFinishedListener mockListener = (IExecutionFinishedListener)Mockito.mock(IExecutionFinishedListener.class);
        ((IExecutionFinishedListener)Mockito.doThrow(HopException.class).when((Object)mockListener)).finished((Object)pipeline);
        pipeline.addExecutionFinishedListener(mockListener);
        pipeline.fireExecutionFinishedListeners();
    }

    @Test
    public void testFinishStatus() throws Exception {
        while (this.pipeline.isRunning()) {
            Thread.sleep(1L);
        }
        Assert.assertEquals((Object)"Finished", (Object)this.pipeline.getStatusDescription());
    }

    private void verifyStopped(ITransform transform, int numberTimesCalled) throws HopException {
        ((ITransform)Mockito.verify((Object)transform, (VerificationMode)Mockito.times((int)numberTimesCalled))).setStopped(true);
        ((ITransform)Mockito.verify((Object)transform, (VerificationMode)Mockito.times((int)numberTimesCalled))).setSafeStopped(true);
        ((ITransform)Mockito.verify((Object)transform, (VerificationMode)Mockito.times((int)numberTimesCalled))).resumeRunning();
        ((ITransform)Mockito.verify((Object)transform, (VerificationMode)Mockito.times((int)numberTimesCalled))).stopRunning();
    }

    private TransformMetaDataCombi combi(ITransform transform, ITransformData data, TransformMeta transformMeta) {
        TransformMetaDataCombi transformMetaDataCombi = new TransformMetaDataCombi();
        transformMetaDataCombi.transform = transform;
        transformMetaDataCombi.data = data;
        transformMetaDataCombi.transformMeta = transformMeta;
        return transformMetaDataCombi;
    }

    private void startThreads(Runnable one, Runnable two, CountDownLatch start) throws InterruptedException {
        Thread th = new Thread(one);
        Thread tt = new Thread(two);
        th.start();
        tt.start();
        start.countDown();
        th.join();
        tt.join();
    }

    @Test
    public void testTwoPipelineGetSameLogChannelId() throws Exception {
        PipelineMeta meta = (PipelineMeta)Mockito.mock(PipelineMeta.class);
        ((PipelineMeta)Mockito.doReturn((Object)new String[]{"A", "B", "C"}).when((Object)meta)).listParameters();
        ((PipelineMeta)Mockito.doReturn((Object)"").when((Object)meta)).getParameterDescription(Matchers.anyString());
        ((PipelineMeta)Mockito.doReturn((Object)"").when((Object)meta)).getParameterDefault(Matchers.anyString());
        LocalPipelineEngine pipeline1 = new LocalPipelineEngine(meta);
        LocalPipelineEngine pipeline2 = new LocalPipelineEngine(meta);
        Assert.assertEquals((Object)pipeline1.getLogChannelId(), (Object)pipeline2.getLogChannelId());
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithFilename() {
        LocalPipelineEngine pipelineTest = new LocalPipelineEngine();
        boolean hasFilename = true;
        boolean hasRepoDir = false;
        pipelineTest.copyFrom(null);
        pipelineTest.setVariable("Internal.Entry.Current.Folder", "Original value defined at run execution");
        pipelineTest.setVariable("Internal.Pipeline.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        pipelineTest.setInternalEntryCurrentDirectory(hasFilename);
        Assert.assertEquals((Object)"file:///C:/SomeFilenameDirectory", (Object)pipelineTest.getVariable("Internal.Entry.Current.Folder"));
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithoutFilename() {
        LocalPipelineEngine pipelineTest = new LocalPipelineEngine();
        pipelineTest.copyFrom(null);
        boolean hasFilename = false;
        pipelineTest.setVariable("Internal.Entry.Current.Folder", "Original value defined at run execution");
        pipelineTest.setVariable("Internal.Pipeline.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        pipelineTest.setInternalEntryCurrentDirectory(hasFilename);
        Assert.assertEquals((Object)"Original value defined at run execution", (Object)pipelineTest.getVariable("Internal.Entry.Current.Folder"));
    }

    private class PipelineStartListenerFirer
    extends PipelineKicker {
        PipelineStartListenerFirer(IPipelineEngine<PipelineMeta> pipeline, CountDownLatch start) {
            super(pipeline, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                try {
                    this.pipeline.fireExecutionStartedListeners();
                }
                catch (HopException e) {
                    throw new RuntimeException();
                }
            }
        }
    }

    private class PipelineFinishListenerFirer
    extends PipelineKicker {
        PipelineFinishListenerFirer(IPipelineEngine<PipelineMeta> tr, CountDownLatch start) {
            super(tr, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                try {
                    this.pipeline.fireExecutionFinishedListeners();
                    this.pipeline.waitUntilFinished();
                }
                catch (HopException e) {
                    throw new RuntimeException();
                }
            }
        }
    }

    private class PipelineFinishListenerAdder
    extends PipelineKicker {
        PipelineFinishListenerAdder(IPipelineEngine<PipelineMeta> pipeline, CountDownLatch start) {
            super(pipeline, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                this.pipeline.addExecutionFinishedListener(PipelineTest.this.listener);
            }
        }
    }

    private class PipelineStopListenerAdder
    extends PipelineKicker {
        PipelineStopListenerAdder(IPipelineEngine<PipelineMeta> pipeline, CountDownLatch start) {
            super(pipeline, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                this.pipeline.addExecutionStoppedListener(PipelineTest.this.pipelineStoppedListener);
            }
        }
    }

    private class PipelineStoppedCaller
    extends PipelineKicker {
        PipelineStoppedCaller(IPipelineEngine<PipelineMeta> pipeline, CountDownLatch start) {
            super(pipeline, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                this.pipeline.stopAll();
            }
        }
    }

    private abstract class PipelineKicker
    implements Runnable {
        protected IPipelineEngine<PipelineMeta> pipeline;
        protected int c = 0;
        protected CountDownLatch start;
        protected int max;

        PipelineKicker(IPipelineEngine<PipelineMeta> pipeline, CountDownLatch start) {
            this.max = PipelineTest.this.count;
            this.pipeline = pipeline;
            this.start = start;
        }

        protected boolean isStopped() {
            ++this.c;
            return this.c >= this.max;
        }
    }
}

